DROP TABLE tbl_admin;

CREATE TABLE `tbl_admin` (
  `u_id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(30) NOT NULL,
  `uname` varchar(500) NOT NULL,
  `email` varchar(500) NOT NULL,
  `password` varchar(500) NOT NULL,
  `full_name` varchar(250) NOT NULL,
  `phone_no1` varchar(150) NOT NULL,
  `phone_no2` varchar(250) NOT NULL,
  `address1` varchar(500) NOT NULL,
  `address2` varchar(500) NOT NULL,
  `zipcode` int(11) NOT NULL,
  `image` varchar(500) NOT NULL,
  `pass_char` varchar(500) NOT NULL,
  `pass_action` int(11) NOT NULL,
  `screen_lock` int(11) NOT NULL,
  PRIMARY KEY (`u_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_admin VALUES("1","Admin","admin","admin@admin.com","e6e061838856bf47e1de730719fb2609","Strauss","9874561230","9988776655","SG Highway","Ahmedabad","984512","Medlyte_logo1520406881.png","","0","1");



DROP TABLE tbl_advance_master;

CREATE TABLE `tbl_advance_master` (
  `am_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `am_advance_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `am_pid` text NOT NULL,
  `in_pid` text,
  `im_invoice_id` text NOT NULL,
  `am_advance_amount` double(10,2) NOT NULL,
  `am_parent` int(11) DEFAULT NULL,
  `am_status` int(11) NOT NULL DEFAULT '0',
  `payment_option` int(11) NOT NULL DEFAULT '0',
  `pay_ref_no` varchar(255) DEFAULT NULL,
  `bill_type` varchar(255) DEFAULT NULL,
  `am_del` int(11) NOT NULL DEFAULT '0',
  `am_date` date NOT NULL,
  `am_created_by` int(11) DEFAULT NULL,
  `am_modify_by` int(11) DEFAULT '0',
  `am_delete_by` int(11) DEFAULT '0',
  `am_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `am_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`am_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_appointment_master;

CREATE TABLE `tbl_appointment_master` (
  `pam_id` int(11) NOT NULL AUTO_INCREMENT,
  `pam_pid` varchar(500) DEFAULT NULL,
  `seq_no` bigint(20) DEFAULT NULL,
  `dp_id` int(11) NOT NULL DEFAULT '0',
  `pam_type` varchar(50) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `pm_id` int(11) DEFAULT NULL,
  `pm_pid` varchar(200) DEFAULT NULL,
  `hm_id` int(11) DEFAULT NULL,
  `pam_appointment_type` varchar(50) DEFAULT NULL,
  `pam_app_date` date DEFAULT NULL,
  `pam_app_time` time DEFAULT NULL,
  `pam_appointment_duration` int(11) NOT NULL DEFAULT '0',
  `pam_case_type` varchar(30) DEFAULT NULL,
  `toct_id` int(11) NOT NULL DEFAULT '0',
  `pam_status` varchar(35) DEFAULT NULL,
  `pam_call` int(11) NOT NULL DEFAULT '0',
  `pam_call_notification` int(11) NOT NULL DEFAULT '0',
  `pam_del` int(11) NOT NULL DEFAULT '0',
  `pam_created_by` int(11) DEFAULT NULL,
  `pam_delete_by` int(11) DEFAULT NULL,
  `pam_created_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `pam_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`pam_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tbl_appointment_master VALUES("1","","","9","","1","1","20190103001","1","Walk","2019-01-03","13:26:00","5","New","1","1","0","0","0","1","","2019-01-03 13:28:38","2019-04-22 10:35:37");
INSERT INTO tbl_appointment_master VALUES("2","","","9","","1","2","20190122001","1","Walk","2019-01-22","12:15:00","5","New","1","1","0","0","0","1","","2019-01-22 12:28:03","2019-04-22 10:35:37");



DROP TABLE tbl_atd_logs;

CREATE TABLE `tbl_atd_logs` (
  `tal_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `tapm_id` int(11) NOT NULL DEFAULT '0',
  `tal_transfer_type` text,
  `tal_old_dp_id` int(11) NOT NULL DEFAULT '0',
  `tal_new_dp_id` int(11) NOT NULL DEFAULT '0',
  `tal_old_admitting_doctor` int(11) NOT NULL DEFAULT '0',
  `tal_new_admitting_doctor` int(11) NOT NULL DEFAULT '0',
  `tal_old_twm_id` int(11) NOT NULL DEFAULT '0',
  `tal_new_twm_id` int(11) NOT NULL DEFAULT '0',
  `tal_old_twrm_id` int(11) NOT NULL DEFAULT '0',
  `tal_new_twrm_id` int(11) NOT NULL DEFAULT '0',
  `tal_modify_by` int(11) NOT NULL DEFAULT '0',
  `tal_create_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `tal_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_atd_patient_master;

CREATE TABLE `tbl_atd_patient_master` (
  `tapm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `dp_id` int(11) NOT NULL DEFAULT '0',
  `twm_id` int(11) NOT NULL DEFAULT '0',
  `twrm_id` int(11) NOT NULL DEFAULT '0',
  `tapm_admitting_doctor` int(11) DEFAULT NULL,
  `tapm_admitting_date` date DEFAULT NULL,
  `tapm_admitting_time` time DEFAULT NULL,
  `in_pid` varchar(250) DEFAULT NULL,
  `seq_no` bigint(20) NOT NULL,
  `ip_barcode` varchar(500) DEFAULT NULL,
  `tapm_care_taker` varchar(250) DEFAULT NULL,
  `tapm_contact` varchar(250) DEFAULT NULL,
  `tapm_relationship` varchar(250) DEFAULT NULL,
  `tapm_insurance_name` varchar(250) DEFAULT NULL,
  `tapm_policy_number` varchar(250) DEFAULT NULL,
  `tapm_tpa_number` varchar(250) DEFAULT NULL,
  `tapm_mlc_number` varchar(500) DEFAULT NULL,
  `tapm_discharge_remarks` text,
  `tapm_inp_ref_id` int(11) NOT NULL DEFAULT '0',
  `tapm_inp_ref_name` varchar(500) DEFAULT NULL,
  `tidt_id` int(11) NOT NULL DEFAULT '0',
  `tapm_readmit` int(11) NOT NULL DEFAULT '0',
  `tapm_discharge` int(11) NOT NULL DEFAULT '0',
  `tapm_delete` int(11) NOT NULL DEFAULT '0',
  `tapm_created_by` int(11) DEFAULT NULL,
  `tapm_modify_by` int(11) DEFAULT NULL,
  `tapm_delete_by` int(11) NOT NULL DEFAULT '0',
  `tapm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tapm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tapm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_biiling_insentive_master;

CREATE TABLE `tbl_biiling_insentive_master` (
  `tbinsmid` int(11) NOT NULL AUTO_INCREMENT,
  `tbinsm_hmid` int(11) NOT NULL DEFAULT '0',
  `tbinsm_billing_type` varchar(255) DEFAULT NULL,
  `tbinsm_billing_id` varchar(255) DEFAULT NULL,
  `tbinsm_patientid` varchar(500) DEFAULT NULL,
  `tbinsm_inpatientid` varchar(500) DEFAULT NULL,
  `tbinsm_fix_inc` int(11) NOT NULL DEFAULT '0',
  `tbinsm_est_pname` varchar(1000) DEFAULT NULL,
  `tbinsm_invoice_id` varchar(255) NOT NULL DEFAULT '0',
  `tbinsm_invoice_prid` int(11) NOT NULL DEFAULT '0',
  `tbinsm_invsevice_prid` int(11) NOT NULL DEFAULT '0',
  `tbinsm_invoice_ser_price` double(10,2) NOT NULL,
  `tbinsm_invoice_line_total` double(10,2) NOT NULL,
  `tbinsm_total_billing_amount` double(10,2) NOT NULL,
  `tbinsm_invoice_del` int(11) NOT NULL DEFAULT '0',
  `tbinsm_invoice_cansel` int(11) NOT NULL DEFAULT '0',
  `tbinsm_invoice_created_date` date NOT NULL,
  `tbinsm_invoice_createby` int(11) NOT NULL DEFAULT '0',
  `tbinsm_main_scat` int(11) NOT NULL DEFAULT '0',
  `tbinsm_serviceid` int(11) NOT NULL DEFAULT '0',
  `tbinsm_ins_userid` int(11) NOT NULL DEFAULT '0',
  `tbinsm_ins_rtype` varchar(255) DEFAULT NULL,
  `tbinsm_ins_amount` double(10,2) NOT NULL,
  `tbinsm_ins_total_amount` double(10,2) NOT NULL,
  `tbinsm_packageid` int(11) NOT NULL DEFAULT '0',
  `tbinsm_groupid` int(11) NOT NULL DEFAULT '0',
  `tbinsm_gst_type` varchar(255) DEFAULT NULL,
  `tbinsm_cgst_per` double(10,2) NOT NULL,
  `tbinsm_sgst_per` double(10,2) NOT NULL,
  `tbinsm_cgst` double(10,2) NOT NULL,
  `tbinsm_sgst` double(10,2) NOT NULL,
  `tbinsm_tax_amt` double(10,2) NOT NULL,
  `tbinsm_total_cgst` double(10,2) NOT NULL,
  `tbinsm_total_sgst` double(10,2) NOT NULL,
  `tbinsm_total_net_tax_amt` double(10,2) NOT NULL,
  `tbinsm_total_gross` double(10,2) NOT NULL,
  `tbinsm_total_discount` double(10,2) NOT NULL,
  `tbinsm_page_type` varchar(1000) DEFAULT NULL,
  `tbinsm_create_date` date NOT NULL,
  `tbinsm_createby` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tbinsmid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_biiling_payment_option;

CREATE TABLE `tbl_biiling_payment_option` (
  `bpid` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `default_payment` int(11) NOT NULL DEFAULT '0',
  `del` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bpid`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO tbl_biiling_payment_option VALUES("1","Bank Credit Cards","0","0");
INSERT INTO tbl_biiling_payment_option VALUES("2","Online Bank Transfers","0","0");
INSERT INTO tbl_biiling_payment_option VALUES("3","Bank Transfers","0","0");
INSERT INTO tbl_biiling_payment_option VALUES("4","Mobile Payments","1","0");
INSERT INTO tbl_biiling_payment_option VALUES("5","E-wallet Payments","0","0");



DROP TABLE tbl_bill_account_name;

CREATE TABLE `tbl_bill_account_name` (
  `tban_id` int(11) NOT NULL AUTO_INCREMENT,
  `tban_account_name` varchar(250) NOT NULL,
  `tban_default` int(11) NOT NULL DEFAULT '0',
  `tban_del` int(11) NOT NULL DEFAULT '0',
  `tban_created_by` int(11) NOT NULL DEFAULT '0',
  `tban_modify_by` int(11) NOT NULL DEFAULT '0',
  `tban_delete_by` int(11) NOT NULL DEFAULT '0',
  `tban_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tban_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tban_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_bill_account_name VALUES("1","Umiya Childern Hospital","1","0","1","0","0","2018-12-29 10:00:03","2018-12-29 10:00:08");



DROP TABLE tbl_bill_credit_master;

CREATE TABLE `tbl_bill_credit_master` (
  `tbcm_id` int(20) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `pid` text NOT NULL,
  `in_pid` text,
  `im_invoice_id` text NOT NULL,
  `tbcm_invoice_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `tbcm_sub_total` double(10,2) NOT NULL,
  `tbcm_rebate_type` varchar(250) NOT NULL,
  `tbcm_rebate_amount` double(10,2) NOT NULL,
  `tbcm_grand_total` double(10,2) NOT NULL,
  `tbcm_notes` varchar(250) NOT NULL,
  `tbcm_payment_status` int(11) NOT NULL DEFAULT '0',
  `tbcm_parent` int(11) DEFAULT '0',
  `tbcm_status` int(11) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `tbcm_taxtion` varchar(255) NOT NULL,
  `tbcm_total_cgst` double(10,2) NOT NULL,
  `tbcm_total_sgst` double(10,2) NOT NULL,
  `tbcm_total_net_tax_amt` double(10,2) NOT NULL,
  `tbcm_total_gross` double(10,2) NOT NULL,
  `tbcm_total_discount` double(10,2) NOT NULL,
  `tbcm_accountant` int(11) NOT NULL DEFAULT '0',
  `im_cum_ri_invoice_id` varchar(300) DEFAULT NULL,
  `im_invoice_type` varchar(255) DEFAULT NULL,
  `tbcm_invoice_date` date NOT NULL,
  `tbcm_created_id` int(11) DEFAULT NULL,
  `tbcm_modify_by` int(11) DEFAULT '0',
  `tbcm_delete_by` int(11) DEFAULT '0',
  `tbcm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbcm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbcm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_bill_credit_service;

CREATE TABLE `tbl_bill_credit_service` (
  `tbcs_id` int(11) NOT NULL AUTO_INCREMENT,
  `tbcs_invoice_id` text NOT NULL,
  `tbms_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `tbcs_price` double(10,2) NOT NULL,
  `discount` int(11) NOT NULL,
  `tax_amount` int(11) NOT NULL DEFAULT '0',
  `tbcs_qty` int(11) NOT NULL,
  `tbcs_total` double(10,2) NOT NULL,
  `tbcs_parent` int(11) DEFAULT '0',
  `tbcs_status` int(11) DEFAULT '0',
  `tbcs_sgroup` int(11) NOT NULL DEFAULT '0',
  `tbcs_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbcm_id` int(21) NOT NULL DEFAULT '0',
  `hm_id` int(21) NOT NULL DEFAULT '0',
  `bill_id` int(21) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `tbcs_cgst_per` double(10,2) NOT NULL,
  `tbcs_sgst_per` double(10,2) NOT NULL,
  `tbcs_cgst` double(10,2) NOT NULL,
  `tbcs_sgst` double(10,2) NOT NULL,
  `tbcs_tax_amt` double(10,2) NOT NULL,
  `tbcs_ser_description` varchar(2000) DEFAULT NULL,
  `tbcs_services_date` date DEFAULT NULL,
  `tbcs_delete_by` int(21) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tbcs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_bill_estimate_master;

CREATE TABLE `tbl_bill_estimate_master` (
  `tbem_id` int(20) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `tbem_pid` text NOT NULL,
  `in_pid` text,
  `tbem_invoice_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `tbem_sub_total` double(10,2) NOT NULL,
  `tbem_rebate_type` varchar(250) NOT NULL,
  `tbem_rebate_amount` double(10,2) NOT NULL,
  `tbem_grand_total` double(10,2) NOT NULL,
  `tbem_notes` varchar(250) NOT NULL,
  `tbem_payment_status` int(11) NOT NULL DEFAULT '0',
  `tbem_parent` int(11) DEFAULT NULL,
  `tbem_status` int(11) NOT NULL DEFAULT '0',
  `tbem_pname` varchar(255) DEFAULT NULL,
  `tbem_pcontact` varchar(20) DEFAULT NULL,
  `tbem_paddress` varchar(500) DEFAULT NULL,
  `bill_type` varchar(255) DEFAULT NULL,
  `tbem_taxtion` varchar(255) NOT NULL,
  `tbem_total_cgst` double(10,2) NOT NULL,
  `tbem_total_sgst` double(10,2) NOT NULL,
  `tbem_total_net_tax_amt` double(10,2) NOT NULL,
  `tbem_total_gross` double(10,2) NOT NULL,
  `tbem_total_discount` double(10,2) NOT NULL,
  `tbem_invoice_date` date NOT NULL,
  `tbem_created_id` int(11) DEFAULT NULL,
  `tbem_modify_by` int(11) DEFAULT NULL,
  `tbem_delete_by` int(11) DEFAULT NULL,
  `tbem_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbem_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_bill_estimate_service;

CREATE TABLE `tbl_bill_estimate_service` (
  `tbes_id` int(11) NOT NULL AUTO_INCREMENT,
  `im_invoice_id` text NOT NULL,
  `tbms_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `tbes_price` double(10,2) NOT NULL,
  `discount` int(11) NOT NULL DEFAULT '0',
  `tax_amount` int(11) NOT NULL DEFAULT '0',
  `tbes_qty` int(11) NOT NULL,
  `tbes_total` double(10,2) NOT NULL,
  `tbes_sgroup` int(11) NOT NULL DEFAULT '0',
  `tbes_parent` int(11) NOT NULL DEFAULT '0',
  `tbes_status` int(11) DEFAULT '0',
  `tbem_id` int(21) NOT NULL DEFAULT '0',
  `hm_id` int(21) NOT NULL DEFAULT '0',
  `bill_id` int(21) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `tbes_cgst_per` double(10,2) NOT NULL,
  `tbes_sgst_per` double(10,2) NOT NULL,
  `tbes_cgst` double(10,2) NOT NULL,
  `tbes_sgst` double(10,2) NOT NULL,
  `tbes_tax_amt` double(10,2) NOT NULL,
  `tbes_ser_description` varchar(2000) DEFAULT NULL,
  `tbes_services_date` date DEFAULT NULL,
  `tbes_delete_by` int(11) NOT NULL DEFAULT '0',
  `tbes_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_bill_main_service;

CREATE TABLE `tbl_bill_main_service` (
  `tbms_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `tbsg_id` int(11) NOT NULL DEFAULT '0',
  `tbpc_id` int(11) NOT NULL DEFAULT '0',
  `tbms_service_name` varchar(250) DEFAULT NULL,
  `tbms_price` double DEFAULT '0',
  `tbms_cgst` float NOT NULL DEFAULT '0',
  `tbms_sgst` float NOT NULL DEFAULT '0',
  `tbms_note` text,
  `set_incentive` int(11) NOT NULL DEFAULT '0',
  `tbms_incentive` float NOT NULL DEFAULT '0',
  `tbms_tim_id` varchar(1000) DEFAULT NULL,
  `tbms_ins_price` varchar(1000) DEFAULT NULL,
  `tbms_ins_type` varchar(1000) DEFAULT NULL,
  `tbms_ins_total` varchar(1000) DEFAULT NULL,
  `tbms_del` int(11) NOT NULL DEFAULT '0',
  `tbms_created_by` int(11) NOT NULL DEFAULT '0',
  `tbms_modify_by` int(11) NOT NULL DEFAULT '0',
  `tbms_delete_by` int(11) NOT NULL DEFAULT '0',
  `tbms_created_date` datetime DEFAULT NULL,
  `tbms_modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`tbms_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tbl_bill_main_service VALUES("1","1","1","1","Follow up","250","0","0","","0","0","","","","","0","1","0","0","","");
INSERT INTO tbl_bill_main_service VALUES("2","1","1","1","Consultation","500","0","0","","0","0","","","","","0","1","0","0","","");



DROP TABLE tbl_bill_patient_category;

CREATE TABLE `tbl_bill_patient_category` (
  `tbpc_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_type` varchar(50) NOT NULL,
  `tbpc_patient_category` varchar(250) NOT NULL,
  `tbpc_default` int(11) NOT NULL DEFAULT '0',
  `tbpc_del` int(11) NOT NULL DEFAULT '0',
  `tbpc_created_by` int(11) NOT NULL DEFAULT '0',
  `tbpc_modify_by` int(11) NOT NULL DEFAULT '0',
  `tbpc_delete_by` int(11) DEFAULT '0',
  `tbpc_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbpc_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbpc_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_bill_patient_category VALUES("1","1","opd","general","1","0","1","0","0","2019-01-03 13:45:10","2019-01-03 13:56:39");



DROP TABLE tbl_bill_reatil_sale_service;

CREATE TABLE `tbl_bill_reatil_sale_service` (
  `tbrss_id` int(11) NOT NULL AUTO_INCREMENT,
  `im_invoice_id` text,
  `tbms_id` int(11) NOT NULL DEFAULT '0',
  `service_id` int(11) NOT NULL DEFAULT '0',
  `tbrss_price` double(10,2) NOT NULL,
  `discount` int(11) NOT NULL DEFAULT '0',
  `tax_amount` int(11) NOT NULL DEFAULT '0',
  `tbrss_qty` int(11) NOT NULL DEFAULT '0',
  `tbrss_total` double(10,2) NOT NULL,
  `tbrss_parent` int(11) NOT NULL DEFAULT '0',
  `tbrss_status` int(11) NOT NULL DEFAULT '0',
  `tbrss_sgroup` int(11) NOT NULL DEFAULT '0',
  `tbrsm_id` int(21) NOT NULL DEFAULT '0',
  `hm_id` int(21) NOT NULL DEFAULT '0',
  `bill_id` int(21) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `tbrss_cgst_per` double(10,2) NOT NULL DEFAULT '0.00',
  `tbrss_sgst_per` double(10,2) NOT NULL DEFAULT '0.00',
  `tbrss_cgst` double(10,2) NOT NULL,
  `tbrss_sgst` double(10,2) NOT NULL,
  `tbrss_tax_amt` double(10,2) NOT NULL,
  `tbrss_ser_description` varchar(2000) DEFAULT NULL,
  `tbrss_services_date` date DEFAULT NULL,
  `tbrss_delete_by` int(11) NOT NULL DEFAULT '0',
  `tbrss_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbrss_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_bill_reatil_sale_service VALUES("1","RS-201901001","1","2","600.00","0","0","1","600.00","0","0","0","1","1","20","opd","0.00","0.00","0.00","0.00","0.00","","","0","2019-01-03 13:57:37");



DROP TABLE tbl_bill_refund_master;

CREATE TABLE `tbl_bill_refund_master` (
  `tbrm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `tbrm_receipt_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `im_invoice_id` text NOT NULL,
  `tbrm_pid` text NOT NULL,
  `in_pid` text,
  `tbrm_total` double NOT NULL,
  `tbrm_given_amount` double NOT NULL,
  `tbrm_pending_amount` double NOT NULL,
  `tbrm_advance_id` int(11) DEFAULT NULL,
  `tbrm_date` date NOT NULL,
  `tbrm_parent` int(11) DEFAULT NULL,
  `tbrm_status` int(11) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `tbrm_advance_id_new` varchar(255) DEFAULT NULL,
  `im_invoice_type` varchar(255) DEFAULT NULL,
  `payment_option` int(11) NOT NULL DEFAULT '0',
  `pay_ref_no` varchar(255) DEFAULT NULL,
  `tbrm_created_id` int(11) DEFAULT NULL,
  `tbrm_modify_id` int(11) DEFAULT '0',
  `tbrm_delete_id` int(11) DEFAULT '0',
  `tbrm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbrm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbrm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_bill_retail_sale_master;

CREATE TABLE `tbl_bill_retail_sale_master` (
  `tbrsm_id` int(20) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `tbrsm_pid` text NOT NULL,
  `in_pid` text,
  `tbrsm_invoice_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `tbrsm_sub_total` double(10,2) NOT NULL,
  `tbrsm_rebate_type` varchar(250) NOT NULL,
  `tbrsm_rebate_amount` float(10,2) NOT NULL,
  `tbrsm_grand_total` double(10,2) NOT NULL,
  `tbrsm_notes` varchar(250) NOT NULL,
  `tbrsm_payment_status` int(11) NOT NULL,
  `tbrsm_parent` int(11) NOT NULL DEFAULT '0',
  `tbrsm_status` int(11) NOT NULL DEFAULT '0',
  `payment_option` int(11) NOT NULL DEFAULT '0',
  `pay_ref_no` varchar(255) DEFAULT NULL,
  `tbrsm_accountant` int(11) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `tbrsm_taxtion` varchar(255) NOT NULL,
  `tbrsm_total_cgst` double(10,2) NOT NULL,
  `tbrsm_total_sgst` double(10,2) NOT NULL,
  `tbrsm_total_net_tax_amt` double(10,2) NOT NULL,
  `tbrsm_total_gross` double(10,2) NOT NULL,
  `tbrsm_total_discount` double(10,2) NOT NULL,
  `tbrsm_invoice_date` date NOT NULL,
  `tbrsm_created_id` int(11) NOT NULL DEFAULT '0',
  `tbrsm_modify_by` int(11) NOT NULL DEFAULT '0',
  `tbrsm_delete_by` int(11) NOT NULL DEFAULT '0',
  `tbrsm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbrsm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbrsm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_bill_retail_sale_master VALUES("1","1","20","1","20190103001","","RS-201901001","201901001","600.00","amt","0.00","600.00","","0","0","0","4","","1","opd","nongst","0.00","0.00","0.00","0.00","0.00","2019-01-03","1","0","0","2019-01-03 13:57:37","2019-02-07 15:03:58");



DROP TABLE tbl_bill_service_group;

CREATE TABLE `tbl_bill_service_group` (
  `tbsg_id` int(11) NOT NULL AUTO_INCREMENT,
  `tbpc_id` int(11) NOT NULL DEFAULT '0',
  `tbsg_service_group` varchar(250) NOT NULL,
  `tbsg_del` int(11) NOT NULL DEFAULT '0',
  `tbsg_created_by` int(11) NOT NULL DEFAULT '0',
  `tbsg_modify_by` int(11) NOT NULL DEFAULT '0',
  `tbsg_delete_by` int(11) NOT NULL DEFAULT '0',
  `tbsg_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbsg_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbsg_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_bill_service_group VALUES("1","0","a","0","1","0","0","2019-01-03 13:55:34","");



DROP TABLE tbl_billing;

CREATE TABLE `tbl_billing` (
  `bill_id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_type` varchar(50) NOT NULL,
  `bill_name` varchar(250) NOT NULL,
  `hm_id` int(11) NOT NULL,
  `bill_mm_id` int(11) NOT NULL,
  `bill_default` int(11) NOT NULL DEFAULT '0',
  `bill_del` int(11) NOT NULL DEFAULT '0',
  `bill_create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `bill_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `bill_created_by` int(11) NOT NULL DEFAULT '0',
  `bill_modify_by` int(11) NOT NULL DEFAULT '0',
  `bill_deleted_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bill_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_billing VALUES("1","opd","OPD Billing","1","20","0","0","2018-12-29 10:00:57","2018-12-29 10:00:57","1","0","0");



DROP TABLE tbl_billing_taxation;

CREATE TABLE `tbl_billing_taxation` (
  `tdt_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `tbt_type` varchar(50) DEFAULT NULL,
  `tbt_created_by` int(11) NOT NULL DEFAULT '0',
  `tbt_modify_by` int(11) DEFAULT '0',
  `tbt_delete_by` int(11) DEFAULT '0',
  `tbt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdt_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tbl_billing_taxation VALUES("1","1","nongst","1","1","0","2019-01-30 16:26:17","2019-01-30 16:27:00");
INSERT INTO tbl_billing_taxation VALUES("2","2","nongst","1","1","0","2019-01-30 16:26:56","2019-01-30 16:28:02");



DROP TABLE tbl_case_custom_option;

CREATE TABLE `tbl_case_custom_option` (
  `tcco_id` int(11) NOT NULL AUTO_INCREMENT,
  `tcco_name` varchar(70) NOT NULL,
  `tcco_status` int(11) NOT NULL,
  `tcco_special` int(11) NOT NULL,
  `tcco_font` varchar(30) NOT NULL,
  PRIMARY KEY (`tcco_id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=latin1;

INSERT INTO tbl_case_custom_option VALUES("1","since ","0","0","btn-info");
INSERT INTO tbl_case_custom_option VALUES("2","from ","0","0","btn-info");
INSERT INTO tbl_case_custom_option VALUES("3","for ","0","0","btn-info");
INSERT INTO tbl_case_custom_option VALUES("4","on","0","0","btn-info");
INSERT INTO tbl_case_custom_option VALUES("5","-","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("6","0","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("7","1","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("8","2","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("9","3","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("10","4","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("11","5","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("12","6","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("13","7","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("14","8","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("15","9","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("16","00","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("17","000","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("18","x","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("19","+","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("20","/","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("21",".","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("22",",","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("23","?","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("24","%","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("25","&","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("26","(","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("27",")","0","1","btn-info");
INSERT INTO tbl_case_custom_option VALUES("28","Day(s)","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("29","Week(s)","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("30","Month(s)","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("31","Year(s)","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("32","hour(s)","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("33","Frequency","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("34","Intensity","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("35","On & off","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("36","Increased","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("37","Decreased","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("38","Stable","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("39","NAD","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("40","Intermittent","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("41","Aggravated","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("42","Relieved","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("43","Anterior","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("44","Posterior","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("45","Medial","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("46","Lateral","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("47","Unilateral","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("48","Bilateral","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("49","Left","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("50","Right","0","0","bg-olive");
INSERT INTO tbl_case_custom_option VALUES("51","Space","0","1","btn-default");
INSERT INTO tbl_case_custom_option VALUES("52","Enter","0","1","btn-default");



DROP TABLE tbl_case_document;

CREATE TABLE `tbl_case_document` (
  `tcd_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `file` varchar(750) DEFAULT NULL,
  `tcd_description` longtext,
  `tcd_del` int(11) NOT NULL DEFAULT '0',
  `tcd_created_by` int(11) NOT NULL DEFAULT '0',
  `tcd_modify_by` int(11) DEFAULT NULL,
  `tcd_delete_by` int(11) NOT NULL DEFAULT '0',
  `tcd_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ppn_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tcd_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_case_manager;

CREATE TABLE `tbl_case_manager` (
  `tcm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) DEFAULT NULL,
  `pm_id` int(11) DEFAULT NULL,
  `pm_pid` varchar(250) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `tcm_datetime` datetime DEFAULT NULL,
  `tcm_weight` varchar(150) DEFAULT NULL,
  `tcm_bsa` varchar(150) DEFAULT NULL,
  `case_type` int(11) DEFAULT NULL,
  `case_consultation_type` varchar(255) DEFAULT NULL,
  `tcm_history_box` longblob,
  `tcm_examination_box` longblob,
  `tcm_chief_com` longtext CHARACTER SET utf8,
  `tcm_assessment_notes` longtext CHARACTER SET utf8,
  `tcm_history_pre_illness` longtext CHARACTER SET utf8,
  `tcm_pre_evevnt` longtext CHARACTER SET utf8,
  `tcm_history` longtext CHARACTER SET utf8,
  `tcm_permanent_history` longblob,
  `tcm_mse` longtext CHARACTER SET utf8,
  `tcm_pas` varchar(750) CHARACTER SET utf8 DEFAULT NULL,
  `tclvp_id` longtext,
  `tcva_id` longblob,
  `tcei_id` longtext,
  `tcfe_id` longtext,
  `tca_id` varchar(750) DEFAULT NULL,
  `tcv_id` varchar(750) DEFAULT NULL,
  `tcbc_id` varchar(750) DEFAULT NULL,
  `tcd_id` varchar(750) DEFAULT NULL,
  `tcm_tmm_id` varchar(750) DEFAULT NULL,
  `tcm_tmr_type` varchar(1000) DEFAULT NULL,
  `tcm_tmr_tmm_dose` varchar(1000) DEFAULT NULL,
  `tcm_tmm_medicine_name` longtext CHARACTER SET utf8,
  `tcm_tmm_generic_name` longtext,
  `tcm_tmm_final_dose` varchar(750) DEFAULT NULL,
  `tcm_tmm_frequency` varchar(750) DEFAULT NULL,
  `tcm_tmm_type` varchar(1000) CHARACTER SET utf8 DEFAULT NULL,
  `tcm_tmm_strength` varchar(1000) CHARACTER SET utf8 DEFAULT NULL,
  `tcm_tmm_unit` varchar(1000) CHARACTER SET utf8 DEFAULT NULL,
  `tcm_tmm_time` varchar(1000) CHARACTER SET utf8 DEFAULT NULL,
  `tcm_tmm_days` varchar(750) DEFAULT NULL,
  `tcm_tmm_duration_type` varchar(750) DEFAULT NULL,
  `tcm_tmm_custom` longtext CHARACTER SET utf8,
  `tcm_tmm_template_id` varchar(750) CHARACTER SET utf8 DEFAULT NULL,
  `tcm_tmm_chk_value` varchar(750) DEFAULT NULL,
  `tcm_investigation` text,
  `tcm_advice` longtext,
  `tcm_pdf` int(11) NOT NULL DEFAULT '0',
  `tcm_followup_date` date DEFAULT NULL,
  `tcm_followup_advice` longtext,
  `tcm_lmp_date` date DEFAULT NULL,
  `tcm_edd_date` date DEFAULT NULL,
  `tcm_del` int(11) NOT NULL DEFAULT '0',
  `tcm_created_by` int(11) NOT NULL DEFAULT '0',
  `tcm_modify_by` int(11) DEFAULT NULL,
  `tcm_delete_by` int(11) NOT NULL DEFAULT '0',
  `tcm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tcm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tcm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tbl_case_manager VALUES("1","1","1","20190103001","1","2019-01-03 13:43:00","","","0","First Consultation","<p><b>fever</b>5&nbsp;Month(s)</p>","","","","","","","","","","","","","","","","","2,1","","","","syp. calpol","paracetamol","","","","","","After Food","3","day","","111","1","","nbgh","0","2019-01-08","","1970-01-01","1970-01-01","0","1","","0","2019-01-03 13:43:06","");
INSERT INTO tbl_case_manager VALUES("2","1","2","20190122001","1","2019-01-22 12:32:00","","","0","First Consultation","<p>fever since 5 days</p><p>cold since 3 days</p>","<p><b>cvs</b></p><p>&nbsp;&nbsp;&nbsp;s1s2-nomal</p><p><b>RS</b></p><p>&nbsp;&nbsp;&nbsp;B/L AEBE</p><p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;B/LN WHEEZING</p><p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;B/LN WHEEZING</p>","","","","","","","","","","","","","","","","3","","","","","","","","","","","","","","","","","","","0","1970-01-01","","1970-01-01","1970-01-01","0","1","","0","2019-01-22 12:32:22","");



DROP TABLE tbl_casemanager_allergies;

CREATE TABLE `tbl_casemanager_allergies` (
  `tca_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(500) DEFAULT NULL,
  `tca_del` int(11) NOT NULL DEFAULT '0',
  `tca_created_by` int(11) DEFAULT NULL,
  `tca_modify_by` int(11) DEFAULT NULL,
  `tca_delete_by` int(11) DEFAULT NULL,
  `tca_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tca_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tca_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_casemanager_b_composition;

CREATE TABLE `tbl_casemanager_b_composition` (
  `tcbc_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) DEFAULT NULL,
  `pm_pid` varchar(500) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `height` varchar(11) DEFAULT NULL,
  `weight` varchar(11) DEFAULT NULL,
  `bmi` varchar(252) DEFAULT NULL,
  `bmr` varchar(250) DEFAULT NULL,
  `bsa` varchar(150) DEFAULT NULL,
  `tcbc_del` int(11) NOT NULL DEFAULT '0',
  `tcbc_created_by` int(11) DEFAULT NULL,
  `tcbc_modify_by` int(11) DEFAULT NULL,
  `tcbc_delete_by` int(11) DEFAULT NULL,
  `tcbc_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tcbc_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tcbc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_casemanager_diagnosis;

CREATE TABLE `tbl_casemanager_diagnosis` (
  `tcd_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `diagnosis` varchar(500) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `tcd_del` int(11) NOT NULL DEFAULT '0',
  `tcd_created_by` int(11) DEFAULT NULL,
  `tcd_modify_by` int(11) DEFAULT NULL,
  `tcd_delete_by` int(11) DEFAULT NULL,
  `tcd_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tcd_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tcd_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO tbl_casemanager_diagnosis VALUES("1","1","20190103001","1","Fever- unspecified","fever","0","1","","","2019-01-03 13:40:04","");
INSERT INTO tbl_casemanager_diagnosis VALUES("2","1","20190103001","1","Fever- unspecified","fever","0","1","","","2019-01-03 13:42:17","");
INSERT INTO tbl_casemanager_diagnosis VALUES("3","2","20190122001","1","URI","Provisional","0","1","","","2019-01-22 12:31:37","");



DROP TABLE tbl_casemanager_eye_iop;

CREATE TABLE `tbl_casemanager_eye_iop` (
  `tcei_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) DEFAULT NULL,
  `pm_pid` varchar(500) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tcei_right_eye` varchar(500) DEFAULT NULL,
  `tcei_left_eye` varchar(500) DEFAULT NULL,
  `tcei_date` date NOT NULL,
  `tcei_time` time NOT NULL,
  `tcei_remarks` text,
  `tcei_del` int(11) NOT NULL DEFAULT '0',
  `tcei_created_by` int(11) DEFAULT NULL,
  `tcei_modify_by` int(11) DEFAULT NULL,
  `tcei_delete_by` int(11) DEFAULT NULL,
  `tcei_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tcei_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tcei_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_casemanager_followup_care;

CREATE TABLE `tbl_casemanager_followup_care` (
  `tcfc_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `tcfc_temp_name` varchar(750) DEFAULT NULL,
  `tcfc_temp_msg` longtext,
  `tcfc_schedule_date` date DEFAULT NULL,
  `tcfc_status` int(11) NOT NULL DEFAULT '0',
  `tcfc_msg_request_id` longtext,
  `tcfc_msg_message` longtext,
  `tcfc_msg_action` int(11) NOT NULL DEFAULT '0',
  `tcfc_del` int(11) NOT NULL DEFAULT '0',
  `tcfc_created_by` int(11) DEFAULT NULL,
  `tcfc_modify_by` int(11) DEFAULT NULL,
  `tcfc_delete_by` int(11) DEFAULT NULL,
  `tcfc_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tcfc_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tcfc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_casemanager_fundus_examination;

CREATE TABLE `tbl_casemanager_fundus_examination` (
  `tcfe_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) DEFAULT NULL,
  `pm_pid` varchar(500) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tcfe_right_eye` varchar(500) DEFAULT NULL,
  `tcfe_left_eye` varchar(500) DEFAULT NULL,
  `tcfe_date` date NOT NULL,
  `tcfe_time` time NOT NULL,
  `tcfe_remarks` text,
  `tcfe_del` int(11) NOT NULL DEFAULT '0',
  `tcfe_created_by` int(11) DEFAULT NULL,
  `tcfe_modify_by` int(11) DEFAULT NULL,
  `tcfe_delete_by` int(11) DEFAULT NULL,
  `tcfe_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tcfe_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tcfe_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_casemanager_visual_acuity;

CREATE TABLE `tbl_casemanager_visual_acuity` (
  `tcva_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) DEFAULT NULL,
  `pm_pid` varchar(500) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `right_eye` varchar(500) DEFAULT NULL,
  `left_eye` varchar(500) DEFAULT NULL,
  `tcva_date` date NOT NULL,
  `tcva_time` time NOT NULL,
  `remarks` text,
  `tcva_del` int(11) NOT NULL DEFAULT '0',
  `tcva_created_by` int(11) DEFAULT NULL,
  `tcva_modify_by` int(11) DEFAULT NULL,
  `tcva_delete_by` int(11) DEFAULT NULL,
  `tcva_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tcva_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tcva_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_casemanager_vitals;

CREATE TABLE `tbl_casemanager_vitals` (
  `tcv_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL,
  `pm_pid` varchar(500) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `temp` varchar(11) DEFAULT NULL,
  `pres` varchar(11) DEFAULT NULL,
  `resp_rate` varchar(11) DEFAULT NULL,
  `blood_press` varchar(11) DEFAULT NULL,
  `spo2` varchar(11) DEFAULT NULL,
  `tcv_del` int(11) NOT NULL DEFAULT '0',
  `tcv_created_by` int(11) DEFAULT NULL,
  `tcv_modify_by` int(11) DEFAULT NULL,
  `tcv_delete_by` int(11) DEFAULT NULL,
  `tcv_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tcv_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tcv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_casesheet_option;

CREATE TABLE `tbl_casesheet_option` (
  `tco_id` int(11) NOT NULL AUTO_INCREMENT,
  `tco_name` varchar(500) NOT NULL,
  `tco_dp_id` int(11) NOT NULL DEFAULT '0',
  `tco_del` int(11) NOT NULL DEFAULT '0',
  `tco_created_by` int(11) NOT NULL,
  PRIMARY KEY (`tco_id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;

INSERT INTO tbl_casesheet_option VALUES("1","History Box","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("2","Examination Box","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("6","Permanent History","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("8","Lab Report","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("9","Allergies","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("10","Vitals","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("11","Body Composition","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("12","Diagnosis","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("13","Prescription","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("14","Investigation","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("15","Advice","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("16","Followup Advice","0","0","1");
INSERT INTO tbl_casesheet_option VALUES("17","Visual Acuity","17","0","1");
INSERT INTO tbl_casesheet_option VALUES("18","IOP","17","0","1");
INSERT INTO tbl_casesheet_option VALUES("19","Fundus Examination","17","0","1");
INSERT INTO tbl_casesheet_option VALUES("20","LMP-EDD","8","0","1");
INSERT INTO tbl_casesheet_option VALUES("21","Refraction","17","0","1");
INSERT INTO tbl_casesheet_option VALUES("22","Slit Lamp Examination","17","0","1");



DROP TABLE tbl_certificate_document;

CREATE TABLE `tbl_certificate_document` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(500) DEFAULT NULL,
  `content` longblob,
  `del` int(11) NOT NULL DEFAULT '0',
  `current_datetime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_datetime` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_cm_lab_parameter;

CREATE TABLE `tbl_cm_lab_parameter` (
  `tclp_id` int(11) NOT NULL AUTO_INCREMENT,
  `tclt_id` int(11) NOT NULL,
  `tclp_name` varchar(150) NOT NULL,
  `tclp_del` int(11) NOT NULL DEFAULT '0',
  `tclp_created_by` int(11) NOT NULL DEFAULT '0',
  `tclp_modify_by` int(11) DEFAULT '0',
  `tclp_delete_by` int(11) DEFAULT '0',
  `tclp_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tclp_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tclp_id`)
) ENGINE=InnoDB AUTO_INCREMENT=214 DEFAULT CHARSET=latin1;

INSERT INTO tbl_cm_lab_parameter VALUES("1","1","Complete Hemogram","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("2","1","CRP","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("3","1","ESR","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("4","1","PS-MP","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("5","1","CBC","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("6","1","HEMOGLOBIN","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("7","1","TOTAL RBC","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("8","1","PLATELET COUNT","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("9","1","TOTAL LEUCOCYTES COUNT","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("10","1","BASOPHILS - ABSOLUTE COUNT","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("11","1","EOSINOPHILS - ABSOLUTE COUNT","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("12","1","LYMPHOCYTES - ABSOLUTE COUNT","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("13","1","MONOCYTES - ABSOLUTE COUNT","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("14","1","NEUTROPHILS - ABSOLUTE COUNT","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("15","1","LYMPHOCYTE PERCENTAGE","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("16","1","BASOPHILS","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("17","1","EOSINOPHILS","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("18","1","MONOCYTES","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("19","1","NEUTROPHILS","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("20","1","IMMATURE GRANULOCYTES(IG)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("21","1","IMMATURE GRANULOCYTE PERCENTAGE(IG%)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("22","1","MEAN CORPUSCULAR HEMOGLOBIN(MCH)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("23","1","MEAN CORP.HEMO.CONC(MCHC)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("24","1","MEAN CORPUSCULAR VOLUME(MCV)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("25","1","MEAN PLATELET VOLUME(MPV)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("26","1","NUCLEATED RED BLOOD CELLS","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("27","1","NUCLEATED RED BLOOD CELLS %","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("28","1","PLATELETCRIT(PCT)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("29","1","HEMATOCRIT(PCV)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("30","1","PLATELET DISTRIBUTION WIDTH(PDW)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("31","1","PLATELET TO LARGE CELL RATIO(PLCR)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("32","1","RED CELL DISTRIBUTION WIDTH (RDW-CV)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("33","1","RED CELL DISTRIBUTION WIDTH - SD(RDW-SD)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("34","2","Fasting Blood Sugar","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("35","2","Random Blood Sugar","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("36","2","Average Blood Glucose","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("37","2","Blood Ketone (D3HB)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("38","2","C-Peptide","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("39","2","Fructosamine","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("40","2","HbA1C ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("41","2","Insulin ? Fasting","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("42","3","Liver Function Tests","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("43","3","SGPT","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("44","3","SGOT","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("45","3","Alkaline Phosphatase ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("46","3","Bilirubin ? Direct","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("47","3","Bilirubin ? Indirect ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("48","3","Bilirubin ? Total ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("49","3","GGT","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("50","3","Protein ? Total ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("51","3","Albumin ? Serum ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("52","3","Serum Globulin","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("53","3","Serum Alb/Globulin Ration ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("54","4","Anaemia Profile","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("55","4","% Transferrin Saturation","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("56","4","Ferritin","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("57","4","Iron ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("58","4","Total Iron Binding Capacity","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("59","5","Renal Function Test","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("60","5","S. Creatinine","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("61","5","Urine Creatinine","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("62","5","Blood Urea Nitrogen (BUN) ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("63","5","BUN/Sr. Creat Ratio ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("64","5","Calcium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("65","5","Chloride","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("66","5","Phosphorous","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("67","5","Potassium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("68","5","Sodium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("69","5","Uric Acid ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("70","5","Urinary Microalbumin ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("71","5","Uri Albumin/Creatinine Ratio","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("72","6","Lipid Profile ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("73","6","Total Cholesterol","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("74","6","HDL Cholesterol ? Direct ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("75","6","LDL Cholesterol ? Direct ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("76","6","LDL/HDL Ratio","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("77","6","Non ? HDL Cholesterol ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("78","6","TC/HDL Ratio","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("79","6","Triglycerides ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("80","6","VLDL Cholesterol ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("81","7","Urine R/M ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("82","7","Urine Routine ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("83","7","Urine Micro ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("84","7","Urine Culture and Sensitivity ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("85","7","Specific Gravity","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("86","7","Urinary Bilirubin","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("87","7","Urine Blood","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("88","7","Urobilinogen ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("89","7","Urinary Glucose ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("90","7","Urine Ketone","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("91","7","Urinary Leucocytes ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("92","7","Nitrite","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("93","7","PH","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("94","7","Urinary Protein","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("95","8","Vitamin D Total ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("96","8","Vitamin D2","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("97","8","Vitamin D3","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("98","8","Vitamin A ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("99","8","Vitamin B-12 ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("100","8","Vitamin B1/Thiamine ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("101","8","Vitamin B2/Riboflavin ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("102","8","Vitamin B3/Nicotinic Acid","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("103","8","Vitamin B5/Pantothenic Acid ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("104","8","Vitamin B6/Pyridoxal ? 5 ? Phosphate","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("105","8","Vitamin B7/Biotin ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("106","8","Vitamin B9/Folic Acid ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("107","8","Vitamin E","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("108","8","Vitamin K ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("109","9","Serum Electrolytes ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("110","9","S. Chloride ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("111","9","S. Potassium ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("112","9","S. Sodium ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("113","9","S. Calcium ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("114","9","Ionized Calcium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("115","9","S. Phosphorous ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("116","9","S. Magnesium ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("117","10","TSH ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("118","10","Free T3","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("119","10","Free T4","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("120","10","Total T3","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("121","10","Total T4","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("122","11","Anti CCP","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("123","11","Anti Nuclear Antibodies","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("124","11","Rheumatoid Factor","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("125","11","Phosphorous","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("126","12","Troponin","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("127","12","CK-MB","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("128","12","LDH","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("129","12","AST","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("130","12","Myoglobin","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("131","12","Ischemia Modified Albumin (IMA)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("132","12","Pro-Brain natriuretic Peptide","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("133","12","Brain natriuretic peptide","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("134","12","Glucogen phosphorylase isoenzyme BB","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("135","12","suPAR","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("136","12","APO B / APO A1 Ratio (APO B/A1)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("137","12","Apolipoprotein ? A1 (APO ? A1)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("138","12","Apolipoprotein ? B (APO ? B)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("139","12","Homocysteine","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("140","12","High Sensitivity C- Reactive Protein (HS-CRP)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("141","12","Lipoprotein (A) [LP(A)]","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("142","12","LP ? PLA2","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("143","13","Amylase","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("144","13","Lipase","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("145","14","Toxic Elements Panel","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("146","14","Silver","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("147","14","Aluminium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("148","14","Arsenic","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("149","14","Barium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("150","14","Beryllium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("151","14","Bismuth","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("152","14","Cadmium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("153","14","Cobalt","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("154","14","Chromium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("155","14","Caesium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("156","14","Mercury","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("157","14","Mangenese","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("158","14","Molybdenum","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("159","14","Nickel","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("160","14","Lead","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("161","14","Antimony","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("162","14","Selenium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("163","14","Tin","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("164","14","Strontium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("165","14","Thallium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("166","14","Uranium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("167","14","Vanadium","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("168","15","All TORCH","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("169","15","Cytomegalo Virus (CMV) ? IgG","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("170","15","Cytomegalo Virus (CMV) ? IgM","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("171","15","Herpes Simplex Virus 1 (HSV) ? IgG","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("172","15","Herpes Simplex Virus  1 (HSV) ? IgM","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("173","15","Herpes Simplex Virus 2 (HSV) ? IgG","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("174","15","Herpes Simplex Virus  2 (HSV) ? IgM","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("175","15","Rubella ? IgG","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("176","15","Rubella ? IgM","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("177","15","Toxo Gondii ? IgG","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("178","15","Toxo Gondii ? IgM","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("179","16","Testosterone","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("180","16","Estrogen","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("181","16","FSH","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("182","16","LH","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("183","16","Prolactin","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("184","16","Anti Mullerian Hormone","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("185","17","Hepatitis Panel","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("186","17","Hepatitis B Surface Antigen (HBsAg)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("187","17","Anti ? Hep B Envelope Antigen ? Total","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("188","17","Hep B Envelope Antigen (HBeAg)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("189","17","Anti Hep B Core Antigen ? IgM","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("190","17","Anti Hep B Core Antigen ? Total","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("191","17","Anti Hep B Surface Antigen ? Total","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("192","17","Tyhpoid ? IgG","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("193","17","Tyhoid ? IgM","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("194","17","Pl. Falciparum","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("195","17","Pl. Vivax","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("196","18","Hemoglobin A2","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("197","18","Hemoglobin C","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("198","18","Hemoglobin D","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("199","18","Hemoglobin F","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("200","18","Hemoglobin S","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("201","19","Percent Free PSA","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("202","19","Alpha Feto Protein","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("203","19","Beta HCG","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("204","19","CA 19.9","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("205","19","Carcino Embryonic Antigen)CEA)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("206","19","Free PSA","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("207","19","PSA","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("208","20","Alpha Feto Protein","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("209","20","Beta HCG","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("210","20","CA-125","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("211","20","CA 15.3","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("212","20","CA 19.9","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_parameter VALUES("213","20","Carcino Embryonic Antigen (CEA)","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");



DROP TABLE tbl_cm_lab_title;

CREATE TABLE `tbl_cm_lab_title` (
  `tclt_id` int(11) NOT NULL AUTO_INCREMENT,
  `tclt_name` varchar(150) NOT NULL,
  `tclt_del` int(11) NOT NULL DEFAULT '0',
  `tclt_created_by` int(11) NOT NULL DEFAULT '0',
  `tclt_modify_by` int(11) DEFAULT '0',
  `tclt_delete_by` int(11) DEFAULT '0',
  `tclt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tclt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tclt_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

INSERT INTO tbl_cm_lab_title VALUES("1","Complete Hemogram","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("2","Diabetes","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("3","Liver","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("4","Iron Deficiency","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("5","Renal","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("6","Lipid","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("7","Urine ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("8","Vitamins","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("9","Electrolytes","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("10","Thyroid","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("11","Arthritis ","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("12","Cardiac Risk Markers","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("13","Pancreas","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("14","Toxic Elements","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("15","TORCH","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("16","Hormone","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("17","Infectious Diseases","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("18","Thalassemia","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("19","Male Tumor Panel","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO tbl_cm_lab_title VALUES("20","Female Tumor Panel","0","1","0","0","0000-00-00 00:00:00","0000-00-00 00:00:00");



DROP TABLE tbl_cm_tag_first;

CREATE TABLE `tbl_cm_tag_first` (
  `tctf_id` int(11) NOT NULL AUTO_INCREMENT,
  `recordListingID` int(11) NOT NULL DEFAULT '0',
  `dp_id` int(11) NOT NULL,
  `tctf_name` text NOT NULL,
  `tctf_del` int(11) NOT NULL DEFAULT '0',
  `tctf_created_by` int(11) NOT NULL DEFAULT '0',
  `tctf_modify_by` int(11) DEFAULT '0',
  `tctf_delete_by` int(11) DEFAULT '0',
  `tctf_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tctf_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tctf_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO tbl_cm_tag_first VALUES("1","0","9","uri","0","1","0","0","2019-01-03 13:30:09","");
INSERT INTO tbl_cm_tag_first VALUES("2","0","9","fever","0","1","0","0","2019-01-03 13:30:50","");
INSERT INTO tbl_cm_tag_first VALUES("3","0","9","cvs","0","1","0","0","2019-01-03 13:33:16","");
INSERT INTO tbl_cm_tag_first VALUES("4","0","9","RS","0","1","0","0","2019-01-22 12:29:41","");



DROP TABLE tbl_cm_tag_second;

CREATE TABLE `tbl_cm_tag_second` (
  `tcts_id` int(11) NOT NULL AUTO_INCREMENT,
  `recordListingID` int(11) NOT NULL DEFAULT '0',
  `tctf_id` int(11) NOT NULL,
  `dp_id` int(11) NOT NULL,
  `tcts_name` text NOT NULL,
  `tcts_del` int(11) NOT NULL DEFAULT '0',
  `tcts_created_by` int(11) NOT NULL DEFAULT '0',
  `tcts_modify_by` int(11) NOT NULL DEFAULT '0',
  `tcts_delete_by` int(11) NOT NULL DEFAULT '0',
  `tcts_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tcts_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tcts_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tbl_cm_tag_second VALUES("1","0","3","9","s1s2-nomal","0","1","0","0","2019-01-03 13:33:39","");
INSERT INTO tbl_cm_tag_second VALUES("2","0","4","9","B/L AEBE","0","1","0","0","2019-01-22 12:30:06","");



DROP TABLE tbl_cm_tag_third;

CREATE TABLE `tbl_cm_tag_third` (
  `tctt_id` int(11) NOT NULL AUTO_INCREMENT,
  `recordListingID` int(11) NOT NULL DEFAULT '0',
  `tctf_id` int(11) NOT NULL,
  `tcts_id` int(11) NOT NULL,
  `dp_id` int(11) NOT NULL,
  `tctt_name` text NOT NULL,
  `tctt_del` int(11) NOT NULL DEFAULT '0',
  `tctt_created_by` int(11) NOT NULL DEFAULT '0',
  `tctt_modify_by` int(11) NOT NULL DEFAULT '0',
  `tctt_delete_by` int(11) NOT NULL DEFAULT '0',
  `tctt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tctt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tctt_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tbl_cm_tag_third VALUES("1","0","3","1","9","nad","0","1","0","0","2019-01-03 13:33:48","");
INSERT INTO tbl_cm_tag_third VALUES("2","0","4","2","9","B/LN WHEEZING","0","1","0","0","2019-01-22 12:30:23","");



DROP TABLE tbl_consultation_type;

CREATE TABLE `tbl_consultation_type` (
  `tct_id` int(11) NOT NULL AUTO_INCREMENT,
  `tct_name` varchar(150) NOT NULL,
  `tct_default` int(11) NOT NULL DEFAULT '0',
  `tct_del` int(11) NOT NULL DEFAULT '0',
  `tct_created_by` int(11) NOT NULL DEFAULT '0',
  `tct_modify_by` int(11) DEFAULT '0',
  `tct_delete_by` int(11) DEFAULT '0',
  `tct_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tct_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tct_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tbl_consultation_type VALUES("1","First Consultation","1","0","0","0","0","2018-12-19 12:29:36","2018-12-24 15:45:58");
INSERT INTO tbl_consultation_type VALUES("2","Follow-up Consultation","0","0","0","0","0","2018-12-19 12:30:47","2018-12-24 15:46:20");



DROP TABLE tbl_day_instruction;

CREATE TABLE `tbl_day_instruction` (
  `tdi_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tdi_title` varchar(150) CHARACTER SET utf8 DEFAULT NULL,
  `tdi_english` varchar(450) CHARACTER SET utf8 DEFAULT NULL,
  `tdi_hindi` varchar(450) CHARACTER SET utf8 DEFAULT NULL,
  `tdi_gujarati` varchar(450) CHARACTER SET utf8 DEFAULT NULL,
  `tdi_del` int(11) NOT NULL DEFAULT '0',
  `tdi_created_by` int(11) NOT NULL DEFAULT '0',
  `tdi_modify_by` int(11) DEFAULT NULL,
  `tdi_delete_by` int(11) NOT NULL DEFAULT '0',
  `tdi_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdi_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdi_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tbl_day_instruction VALUES("1","1","5","After Food","After Food","???? ?? ???","????? ???","0","5","","0","2018-07-31 11:58:40","2018-11-21 13:35:31");
INSERT INTO tbl_day_instruction VALUES("2","1","5","Before Food","Before Food","???? ?? ????","????? ??????","0","5","","0","2018-07-31 12:20:31","2018-11-21 13:35:40");



DROP TABLE tbl_days;

CREATE TABLE `tbl_days` (
  `td_id` int(11) NOT NULL AUTO_INCREMENT,
  `td_day_name` text NOT NULL,
  PRIMARY KEY (`td_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO tbl_days VALUES("1","Monday");
INSERT INTO tbl_days VALUES("2","Tuesday");
INSERT INTO tbl_days VALUES("3","Wednesday");
INSERT INTO tbl_days VALUES("4","Thursday");
INSERT INTO tbl_days VALUES("5","Friday");
INSERT INTO tbl_days VALUES("6","Saturday");
INSERT INTO tbl_days VALUES("7","Sunday");



DROP TABLE tbl_default_value;

CREATE TABLE `tbl_default_value` (
  `tdv_id` int(11) NOT NULL AUTO_INCREMENT,
  `salutation` varchar(70) NOT NULL,
  `gender` varchar(70) DEFAULT NULL,
  `dp_created_by` int(11) DEFAULT '0',
  `tdv_modify_by` int(11) DEFAULT '0',
  `tdv_delete_by` int(11) DEFAULT '0',
  `tdv_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdv_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdv_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_default_value VALUES("1","None","None","1","1","0","2018-12-11 09:24:00","2018-12-11 10:40:45");



DROP TABLE tbl_department;

CREATE TABLE `tbl_department` (
  `dp_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` varchar(250) NOT NULL,
  `dp_name` varchar(70) DEFAULT NULL,
  `dp_status` int(11) DEFAULT '0',
  `dp_del` int(11) DEFAULT '0',
  `dp_created_by` int(11) DEFAULT '0',
  `dp_modify_by` int(11) DEFAULT '0',
  `dp_delete_by` int(11) DEFAULT '0',
  `dp_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `dp_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`dp_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO tbl_department VALUES("9","1","Paediatrics","0","0","1","1","0","2018-08-24 15:15:51","2018-12-29 09:57:23");



DROP TABLE tbl_diagnosis_setting;

CREATE TABLE `tbl_diagnosis_setting` (
  `tds_id` int(11) NOT NULL AUTO_INCREMENT,
  `dp_id` int(11) NOT NULL,
  `tds_name` longtext NOT NULL,
  `tds_del` int(11) NOT NULL DEFAULT '0',
  `tds_created_by` int(11) NOT NULL DEFAULT '0',
  `tds_modify_by` int(11) DEFAULT '0',
  `tds_delete_by` int(11) DEFAULT '0',
  `tds_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tds_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tds_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20575 DEFAULT CHARSET=latin1;

INSERT INTO tbl_diagnosis_setting VALUES("17148","9","Abnormal findings on cytological and histological examination of urine","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17149","9","Abnormal findings on microbiological examination of urine","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17150","9","Abnormal urine levels of substances chiefly nonmedicinal as to source","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17151","9","Abscess of external ear- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17152","9","Abscess of external ear- unspecified ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17153","9","Abscess of left external ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17154","9","Abscess of right external ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17155","9","Abscess- furuncle and carbuncle of nose","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17156","9","Absence epileptic syndrome- intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17157","9","Absence epileptic syndrome- intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17158","9","Absence epileptic syndrome- intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17159","9","Absence epileptic syndrome- intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17160","9","Absence epileptic syndrome- not intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17161","9","Absence epileptic syndrome- not intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17162","9","Absence epileptic syndrome- not intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17163","9","Absence epileptic syndrome- not intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17164","9","Acanthamebiasis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17165","9","Accidental puncture or laceration of dura during a procedure","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17166","9","Acne conglobata","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17167","9","Acne excorie des jeunes filles","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17168","9","Acne keloid","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17169","9","Acne tropica","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17170","9","Acne vulgaris","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17171","9","Acne- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17172","9","Acquired absence of both cervix and uterus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17173","9","Acquired absence of cervix with remaining uterus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17174","9","Acquired absence of uterus with remaining cervical stump","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17175","9","Acquired epidermolysis bullosa- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17176","9","Acute abdomen","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17177","9","Acute anal fissure","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17178","9","Acute bronchiolitis due to human metapneumovirus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17179","9","Acute bronchiolitis due to other specified organisms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17180","9","Acute bronchiolitis due to respiratory syncytial virus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17181","9","Acute bronchiolitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17182","9","Acute bronchitis due to coxsackievirus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17183","9","Acute bronchitis due to coxsackievirus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17184","9","Acute bronchitis due to echovirus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17185","9","Acute bronchitis due to Hemophilus influenzae","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17186","9","Acute bronchitis due to Mycoplasma pneumoniae","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17187","9","Acute bronchitis due to other specified organisms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17188","9","Acute bronchitis due to parainfluenza virus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17189","9","Acute bronchitis due to respiratory syncytial virus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17190","9","Acute bronchitis due to rhinovirus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17191","9","Acute bronchitis due to streptococcus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17192","9","Acute bronchitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17193","9","Acute bronchospasm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17194","9","Acute disseminated encephalitis and encephalomyelitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17195","9","Acute gastritis without bleeding","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17196","9","Acute gingivitis- non-plaque induced","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17197","9","Acute gingivitis- plaque induced","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17198","9","Acute graft-versus-host disease","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17199","9","Acute lymphadenitis of face- head and neck","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17200","9","Acute lymphadenitis of lower limb","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17201","9","Acute lymphadenitis of other sites","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17202","9","Acute lymphadenitis of trunk","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17203","9","Acute lymphadenitis of upper limb","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17204","9","Acute lymphadenitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17205","9","Acute nasopharyngitis [common cold]","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17206","9","Acute necrotizing hemorrhagic encephalopathy- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17207","9","Acute obstructive laryngitis [croup]","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17208","9","Acute on chronic graft-versus-host disease","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17209","9","Acute pain due to trauma","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17210","9","Acute parametritis and pelvic cellulitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17211","9","Acute pharyngitis due to other specified organisms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17212","9","Acute pharyngitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17213","9","Acute post-thoracotomy pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17214","9","Acute post-traumatic headache- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17215","9","Acute post-traumatic headache- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17216","9","Acute recurrent sinusitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17217","9","Acute recurrent tonsillitis due to other specified organisms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17218","9","Acute recurrent tonsillitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17219","9","Acute sinusitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17220","9","Acute tonsillitis due to other specified organisms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17221","9","Acute tonsillitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17222","9","Acute tubulo-interstitial nephritis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17223","9","Acute upper respiratory infection- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17224","9","Acute vaginitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17225","9","Acute vulvitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17226","9","Adjustment disorder with anxiety","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17227","9","Adjustment disorder with depressed mood","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17228","9","Adjustment insomnia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17229","9","Agenesis and aplasia of cervix","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17230","9","Agenesis and aplasia of uterus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17231","9","Agranulocytosis secondary to cancer chemotherapy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17232","9","Allergic and dietetic gastroenteritis and colitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17233","9","Allergic contact dermatitis due to plants- except food","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17234","9","Allergic contact dermatitis- unspecified cause","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17235","9","Allergic rhinitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17236","9","Altered mental status- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17237","9","Anal fissure- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17238","9","Anal high risk human papillomavirus (HPV) DNA test positive","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17239","9","Anal low risk human papillomavirus (HPV) DNA test positive","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17240","9","Androgen insensitivity syndrome- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17241","9","Anemia- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17242","9","Antineoplastic chemotherapy induced pancytopenia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17243","9","Aphagia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17244","9","Atopic dermatitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17245","9","Atopic neurodermatitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17246","9","Attention-deficit hyperactivity disorder- combined type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17247","9","Attention-deficit hyperactivity disorder- other type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17248","9","Attention-deficit hyperactivity disorder- predominantly hyperactive type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17249","9","Attention-deficit hyperactivity disorder- predominantly inattentive type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17250","9","Attention-deficit hyperactivity disorder- unspecified type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17251","9","Attention-deficit hyperactivity disorder- unspecified type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17252","9","Autoimmune hepatitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17253","9","Bence Jones proteinuria","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17254","9","Benign and innocent cardiac murmurs","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17255","9","Benign carcinoid tumor of the small intestine- unspecified portion","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17256","9","Benign carcinoid tumors of other sites","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17257","9","Benign essential microscopic hematuria","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17258","9","Besnier\'s prurigo","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17259","9","Bilious vomiting of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17260","9","Bockhart\'s impetigo","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17261","9","Body mass index (BMI) pediatric- 5th percentile to less than 85th percentile for age","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17262","9","Body mass index (BMI) pediatric- 85th percentile to less than 95th percentile for age","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17263","9","Body mass index (BMI) pediatric- greater than or equal to 95th percentile for age","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17264","9","Body mass index (BMI) pediatric- less than 5th percentile for age","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17265","9","Bronchopulmonary dysplasia originating in the perinatal period","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17266","9","Bullous impetigo","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17267","9","Candidal cheilitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17268","9","Candidal stomatitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17269","9","Cardiac arrest of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17270","9","Cardiac murmur- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17271","9","Cardiogenic shock","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17272","9","Carotid sinus syncope","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17273","9","Carrier or suspected carrier of Methicillin resistant Staphylococcus aureus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17274","9","Carrier or suspected carrier of Methicillin susceptible Staphylococcus aureus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17275","9","Cellulitis and abscess of mouth","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17276","9","Cellulitis of external ear- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17277","9","Cellulitis of external ear- unspecified ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17278","9","Cellulitis of left external ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17279","9","Cellulitis of right external ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17280","9","Central pain syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17281","9","Central sleep apnea in conditions classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17282","9","Cerebral palsy- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17283","9","Change of job","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17284","9","Chest pain- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17285","9","Chills (without fever)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17286","9","Choleperitonitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17287","9","Chronic anal fissure","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17288","9","Chronic cluster headache- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17289","9","Chronic cluster headache- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17290","9","Chronic graft-versus-host disease","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17291","9","Chronic kidney disease- stage 1","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17292","9","Chronic kidney disease- stage 2 (mild)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17293","9","Chronic kidney disease- stage 3 (moderate)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17294","9","Chronic kidney disease- stage 4 (severe)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17295","9","Chronic kidney disease- stage 5","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17296","9","Chronic kidney disease- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17297","9","Chronic migraine without aura- intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17298","9","Chronic migraine without aura- intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17299","9","Chronic migraine without aura- not intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17300","9","Chronic migraine without aura- not intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17301","9","Chronic obstructive pulmonary disease with (acute) exacerbation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17302","9","Chronic obstructive pulmonary disease with acute lower respiratory infection","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17303","9","Chronic obstructive pulmonary disease- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17304","9","Chronic pain due to trauma","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17305","9","Chronic pain syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17306","9","Chronic paroxysmal hemicrania- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17307","9","Chronic paroxysmal hemicrania- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17308","9","Chronic post-thoracotomy pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17309","9","Chronic post-traumatic headache- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17310","9","Chronic post-traumatic headache- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17311","9","Chronic rhinitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17312","9","Chronic serous otitis media- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17313","9","Chronic serous otitis media- left ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17314","9","Chronic serous otitis media- right ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17315","9","Chronic serous otitis media- unspecified ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17316","9","Chronic tension-type headache- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17317","9","Chronic tension-type headache- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17318","9","Chylous effusion","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17319","9","Circadian rhythm sleep disorder in conditions classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17320","9","Circadian rhythm sleep disorder- advanced sleep phase type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17321","9","Circadian rhythm sleep disorder- delayed sleep phase type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17322","9","Circadian rhythm sleep disorder- free running type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17323","9","Circadian rhythm sleep disorder- irregular sleep wake type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17324","9","Circadian rhythm sleep disorder- jet lag type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17325","9","Circadian rhythm sleep disorder- shift work type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17326","9","Circadian rhythm sleep disorder- unspecified type","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17327","9","Cluster headache syndrome- unspecified- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17328","9","Cluster headache syndrome- unspecified- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17329","9","Complete androgen insensitivity syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17330","9","Complete loss of teeth due to trauma- class I","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17331","9","Complete loss of teeth due to trauma- class II","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17332","9","Complete loss of teeth due to trauma- class III","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17333","9","Complete loss of teeth due to trauma- class IV","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17334","9","Complete loss of teeth due to trauma- unspecified class","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17335","9","Complex febrile convulsions","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17336","9","Conduct disorder- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17337","9","Conductive hearing loss- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17338","9","Conductive hearing loss- unilateral- left ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17339","9","Conductive hearing loss- unilateral- right ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17340","9","Confusional arousals","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17341","9","Congenital absence of vulva","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17342","9","Congenital agranulocytosis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17343","9","Congenital central alveolar hypoventilation syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17344","9","Congenital cytomegalovirus infection","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17345","9","Congenital fistulae between uterus and digestive and urinary tracts","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17346","9","Congenital lactase deficiency","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17347","9","Congenital malformation of cardiac chambers and connections- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17348","9","Congenital malformation of clitoris","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17349","9","Congenital malformation of heart- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17350","9","Congenital malformation of uterus and cervix- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17351","9","Congenital rectovaginal fistula","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17352","9","Constipation- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17353","9","Contact with and (suspected ) exposure to other hazardous substances","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17354","9","Contact with and (suspected) exposure to aromatic amines","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17355","9","Contact with and (suspected) exposure to arsenic","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17356","9","Contact with and (suspected) exposure to benzene","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17357","9","Contact with and (suspected) exposure to mold (toxic)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17358","9","Contact with and (suspected) exposure to other bacterial communicable diseases","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17359","9","Contact with and (suspected) exposure to other communicable diseases","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17360","9","Contact with and (suspected) exposure to other hazardous aromatic compounds","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17361","9","Contact with and (suspected) exposure to other hazardous metals","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17362","9","Contact with and (suspected) exposure to other hazardous- chiefly nonmedicinal- chemicals","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17363","9","Contact with and (suspected) exposure to other intestinal infectious diseases","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17364","9","Contact with and (suspected) exposure to pediculosis- acariasis and other infestations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17365","9","Cough","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17366","9","Cough variant asthma","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17367","9","Coxsackievirus as the cause of diseases classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17368","9","Cracked tooth","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17369","9","Cutaneous autosensitization","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17370","9","Cyclic neutropenia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17371","9","Cyst and mucocele of nose and nasal sinus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17372","9","Cytologic evidence of malignancy on smear of anus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17373","9","Cytologic evidence of malignancy on smear of cervix","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17374","9","Cytologic evidence of malignancy on smear of vagina","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17375","9","Cytomegaloviral mononucleosis with meningitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17376","9","Cytomegaloviral mononucleosis with other complication","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17377","9","Cytomegaloviral mononucleosis with polyneuropathy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17378","9","Cytomegaloviral mononucleosis without complications","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17379","9","Deaf nonspeaking- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17380","9","Deformity of reconstructed breast","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17381","9","Dehydration","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17382","9","Dental caries- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17383","9","Dependence on renal dialysis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17384","9","Dependence on wheelchair","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17385","9","Dermatitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17386","9","Dermatophytosis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17387","9","Developmental disorder of scholastic skills- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17388","9","Diabetes mellitus due to underlying condition with diabetic peripheral angiopathy with gangrene","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17389","9","Diabetes mellitus due to underlying condition without complications","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17390","9","Diaper dermatitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17391","9","Diarrhea- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17392","9","Diffuse otitis externa- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17393","9","Diffuse otitis externa- left ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17394","9","Diffuse otitis externa- right ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17395","9","Diffuse otitis externa- unspecified ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17396","9","Disorientation- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17397","9","Disproportion of reconstructed breast","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17398","9","Disruption of family by separation and divorce","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17399","9","Dizziness and giddiness","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17400","9","Dorsalgia- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17401","9","Doubling of vagina- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17402","9","Down syndrome- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17403","9","Drug induced fever","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17404","9","Drug or chemical induced diabetes mellitus with diabetic peripheral angiopathy with gangrene","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17405","9","Drug or chemical induced diabetes mellitus without complications","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17406","9","Drug-induced headache- not elsewhere classified- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17407","9","Drug-induced headache- not elsewhere classified- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17408","9","Drug-induced obesity","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17409","9","Dural tear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17410","9","Dysmenorrhea- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17411","9","Dysphagia- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17412","9","Dysplasia of anus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17413","9","Dysuria","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17414","9","Elevated blood-pressure reading- without diagnosis of hypertension","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17415","9","Elevated urine levels of drugs- medicaments and biological substances","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17416","9","Encephalitis and encephalomyelitis in diseases classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17417","9","Encephalitis and encephalomyelitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17418","9","Encopresis not due to a substance or known physiological condition","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17419","9","Encounter for adoption services","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17420","9","Encounter for cervical smear to confirm findings of recent normal smear following initial abnormal smear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17421","9","Encounter for change or removal of nonsurgical wound dressing","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17422","9","Encounter for change or removal of surgical wound dressing","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17423","9","Encounter for examination for admission to educational institution","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17424","9","Encounter for examination for admission to residential institution","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17425","9","Encounter for examination for driving license","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17426","9","Encounter for examination for insurance purposes","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17427","9","Encounter for examination for participation in sport","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17428","9","Encounter for examination for recruitment to armed forces","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17429","9","Encounter for examination of ears and hearing with other abnormal findings","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17430","9","Encounter for examination of ears and hearing without abnormal findings","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17431","9","Encounter for follow-up examination after completed treatment for conditions other than malignant neoplasm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17432","9","Encounter for follow-up examination after completed treatment for malignant neoplasm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17433","9","Encounter for general adult medical examination with abnormal findings","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17434","9","Encounter for general adult medical examination without abnormal findings","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17435","9","Encounter for gynecological examination (general) (routine) with abnormal findings","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17436","9","Encounter for gynecological examination (general) (routine) without abnormal findings","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17437","9","Encounter for hearing examination following failed hearing screening","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17438","9","Encounter for initial prescription of contraceptive pills","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17439","9","Encounter for issue of other medical certificate","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17440","9","Encounter for nonprocreative screening for genetic disease carrier status","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17441","9","Encounter for other administrative examinations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17442","9","Encounter for other administrative examinations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17443","9","Encounter for other general counseling and advice on contraception","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17444","9","Encounter for other plastic and reconstructive surgery following medical procedure or healed injury","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17445","9","Encounter for other preprocedural examination","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17446","9","Encounter for other screening for genetic and chromosomal anomalies","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17447","9","Encounter for pre-employment examination","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17448","9","Encounter for removal of sutures","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17449","9","Encounter for routine and ritual male circumcision","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17450","9","Encounter for routine child health examination with abnormal findings","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17451","9","Encounter for routine child health examination without abnormal findings","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17452","9","Encounter for screening for human papillomavirus (HPV)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17453","9","End stage renal disease","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17454","9","Enlarged lymph nodes- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17455","9","Enterobiasis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17456","9","Enteroviral vesicular stomatitis with exanthem","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17457","9","Eosinophilic colitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17458","9","Eosinophilic esophagitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17459","9","Eosinophilic gastritis or gastroenteritis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17460","9","Eosinophilic gastritis or gastroenteritis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17461","9","Eosinophilic gastritis or gastroenteritis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17462","9","Epidermolysis bullosa due to drug","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17463","9","Epigastric pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17464","9","Epilepsy- unspecified- intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17465","9","Epilepsy- unspecified- intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17466","9","Epilepsy- unspecified- not intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17467","9","Epilepsy- unspecified- not intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17468","9","Epileptic seizures related to external causes- not intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17469","9","Epileptic seizures related to external causes- not intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17470","9","Epileptic spasms- intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17471","9","Epileptic spasms- intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17472","9","Epileptic spasms- not intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17473","9","Epileptic spasms- not intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17474","9","Episodic cluster headache- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17475","9","Episodic cluster headache- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17476","9","Episodic paroxysmal hemicrania- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17477","9","Episodic paroxysmal hemicrania- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17478","9","Episodic tension-type headache- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17479","9","Episodic tension-type headache- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17480","9","Epistaxis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17481","9","Erythema infectiosum [fifth disease]","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17482","9","Erythema multiforme- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17483","9","Exanthema subitum [sixth disease] due to human herpesvirus 6","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17484","9","Exanthema subitum [sixth disease] due to human herpesvirus 7","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17485","9","Exanthema subitum [sixth disease]- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17486","9","Excessive crying of child- adolescent or adult","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17487","9","Exercise induced bronchospasm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17488","9","Exfoliation due to erythematous condition involving 10-19 percent of body surface","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17489","9","Exfoliation due to erythematous condition involving 20-29 percent of body surface","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17490","9","Exfoliation due to erythematous condition involving 30-39 percent of body surface","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17491","9","Exfoliation due to erythematous condition involving 40-49 percent of body surface","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17492","9","Exfoliation due to erythematous condition involving 50-59 percent of body surface","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17493","9","Exfoliation due to erythematous condition involving 60-69 percent of body surface","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17494","9","Exfoliation due to erythematous condition involving 70-79 percent of body surface","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17495","9","Exfoliation due to erythematous condition involving 80-89 percent of body surface","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17496","9","Exfoliation due to erythematous condition involving 90 or more percent of body surface","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17497","9","Exfoliation due to erythematous condition involving less than 10 percent of body surface","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17498","9","Expectant parent(s) prebirth pediatrician visit","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17499","9","Exposure to disaster- war and other hostilities","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17500","9","Expressive language disorder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17501","9","Extrarenal uremia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17502","9","Extremely low birth weight newborn- 500-749 grams","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17503","9","Extremely low birth weight newborn- 750-999 grams","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17504","9","Extremely low birth weight newborn- less than 500 grams","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17505","9","Extremely low birth weight newborn- unspecified weight","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17506","9","Failure to thrive (child)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17507","9","Failure to thrive in newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17508","9","Family history of other diseases of the digestive system","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17509","9","Fecal smearing","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17510","9","Fecal urgency","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17511","9","Feeding difficulties","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17512","9","Feeding problem of newborn- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17513","9","Fetal hydantoin syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17514","9","Fever presenting with conditions classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17515","9","Fever- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17516","9","Fibromyalgia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17517","9","Flexural eczema","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17518","9","Frequency of micturition","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17519","9","Full incontinence of feces","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17520","9","Functional quadriplegia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17521","9","Functional urinary incontinence","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17522","9","Fusion of labia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17523","9","Fussy infant (baby)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17524","9","Gammaherpesviral mononucleosis with meningitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17525","9","Gammaherpesviral mononucleosis with other complications","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17526","9","Gammaherpesviral mononucleosis with polyneuropathy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17527","9","Gammaherpesviral mononucleosis without complication","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17528","9","Gangrene- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17529","9","Gastro-esophageal reflux disease without esophagitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17530","9","Generalized (acute) peritonitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17531","9","Generalized (acute) peritonitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17532","9","Generalized abdominal pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17533","9","Generalized enlarged lymph nodes","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17534","9","Generalized idiopathic epilepsy and epileptic syndromes- intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17535","9","Generalized idiopathic epilepsy and epileptic syndromes- intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17536","9","Generalized idiopathic epilepsy and epileptic syndromes- intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17537","9","Generalized idiopathic epilepsy and epileptic syndromes- intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17538","9","Generalized idiopathic epilepsy and epileptic syndromes- not intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17539","9","Generalized idiopathic epilepsy and epileptic syndromes- not intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17540","9","Generalized skin eruption due to drugs and medicaments taken internally","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17541","9","Glare sensitivity","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17542","9","Graft-versus-host disease- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17543","9","Gross hematuria","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17544","9","Halitosis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17545","9","Headache","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17546","9","Headache associated with sexual activity","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17547","9","Hematuria- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17548","9","Hemicrania continua","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17549","9","Hemiplegic migraine- intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17550","9","Hemiplegic migraine- intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17551","9","Hemiplegic migraine- not intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17552","9","Hemiplegic migraine- not intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17553","9","Hemorrhagic otitis externa- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17554","9","Hemorrhagic otitis externa- left ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17555","9","Hemorrhagic otitis externa- right ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17556","9","Hemorrhagic otitis externa- unspecified ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17557","9","Hemothorax","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17558","9","Heparin induced thrombocytopenia (HIT)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17559","9","Hepatomegaly with splenomegaly- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17560","9","Hepatomegaly with splenomegaly- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17561","9","Hepatomegaly- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17562","9","Herpesviral gingivostomatitis and pharyngotonsillitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17563","9","Hesitancy of micturition","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17564","9","High altitude periodic breathing","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17565","9","Hordeolum externum left eye- unspecified eyelid","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17566","9","Hordeolum externum left lower eyelid","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17567","9","Hordeolum externum left upper eyelid","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17568","9","Hordeolum externum right eye- unspecified eyelid","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17569","9","Hordeolum externum right lower eyelid","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17570","9","Hordeolum externum right upper eyelid","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17571","9","Hordeolum externum unspecified eye- unspecified eyelid","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17572","9","Hungry bone syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17573","9","Hydrocele- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17574","9","Hypersomnia due to medical condition","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17575","9","Hypersomnia due to other mental disorder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17576","9","Hypersomnia- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17577","9","Hypnic headache","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17578","9","Hypoplasia of breast","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17579","9","Hypoplasia of cervix","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17580","9","Hypothermia- not associated with low environmental temperature","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17581","9","Hypovolemia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17582","9","Hypovolemic shock","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17583","9","Idiopathic hypersomnia with long sleep time","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17584","9","Idiopathic hypersomnia without long sleep time","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17585","9","Idiopathic sleep related nonobstructive alveolar hypoventilation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17586","9","Idiopathic urticaria","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17587","9","Impacted cerumen- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17588","9","Impacted cerumen- left ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17589","9","Impacted cerumen- right ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17590","9","Impacted cerumen- unspecified ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17591","9","Impaired contrast sensitivity","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17592","9","Impetiginization of other dermatoses","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17593","9","Impetigo- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17594","9","Incomplete defecation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17595","9","Infant botulism","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17596","9","Infantile acne","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17597","9","Infantile papular acrodermatitis [Gianotti-Crosti]","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17598","9","Infectious mononucleosis- unspecified with meningitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17599","9","Infectious mononucleosis- unspecified with other complication","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17600","9","Infectious mononucleosis- unspecified with polyneuropathy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17601","9","Infectious mononucleosis- unspecified without complication","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17602","9","Influenza due to identified novel influenza A virus with gastrointestinal manifestations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17603","9","Influenza due to identified novel influenza A virus with gastrointestinal manifestations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17604","9","Influenza due to identified novel influenza A virus with other manifestations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17605","9","Influenza due to identified novel influenza A virus with other manifestations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17606","9","Influenza due to identified novel influenza A virus with other manifestations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17607","9","Influenza due to identified novel influenza A virus with other respiratory manifestations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17608","9","Influenza due to identified novel influenza A virus with other respiratory manifestations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17609","9","Influenza due to identified novel influenza A virus with pneumonia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17610","9","Influenza due to identified novel influenza A virus with pneumonia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17611","9","Influenza due to other identified influenza virus with other respiratory manifestations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17612","9","Influenza due to other identified influenza virus with other respiratory manifestations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17613","9","Influenza due to other identified influenza virus with other specified pneumonia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17614","9","Influenza due to other identified influenza virus with the same other identified influenza virus pneumonia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17615","9","Influenza due to unidentified influenza virus with other respiratory manifestations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17616","9","Ingrowing nail","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17617","9","Insomnia due to medical condition","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17618","9","Insomnia due to medical condition","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17619","9","Insomnia due to other mental disorder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17620","9","Institutional upbringing","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17621","9","Intrinsic (allergic) eczema","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17622","9","Irritant contact dermatitis due to plants- except food","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17623","9","Irritant contact dermatitis- unspecified cause","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17624","9","Isolated proteinuria","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17625","9","Juvenile myoclonic epilepsy- intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17626","9","Juvenile myoclonic epilepsy- intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17627","9","Juvenile myoclonic epilepsy- not intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17628","9","Juvenile myoclonic epilepsy- not intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17629","9","Lactose intolerance- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17630","9","Left lower quadrant pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17631","9","Left upper quadrant pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17632","9","Lennox-Gastaut syndrome- intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17633","9","Lennox-Gastaut syndrome- intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17634","9","Lennox-Gastaut syndrome- not intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17635","9","Lennox-Gastaut syndrome- not intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17636","9","Leukemia- unspecified- in relapse","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17637","9","Localized skin eruption due to drugs and medicaments taken internally","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17638","9","Lower abdominal pain- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17639","9","Major depressive disorder- single episode- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17640","9","Malignant carcinoid tumor of the small intestine- unspecified portion","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17641","9","Malignant neoplasm associated with transplanted organ","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17642","9","Malignant pleural effusion","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17643","9","Malignant poorly differentiated neuroendocrine tumors","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17644","9","Meconium aspiration with respiratory symptoms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17645","9","Meconium aspiration without respiratory symptoms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17646","9","Meconium passage during delivery","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17647","9","Meconium staining","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17648","9","Menstrual migraine- intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17649","9","Menstrual migraine- intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17650","9","Menstrual migraine- not intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17651","9","Menstrual migraine- not intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17652","9","Methicillin resistant Staphylococcus aureus infection as the cause of diseases classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17653","9","Methicillin resistant Staphylococcus aureus infection- unspecified site","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17654","9","Migraine with aura- intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17655","9","Migraine with aura- not intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17656","9","Migraine without aura- intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17657","9","Migraine without aura- not intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17658","9","Migraine- unspecified- intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17659","9","Migraine- unspecified- intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17660","9","Migraine- unspecified- not intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17661","9","Migraine- unspecified- not intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17662","9","Mild cognitive impairment- so stated","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17663","9","Mild intermittent asthma with (acute) exacerbation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17664","9","Mild intermittent asthma with (acute) exacerbation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17665","9","Mild intermittent asthma with status asthmaticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17666","9","Mild intermittent asthma with status asthmaticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17667","9","Mild intermittent asthma- uncomplicated","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17668","9","Mild intermittent asthma- uncomplicated","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17669","9","Mild persistent asthma with (acute) exacerbation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17670","9","Mild persistent asthma with (acute) exacerbation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17671","9","Mild persistent asthma with status asthmaticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17672","9","Mild persistent asthma with status asthmaticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17673","9","Mild persistent asthma- uncomplicated","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17674","9","Mild persistent asthma- uncomplicated","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17675","9","Mixed conductive and sensorineural hearing loss- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17676","9","Mixed conductive and sensorineural hearing loss- unilateral- left ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17677","9","Mixed conductive and sensorineural hearing loss- unilateral- right ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17678","9","Mixed conductive and sensorineural hearing loss- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17679","9","Moderate persistent asthma with (acute) exacerbation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17680","9","Moderate persistent asthma with (acute) exacerbation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17681","9","Moderate persistent asthma with status asthmaticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17682","9","Moderate persistent asthma with status asthmaticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17683","9","Moderate persistent asthma- uncomplicated","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17684","9","Moderate persistent asthma- uncomplicated","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17685","9","Molluscum contagiosum","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17686","9","Morbid (severe) obesity due to excess calories","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17687","9","Mouth breathing","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17688","9","Multiple myeloma in relapse","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17689","9","Myalgia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17690","9","Myelitis in diseases classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17691","9","Myelitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17692","9","Myositis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17693","9","Myotonia congenita","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17694","9","Naegleriasis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17695","9","Nasal congestion","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17696","9","Nasal mucositis (ulcerative)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17697","9","Nausea with vomiting- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17698","9","Necrotizing enterocolitis in newborn- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17699","9","Neonatal aspiration of (clear) amniotic fluid and mucus with respiratory symptoms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17700","9","Neonatal aspiration of (clear) amniotic fluid and mucus without respiratory symptoms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17701","9","Neonatal aspiration of blood with respiratory symptoms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17702","9","Neonatal aspiration of blood without respiratory symptoms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17703","9","Neonatal aspiration of milk and regurgitated food without respiratory symptoms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17704","9","Neonatal aspiration- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17705","9","Neonatal difficulty in feeding at breast","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17706","9","Neonatal goiter- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17707","9","Neonatal jaundice- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17708","9","Neonatal obstruction of bilateral nasolacrimal duct","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17709","9","Neonatal obstruction of left nasolacrimal duct","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17710","9","Neonatal obstruction of right nasolacrimal duct","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17711","9","Neonatal obstruction of unspecified nasolacrimal duct","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17712","9","Neoplasm related pain (acute) (chronic)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17713","9","Neoplastic (malignant) related fatigue","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17714","9","Neutropenia due to infection","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17715","9","Neutropenia- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17716","9","New daily persistent headache (NDPH)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17717","9","Newborn (suspected to be) affected by other maternal medication","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17718","9","Newborn (suspected to be) affected by other medical procedures on mother- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17719","9","Newborn (suspected to be) affected by surgical procedure on mother","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17720","9","Nocturnal enuresis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17721","9","Non-bullous impetigo","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17722","9","Nonbullous erythema multiforme","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17723","9","Nontraumatic hematoma of soft tissue","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17724","9","Nummular dermatitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17725","9","Obesity- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17726","9","Obsessive-compulsive behavior","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17727","9","Obstructive and reflux uropathy- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17728","9","Obstructive and reflux uropathy- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17729","9","Obstructive sleep apnea (adult) (pediatric)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17730","9","Omphalitis with mild hemorrhage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17731","9","Omphalitis without hemorrhage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17732","9","Oral mucositis (ulcerative) due to antineoplastic therapy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17733","9","Oral mucositis (ulcerative) due to other drugs","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17734","9","Oral mucositis (ulcerative) due to radiation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17735","9","Oral mucositis (ulcerative)- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17736","9","Otalgia- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17737","9","Otalgia- left ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17738","9","Otalgia- right ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17739","9","Otalgia- unspecified ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17740","9","Other abnormal cytological findings on specimens from anus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17741","9","Other abnormal cytological findings on specimens from vagina","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17742","9","Other abnormal cytological findings on specimens from vagina","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17743","9","Other abnormal findings in urine","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17744","9","Other abnormalities of breathing","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17745","9","Other abnormalities of heart beat","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17746","9","Other acanthamebic disease","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17747","9","Other acne","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17748","9","Other acquired epidermolysis bullosa","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17749","9","Other acute necrotizing hemorrhagic encephalopathy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17750","9","Other acute postprocedural pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17751","9","Other asthma","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17752","9","Other atopic dermatitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17753","9","Other cardiac sounds","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17754","9","Other chromoabnormalities of urine","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17755","9","Other chronic pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17756","9","Other chronic postprocedural pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17757","9","Other chronic respiratory diseases originating in the perinatal period","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17758","9","Other circadian rhythm sleep disorder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17759","9","Other complicated headache syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17760","9","Other congenital malformations of cervix","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17761","9","Other congenital malformations of vagina","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17762","9","Other congenital malformations of vulva","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17763","9","Other diseases of bronchus- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17764","9","Other disorders of intestinal carbohydrate absorption","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17765","9","Other disorders of retroperitoneum","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17766","9","Other dorsalgia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17767","9","Other drug-induced agranulocytosis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17768","9","Other drug-induced pancytopenia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17769","9","Other encephalitis and encephalomyelitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17770","9","Other epilepsy- intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17771","9","Other epilepsy- intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17772","9","Other epilepsy- not intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17773","9","Other epilepsy- not intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17774","9","Other erythema multiforme","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17775","9","Other erythema multiforme","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17776","9","Other erythema multiforme","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17777","9","Other fatigue","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17778","9","Other feeding problems of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17779","9","Other forms of stomatitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17780","9","Other general symptoms and signs","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17781","9","Other generalized epilepsy and epileptic syndromes- intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17782","9","Other generalized epilepsy and epileptic syndromes- intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17783","9","Other generalized epilepsy and epileptic syndromes- not intractable- with status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17784","9","Other generalized epilepsy and epileptic syndromes- not intractable- without status epilepticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17785","9","Other headache syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17786","9","Other hypersomnia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17787","9","Other hypersomnia not due to a substance or known physiological condition","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17788","9","Other idiopathic peripheral autonomic neuropathy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17789","9","Other idiopathic peripheral autonomic neuropathy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17790","9","Other impetigo","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17791","9","Other infectious mononucleosis with meningitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17792","9","Other infectious mononucleosis with other complication","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17793","9","Other infectious mononucleosis with polyneuropathy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17794","9","Other infectious mononucleosis without complication","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17795","9","Other infective otitis externa- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17796","9","Other infective otitis externa- left ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17797","9","Other infective otitis externa- right ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17798","9","Other infective otitis externa- unspecified ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17799","9","Other insomnia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17800","9","Other insomnia not due to a substance or known physiological condition","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17801","9","Other iron deficiency anemias","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17802","9","Other lack of expected normal physiological development in childhood","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17803","9","Other lactose intolerance","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17804","9","Other low birth weight newborn- 1000-1249 grams","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17805","9","Other low birth weight newborn- 1250-1499 grams","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17806","9","Other low birth weight newborn- 1500-1749 grams","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17807","9","Other low birth weight newborn- 1750-1999 grams","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17808","9","Other low birth weight newborn- 2000-2499 grams","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17809","9","Other low birth weight newborn- unspecified weight","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17810","9","Other malaise","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17811","9","Other malignant neuroendocrine tumors","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17812","9","Other microscopic hematuria","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17813","9","Other migraine- intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17814","9","Other migraine- not intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17815","9","Other migraine- not intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17816","9","Other myelitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17817","9","Other myositis- left ankle and foot","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17818","9","Other myositis- left forearm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17819","9","Other myositis- left hand","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17820","9","Other myositis- left lower leg","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17821","9","Other myositis- left shoulder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17822","9","Other myositis- left thigh","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17823","9","Other myositis- left upper arm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17824","9","Other myositis- multiple sites","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17825","9","Other myositis- other site","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17826","9","Other myositis- right ankle and foot","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17827","9","Other myositis- right forearm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17828","9","Other myositis- right hand","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17829","9","Other myositis- right lower leg","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17830","9","Other myositis- right shoulder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17831","9","Other myositis- right thigh","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17832","9","Other myositis- right upper arm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17833","9","Other myositis- unspecified ankle and foot","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17834","9","Other myositis- unspecified forearm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17835","9","Other myositis- unspecified hand","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17836","9","Other myositis- unspecified lower leg","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17837","9","Other myositis- unspecified shoulder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17838","9","Other myositis- unspecified site","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17839","9","Other myositis- unspecified thigh","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17840","9","Other myositis- unspecified upper arm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17841","9","Other neonatal aspiration with respiratory symptoms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17842","9","Other neonatal aspiration without respiratory symptoms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17843","9","Other neutropenia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17844","9","Other obesity","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17845","9","Other obesity due to excess calories","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17846","9","Other oral mucositis (ulcerative)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17847","9","Other pancytopenia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17848","9","Other parasomnia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17849","9","Other peritonitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17850","9","Other pneumonia- unspecified organism","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17851","9","Other problems with newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17852","9","Other problems with newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17853","9","Other proteinuria","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17854","9","Other retroperitoneal abscess","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17855","9","Other seizures","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17856","9","Other seizures","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17857","9","Other shock","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17858","9","Other sleep apnea","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17859","9","Other sleep disorders","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17860","9","Other sleep related movement disorders","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17861","9","Other soft tissue disorders related to use- overuse and pressure multiple sites","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17862","9","Other soft tissue disorders related to use- overuse and pressure of unspecified site","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17863","9","Other soft tissue disorders related to use- overuse and pressure other site","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17864","9","Other soft tissue disorders related to use- overuse and pressure- left ankle and foot","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17865","9","Other soft tissue disorders related to use- overuse and pressure- left forearm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17866","9","Other soft tissue disorders related to use- overuse and pressure- left hand","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17867","9","Other soft tissue disorders related to use- overuse and pressure- left lower leg","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17868","9","Other soft tissue disorders related to use- overuse and pressure- left shoulder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17869","9","Other soft tissue disorders related to use- overuse and pressure- left thigh","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17870","9","Other soft tissue disorders related to use- overuse and pressure- left upper arm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17871","9","Other soft tissue disorders related to use- overuse and pressure- right ankle and foot","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17872","9","Other soft tissue disorders related to use- overuse and pressure- right forearm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17873","9","Other soft tissue disorders related to use- overuse and pressure- right hand","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17874","9","Other soft tissue disorders related to use- overuse and pressure- right lower leg","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17875","9","Other soft tissue disorders related to use- overuse and pressure- right shoulder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17876","9","Other soft tissue disorders related to use- overuse and pressure- right thigh","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17877","9","Other soft tissue disorders related to use- overuse and pressure- right upper arm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17878","9","Other soft tissue disorders related to use- overuse and pressure- unspecified ankle and foot","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17879","9","Other soft tissue disorders related to use- overuse and pressure- unspecified forearm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17880","9","Other soft tissue disorders related to use- overuse and pressure- unspecified hand","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17881","9","Other soft tissue disorders related to use- overuse and pressure- unspecified leg","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17882","9","Other soft tissue disorders related to use- overuse and pressure- unspecified shoulder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17883","9","Other soft tissue disorders related to use- overuse and pressure- unspecified thigh","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17884","9","Other soft tissue disorders related to use- overuse and pressure- unspecified upper arms","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17885","9","Other specified congenital malformations of female genitalia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17886","9","Other specified dermatitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17887","9","Other specified diabetes mellitus with diabetic peripheral angiopathy with gangrene","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17888","9","Other specified diabetes mellitus without complications","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17889","9","Other specified diabetes mellitus without complications","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17890","9","Other specified diseases of upper respiratory tract","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17891","9","Other specified disorders of breast","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17892","9","Other specified disorders of nose and nasal sinuses","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17893","9","Other specified intestinal infections","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17894","9","Other specified noninfective gastroenteritis and colitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17895","9","Other specified pleural conditions","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17896","9","Other specified problems related to primary support group","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17897","9","Other specified soft tissue disorders","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17898","9","Other specified symptoms and signs involving the circulatory and respiratory systems","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17899","9","Other specified transitory neonatal endocrine disorders","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17900","9","Other symptoms and signs involving appearance and behavior","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17901","9","Other symptoms and signs involving the genitourinary system","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17902","9","Other transitory disorders of carbohydrate metabolism of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17903","9","Other transitory metabolic disturbances of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17904","9","Other transitory neonatal disorders of thyroid function- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17905","9","Other trigeminal autonomic cephalgias (TAC)- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17906","9","Other trigeminal autonomic cephalgias (TAC)- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17907","9","Other upbringing away from parents","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17908","9","Other viral agents as the cause of diseases classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17909","9","Other visual disturbances","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17910","9","Other vomiting of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17911","9","Other vulvodynia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17912","9","Otitis media- unspecified- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17913","9","Otitis media- unspecified- left ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17914","9","Otitis media- unspecified- right ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17915","9","Otitis media- unspecified- unspecified ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17916","9","Overfeeding of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17917","9","Overweight","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17918","9","Pain- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17919","9","Pain- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17920","9","Painful micturition- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17921","9","Palpitations","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17922","9","Parasomnia in conditions classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17923","9","Parasomnia- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17924","9","Partial androgen insensitivity syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17925","9","Partial loss of teeth due to trauma- class I","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17926","9","Partial loss of teeth due to trauma- class II","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17927","9","Partial loss of teeth due to trauma- class III","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17928","9","Partial loss of teeth due to trauma- class IV","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17929","9","Partial loss of teeth due to trauma- unspecified class","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17930","9","Parvovirus infection- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17931","9","Patient\'s noncompliance with renal dialysis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17932","9","Pediculosis due to Pediculus humanus capitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17933","9","Pelvic and perineal pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17934","9","Periodic limb movement disorder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17935","9","Peritoneal abscess","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17936","9","Periumbilical pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17937","9","Persistent migraine aura with cerebral infarction- intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17938","9","Persistent migraine aura with cerebral infarction- intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17939","9","Persistent migraine aura with cerebral infarction- not intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17940","9","Persistent migraine aura with cerebral infarction- not intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17941","9","Persistent migraine aura without cerebral infarction- intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17942","9","Persistent migraine aura without cerebral infarction- intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17943","9","Persistent migraine aura without cerebral infarction- not intractable- with status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17944","9","Persistent migraine aura without cerebral infarction- not intractable- without status migrainosus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17945","9","Persistent proteinuria- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17946","9","Person encountering health services to consult on behalf of another person","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17947","9","Person with feared health complaint in whom no diagnosis is made","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17948","9","Personal history of (healed) osteoporosis fracture","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17949","9","Personal history of (healed) other pathological fracture","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17950","9","Personal history of (healed) stress fracture","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17951","9","Personal history of (healed) traumatic fracture","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17952","9","Personal history of antineoplastic chemotherapy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17953","9","Personal history of in utero procedure while a fetus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17954","9","Personal history of Methicillin resistant Staphylococcus aureus infection","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17955","9","Personal history of monoclonal drug therapy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17956","9","Personal history of other (healed) physical injury and trauma","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17957","9","Personal history of other diseases of the musculoskeletal system and connective tissue","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17958","9","Personal history of other drug therapy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17959","9","Personal history of self-harm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17960","9","Pingueculitis- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17961","9","Pingueculitis- left eye","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17962","9","Pingueculitis- right eye","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17963","9","Pingueculitis- unspecified eye","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17964","9","Pityriasis rosea","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17965","9","Plantar wart","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17966","9","Plateau iris syndrome (post-iridectomy) (postprocedural)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17967","9","Pleural effusion- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17968","9","Pneumonia due to Methicillin resistant Staphylococcus aureus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17969","9","Pneumonia- unspecified organism","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17970","9","Post-transplant lymphoproliferative disorder (PTLD)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17971","9","Post-traumatic headache- unspecified- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17972","9","Post-traumatic headache- unspecified- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17973","9","Postherpetic myelitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17974","9","Postimmunization acute disseminated encephalitis- myelitis and encephalomyelitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17975","9","Postimmunization acute disseminated encephalitis- myelitis and encephalomyelitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17976","9","Postimmunization acute necrotizing hemorrhagic encephalopathy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17977","9","Postinfectious acute disseminated encephalitis and encephalomyelitis (postinfectious ADEM)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17978","9","Postinfectious acute necrotizing hemorrhagic encephalopathy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17979","9","Postnasal drip","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17980","9","Postprocedural fever","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17981","9","Postvaccination fever","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17982","9","Postviral fatigue syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17983","9","Pressure ulcer of contiguous site of back- buttock and hip- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17984","9","Pressure ulcer of head- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17985","9","Pressure ulcer of left ankle- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17986","9","Pressure ulcer of left buttock- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17987","9","Pressure ulcer of left elbow- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17988","9","Pressure ulcer of left heel- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17989","9","Pressure ulcer of left hip- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17990","9","Pressure ulcer of left lower back- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17991","9","Pressure ulcer of left upper back- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17992","9","Pressure ulcer of other site- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17993","9","Pressure ulcer of right ankle- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17994","9","Pressure ulcer of right buttock- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17995","9","Pressure ulcer of right elbow- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17996","9","Pressure ulcer of right heel- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17997","9","Pressure ulcer of right hip- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17998","9","Pressure ulcer of right lower back- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("17999","9","Pressure ulcer of right upper back- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18000","9","Pressure ulcer of sacral region- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18001","9","Pressure ulcer of unspecified ankle- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18002","9","Pressure ulcer of unspecified buttock- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18003","9","Pressure ulcer of unspecified elbow- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18004","9","Pressure ulcer of unspecified heel- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18005","9","Pressure ulcer of unspecified hip- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18006","9","Pressure ulcer of unspecified part of back- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18007","9","Pressure ulcer of unspecified site- unspecified stage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18008","9","Preterm newborn- unspecified weeks of gestation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18009","9","Primary central sleep apnea","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18010","9","Primary cough headache","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18011","9","Primary dysmenorrhea","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18012","9","Primary exertional headache","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18013","9","Primary stabbing headache","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18014","9","Primary thunderclap headache","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18015","9","Projectile vomiting","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18016","9","Proteinuria- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18017","9","Psoas muscle abscess","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18018","9","Psychophysiologic insomnia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18019","9","Ptosis of breast","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18020","9","Rash and other nonspecific skin eruption","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18021","9","Raynaud\'s syndrome with gangrene","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18022","9","Recurrent hypersomnia","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18023","9","Recurrent isolated sleep paralysis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18024","9","Regurgitation and rumination of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18025","9","REM sleep behavior disorder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18026","9","Respiratory arrest of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18027","9","Restless legs syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18028","9","Retinopathy of prematurity- unspecified- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18029","9","Retinopathy of prematurity- unspecified- left eye","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18030","9","Retinopathy of prematurity- unspecified- right eye","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18031","9","Retinopathy of prematurity- unspecified- unspecified eye","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18032","9","Right lower quadrant pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18033","9","Right upper quadrant pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18034","9","Satisfactory anal smear but lacking transformation zone","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18035","9","Satisfactory cervical smear but lacking transformation zone","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18036","9","Scabies","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18037","9","Sclerosing mesenteritis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18038","9","Seborrheic dermatitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18039","9","Secondary dysmenorrhea","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18040","9","Secondary lactase deficiency","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18041","9","Sensorineural hearing loss- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18042","9","Sensorineural hearing loss- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18043","9","Sensorineural hearing loss- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18044","9","Sensorineural hearing loss- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18045","9","Sensorineural hearing loss- unilateral- left ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18046","9","Sensorineural hearing loss- unilateral- left ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18047","9","Sensorineural hearing loss- unilateral- left ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18048","9","Sensorineural hearing loss- unilateral- left ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18049","9","Sensorineural hearing loss- unilateral- right ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18050","9","Sensorineural hearing loss- unilateral- right ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18051","9","Sensorineural hearing loss- unilateral- right ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18052","9","Sensorineural hearing loss- unilateral- right ear- with unrestricted hearing on the contralateral side","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18053","9","Sepsis due to Methicillin resistant Staphylococcus aureus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18054","9","Severe persistent asthma with (acute) exacerbation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18055","9","Severe persistent asthma with (acute) exacerbation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18056","9","Severe persistent asthma with status asthmaticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18057","9","Severe persistent asthma with status asthmaticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18058","9","Severe persistent asthma- uncomplicated","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18059","9","Severe persistent asthma- uncomplicated","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18060","9","Severe sepsis with septic shock","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18061","9","Shock- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18062","9","Short lasting unilateral neuralgiform headache with conjunctival injection and tearing (SUNCT)- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18063","9","Short lasting unilateral neuralgiform headache with conjunctival injection and tearing (SUNCT)- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18064","9","Shortness of breath","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18065","9","Simple febrile convulsions","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18066","9","Sleep apnea- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18067","9","Sleep disorder- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18068","9","Sleep related bruxism","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18069","9","Sleep related hypoventilation in conditions classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18070","9","Sleep related leg cramps","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18071","9","Slow feeding of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18072","9","Sneezing","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18073","9","Soft tissue disorder- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18074","9","Speech and language development delay due to hearing loss","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18075","9","Splenomegaly- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18076","9","Spontaneous bacterial peritonitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18077","9","Status post administration of tPA (rtPA) in a different facility within the last 24 hours prior to admission to current facility","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18078","9","Stevens-Johnson syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18079","9","Stevens-Johnson syndrome-toxic epidermal necrolysis overlap syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18080","9","Straining to void","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18081","9","Stress fracture- hip- unspecified- initial encounter for fracture","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18082","9","Stress fracture- left femur- initial encounter for fracture","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18083","9","Stress fracture- pelvis- initial encounter for fracture","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18084","9","Stress fracture- right femur- initial encounter for fracture","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18085","9","Stress fracture- unspecified femur- initial encounter for fracture","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18086","9","Subacute and chronic vaginitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18087","9","Subacute and chronic vulvitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18088","9","Subacute necrotizing myelitis of central nervous system","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18089","9","Sucrase-isomaltase deficiency","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18090","9","Sunburn of first degree","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18091","9","Sunburn- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18092","9","Syncope and collapse","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18093","9","Synovitis and tenosynovitis- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18094","9","Tachycardia- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18095","9","Teething syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18096","9","Tension-type headache- unspecified- intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18097","9","Tension-type headache- unspecified- not intractable","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18098","9","Tinea unguium","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18099","9","Torticollis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18100","9","Toxic encephalopathy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18101","9","Toxic encephalopathy","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18102","9","Toxic epidermal necrolysis [Lyell]","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18103","9","Transitory hyperammonemia of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18104","9","Transitory tyrosinemia of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18105","9","Transplanted organ removal status","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18106","9","Trisomy 21- mosaicism (mitotic nondisjunction)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18107","9","Trisomy 21- nonmosaicism (meiotic nondisjunction)","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18108","9","Trisomy 21- translocation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18109","9","Type 1 diabetes mellitus with diabetic peripheral angiopathy with gangrene","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18110","9","Type 1 diabetes mellitus without complications","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18111","9","Type 2 diabetes mellitus with diabetic peripheral angiopathy with gangrene","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18112","9","Type 2 diabetes mellitus without complications","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18113","9","Underfeeding of newborn","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18114","9","Unilateral inguinal hernia- without obstruction or gangrene- recurrent","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18115","9","Unsatisfactory cytologic smear of anus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18116","9","Unsatisfactory cytologic smear of vagina","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18117","9","Unspecified abdominal pain","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18118","9","Unspecified abnormal cytological findings in specimens from anus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18119","9","Unspecified abnormal findings in urine","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18120","9","Unspecified abnormalities of heart beat","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18121","9","Unspecified acute conjunctivitis- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18122","9","Unspecified acute conjunctivitis- left eye","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18123","9","Unspecified acute conjunctivitis- right eye","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18124","9","Unspecified acute conjunctivitis- unspecified eye","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18125","9","Unspecified asthma with (acute) exacerbation","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18126","9","Unspecified asthma with status asthmaticus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18127","9","Unspecified asthma- uncomplicated","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18128","9","Unspecified chronic respiratory disease originating in the perinatal period","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18129","9","Unspecified congenital malformations of vulva","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18130","9","Unspecified conjunctivitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18131","9","Unspecified contact dermatitis due to plants- except food","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18132","9","Unspecified contact dermatitis- unspecified cause","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18133","9","Unspecified convulsions","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18134","9","Unspecified dacryocystitis of bilateral lacrimal passages","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18135","9","Unspecified dacryocystitis of left lacrimal passage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18136","9","Unspecified dacryocystitis of right lacrimal passage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18137","9","Unspecified dacryocystitis of unspecified lacrimal passage","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18138","9","Unspecified disorder of nose and nasal sinuses","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18139","9","Unspecified enterovirus as the cause of diseases classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18140","9","Unspecified lack of expected normal physiological development in childhood","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18141","9","Unspecified lump in breast","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18142","9","Unspecified nonsuppurative otitis media- bilateral","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18143","9","Unspecified nonsuppurative otitis media- left ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18144","9","Unspecified nonsuppurative otitis media- right ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18145","9","Unspecified nonsuppurative otitis media- unspecified ear","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18146","9","Unspecified sensorineural hearing loss","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18147","9","Unspecified sensorineural hearing loss","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18148","9","Unspecified sensorineural hearing loss","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18149","9","Unspecified soft tissue disorder related to use- overuse and pressure multiple sites","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18150","9","Unspecified soft tissue disorder related to use- overuse and pressure of unspecified site","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18151","9","Unspecified soft tissue disorder related to use- overuse and pressure other","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18152","9","Unspecified soft tissue disorder related to use- overuse and pressure- left ankle and foot","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18153","9","Unspecified soft tissue disorder related to use- overuse and pressure- left forearm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18154","9","Unspecified soft tissue disorder related to use- overuse and pressure- left hand","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18155","9","Unspecified soft tissue disorder related to use- overuse and pressure- left lower leg","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18156","9","Unspecified soft tissue disorder related to use- overuse and pressure- left shoulder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18157","9","Unspecified soft tissue disorder related to use- overuse and pressure- left thigh","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18158","9","Unspecified soft tissue disorder related to use- overuse and pressure- left upper arm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18159","9","Unspecified soft tissue disorder related to use- overuse and pressure- right ankle and foot","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18160","9","Unspecified soft tissue disorder related to use- overuse and pressure- right forearm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18161","9","Unspecified soft tissue disorder related to use- overuse and pressure- right hand","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18162","9","Unspecified soft tissue disorder related to use- overuse and pressure- right lower leg","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18163","9","Unspecified soft tissue disorder related to use- overuse and pressure- right shoulder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18164","9","Unspecified soft tissue disorder related to use- overuse and pressure- right thigh","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18165","9","Unspecified soft tissue disorder related to use- overuse and pressure- right upper arm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18166","9","Unspecified soft tissue disorder related to use- overuse and pressure- unspecified ankle and foot","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18167","9","Unspecified soft tissue disorder related to use- overuse and pressure- unspecified forearm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18168","9","Unspecified soft tissue disorder related to use- overuse and pressure- unspecified hand","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18169","9","Unspecified soft tissue disorder related to use- overuse and pressure- unspecified lower leg","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18170","9","Unspecified soft tissue disorder related to use- overuse and pressure- unspecified shoulder","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18171","9","Unspecified soft tissue disorder related to use- overuse and pressure- unspecified thigh","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18172","9","Unspecified soft tissue disorder related to use- overuse and pressure- unspecified upper arm","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18173","9","Unspecified symptoms and signs involving the genitourinary system","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18174","9","Unspecified urinary incontinence","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18175","9","Unspecified viral infection characterized by skin and mucous membrane lesions","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18176","9","Unspecified viral infection characterized by skin and mucous membrane lesions","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18177","9","Upper abdominal pain- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18178","9","Urinary tract infection- site not specified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18179","9","Urticaria- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18180","9","Vaginal high risk human papillomavirus (HPV) DNA test positive","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18181","9","Vaginal low risk human papillomavirus (HPV) DNA test positive","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18182","9","Varicella myelitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18183","9","Varicella without complication","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18184","9","Vascular headache- not elsewhere classified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18185","9","Vasomotor rhinitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18186","9","Vesical tenesmus","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18187","9","Viral intestinal infection- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18188","9","Viral wart- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18189","9","Vomiting without nausea","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18190","9","Vomiting- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18191","9","Vulvar vestibulitis","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18192","9","Vulvodynia- unspecified","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18193","9","Wandering in diseases classified elsewhere","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18194","9","Weakness","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18195","9","Wheezing","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("18196","9","Wilson-Mikity syndrome","0","0","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");
INSERT INTO tbl_diagnosis_setting VALUES("20574","9","fever","0","1","0","0","2019-02-05 00:00:00","2019-02-08 10:22:00");



DROP TABLE tbl_diagnosis_type;

CREATE TABLE `tbl_diagnosis_type` (
  `tdt_id` int(11) NOT NULL AUTO_INCREMENT,
  `tdt_name` varchar(150) NOT NULL,
  `tdt_default` int(11) NOT NULL DEFAULT '0',
  `tdt_del` int(11) NOT NULL DEFAULT '0',
  `tdt_created_by` int(11) NOT NULL DEFAULT '0',
  `tdt_modify_by` int(11) DEFAULT '0',
  `tdt_delete_by` int(11) DEFAULT '0',
  `tdt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdt_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO tbl_diagnosis_type VALUES("1","Primary","0","0","0","0","0","2018-12-19 12:29:36","2018-12-19 14:07:06");
INSERT INTO tbl_diagnosis_type VALUES("2","Secondary","0","0","0","0","0","2018-12-19 12:30:47","2018-12-19 12:31:53");
INSERT INTO tbl_diagnosis_type VALUES("3","Provisional","1","0","0","0","0","2018-12-19 12:30:55","2018-12-19 14:07:06");
INSERT INTO tbl_diagnosis_type VALUES("4","fever","0","0","0","0","0","2019-01-03 13:38:52","");



DROP TABLE tbl_discharge_advice_master;

CREATE TABLE `tbl_discharge_advice_master` (
  `tdam_id` int(11) NOT NULL AUTO_INCREMENT,
  `tdam_hm_id` int(11) DEFAULT NULL,
  `tdam_um_id` int(11) DEFAULT NULL,
  `tdam_template_name` varchar(250) DEFAULT NULL,
  `tdam_template_content` longtext,
  `tdam_del` int(11) NOT NULL DEFAULT '0',
  `tdam_created_by` int(11) DEFAULT NULL,
  `tdam_modify_by` int(11) DEFAULT NULL,
  `tdam_delete_by` int(11) DEFAULT NULL,
  `tdam_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdam_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdam_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_discharge_condition_master;

CREATE TABLE `tbl_discharge_condition_master` (
  `tdcm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tdcm_hm_id` int(11) DEFAULT NULL,
  `tdcm_um_id` int(11) DEFAULT NULL,
  `tdcm_template_name` varchar(250) DEFAULT NULL,
  `tdcm_template_content` longtext,
  `tdcm_del` int(11) NOT NULL DEFAULT '0',
  `tdcm_created_by` int(11) DEFAULT NULL,
  `tdcm_modify_by` int(11) DEFAULT NULL,
  `tdcm_delete_by` int(11) DEFAULT NULL,
  `tdcm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdcm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdcm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_discharge_history_present_master;

CREATE TABLE `tbl_discharge_history_present_master` (
  `tdhpm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tdhpm_hm_id` int(11) DEFAULT NULL,
  `tdhpm_um_id` int(11) DEFAULT NULL,
  `tdhpm_template_name` varchar(250) DEFAULT NULL,
  `tdhpm_template_content` longtext,
  `tdhpm_del` int(11) NOT NULL DEFAULT '0',
  `tdhpm_created_by` int(11) DEFAULT NULL,
  `tdhpm_modify_by` int(11) DEFAULT NULL,
  `tdhpm_delete_by` int(11) DEFAULT NULL,
  `tdhpm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdhpm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdhpm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_discharge_how_obt_urgent_care_master;

CREATE TABLE `tbl_discharge_how_obt_urgent_care_master` (
  `thoucm_id` int(11) NOT NULL AUTO_INCREMENT,
  `thoucm_hm_id` int(11) DEFAULT NULL,
  `thoucm_um_id` int(11) DEFAULT NULL,
  `thoucm_template_name` varchar(250) DEFAULT NULL,
  `thoucm_template_content` longtext,
  `thoucm_del` int(11) NOT NULL DEFAULT '0',
  `thoucm_created_by` int(11) DEFAULT NULL,
  `thoucm_modify_by` int(11) DEFAULT NULL,
  `thoucm_delete_by` int(11) DEFAULT NULL,
  `thoucm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `thoucm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`thoucm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_discharge_investigation_master;

CREATE TABLE `tbl_discharge_investigation_master` (
  `tdim_id` int(11) NOT NULL AUTO_INCREMENT,
  `tdim_hm_id` int(11) DEFAULT NULL,
  `tdim_um_id` int(11) DEFAULT NULL,
  `tdim_template_name` varchar(250) DEFAULT NULL,
  `tdim_template_content` longtext,
  `tdim_del` int(11) NOT NULL DEFAULT '0',
  `tdim_created_by` int(11) DEFAULT NULL,
  `tdim_modify_by` int(11) DEFAULT NULL,
  `tdim_delete_by` int(11) DEFAULT NULL,
  `tdim_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdim_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdim_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_discharge_procedure_master;

CREATE TABLE `tbl_discharge_procedure_master` (
  `tdppm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tdppm_hm_id` int(11) DEFAULT NULL,
  `tdppm_um_id` int(11) DEFAULT NULL,
  `tdppm_template_name` varchar(250) DEFAULT NULL,
  `tdppm_template_content` longtext,
  `tdppm_del` int(11) NOT NULL DEFAULT '0',
  `tdppm_created_by` int(11) DEFAULT NULL,
  `tdppm_modify_by` int(11) DEFAULT NULL,
  `tdppm_delete_by` int(11) DEFAULT NULL,
  `tdppm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdppm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdppm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_discharge_radiology_report_master;

CREATE TABLE `tbl_discharge_radiology_report_master` (
  `tdrrm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tdrrm_hm_id` int(11) DEFAULT NULL,
  `tdrrm_um_id` int(11) DEFAULT NULL,
  `tdrrm_template_name` varchar(250) DEFAULT NULL,
  `tdrrm_template_content` longtext,
  `tdrrm_del` int(11) NOT NULL DEFAULT '0',
  `tdrrm_created_by` int(11) DEFAULT NULL,
  `tdrrm_modify_by` int(11) DEFAULT NULL,
  `tdrrm_delete_by` int(11) DEFAULT NULL,
  `tdrrm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdrrm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdrrm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_discharge_when_obt_urgent_care_master;

CREATE TABLE `tbl_discharge_when_obt_urgent_care_master` (
  `twoucm_id` int(11) NOT NULL AUTO_INCREMENT,
  `twoucm_hm_id` int(11) DEFAULT NULL,
  `twoucm_um_id` int(11) DEFAULT NULL,
  `twoucm_template_name` varchar(250) DEFAULT NULL,
  `twoucm_template_content` longtext,
  `twoucm_del` int(11) NOT NULL DEFAULT '0',
  `twoucm_created_by` int(11) DEFAULT NULL,
  `twoucm_modify_by` int(11) DEFAULT NULL,
  `twoucm_delete_by` int(11) DEFAULT NULL,
  `twoucm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `twoucm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`twoucm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_doctor_block_time;

CREATE TABLE `tbl_doctor_block_time` (
  `tdbt_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `um_id` int(11) NOT NULL,
  `block_type` varchar(70) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `repeat_key` int(11) NOT NULL DEFAULT '0',
  `repeat_type` varchar(70) DEFAULT NULL,
  `repeat_value` varchar(350) DEFAULT NULL,
  `repeat_until` varchar(30) NOT NULL,
  `tdbt_del` int(11) NOT NULL DEFAULT '0',
  `tdbt_created_by` int(11) NOT NULL,
  `tdbt_modify_by` int(11) NOT NULL DEFAULT '0',
  `tdbt_delete_by` int(11) NOT NULL DEFAULT '0',
  `tdbt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdbt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdbt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_doctor_general_availablity;

CREATE TABLE `tbl_doctor_general_availablity` (
  `tdga_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `tdga_type` int(11) DEFAULT NULL,
  `tdga_day` int(11) DEFAULT NULL,
  `tdga_date` date DEFAULT NULL,
  `tdga_slot1` time DEFAULT NULL,
  `tdga_slot2` time DEFAULT NULL,
  `tdga_slot3` time DEFAULT NULL,
  `tdga_slot4` time DEFAULT NULL,
  `tdga_del` int(11) DEFAULT '0',
  `tdga_created_by` int(11) DEFAULT NULL,
  `tdga_modify_by` int(11) DEFAULT NULL,
  `tdga_delete_by` int(11) DEFAULT NULL,
  `tdga_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdge_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdga_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_doctor_general_order_template;

CREATE TABLE `tbl_doctor_general_order_template` (
  `tdgot_id` int(11) NOT NULL AUTO_INCREMENT,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tdgot_template_name` varchar(150) DEFAULT NULL,
  `tdgot_title` longtext,
  `tdgot_del` int(11) NOT NULL DEFAULT '0',
  `tdgot_created_by` int(11) NOT NULL DEFAULT '0',
  `tdgot_modify_by` int(11) DEFAULT NULL,
  `tdgot_delete_by` int(11) NOT NULL DEFAULT '0',
  `tdgot_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdgot_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdgot_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_doctor_holiday_availablity;

CREATE TABLE `tbl_doctor_holiday_availablity` (
  `tdha_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `tdha_holiday_type` int(11) DEFAULT NULL,
  `tdha_day_range` text,
  `tdha_one_date` date DEFAULT NULL,
  `tdha_one_day_select` int(11) DEFAULT NULL,
  `tdha_one_half_slot1` time DEFAULT '00:00:00',
  `tdha_one_half_slot2` time DEFAULT '00:00:00',
  `tdha_date_range` int(11) DEFAULT NULL,
  `tdha_date_slot1` date DEFAULT NULL,
  `tdha_date_slot2` date DEFAULT NULL,
  `tdha_del` int(11) DEFAULT '0',
  `tdha_created_by` int(11) DEFAULT NULL,
  `tdha_modify_by` int(11) DEFAULT NULL,
  `tdha_delete_by` int(11) DEFAULT NULL,
  `tdha_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdha_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdha_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_doctor_notes_template;

CREATE TABLE `tbl_doctor_notes_template` (
  `tdnt_id` int(11) NOT NULL AUTO_INCREMENT,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tdnt_title` varchar(250) DEFAULT NULL,
  `tdnt_notes` longtext,
  `tdnt_del` int(11) NOT NULL DEFAULT '0',
  `tdnt_created_by` int(11) NOT NULL DEFAULT '0',
  `tdnt_modify_by` int(11) DEFAULT NULL,
  `tdnt_delete_by` int(11) NOT NULL DEFAULT '0',
  `tdnt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdnt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdnt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_doctor_procedure_template;

CREATE TABLE `tbl_doctor_procedure_template` (
  `tdpt_id` int(11) NOT NULL AUTO_INCREMENT,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tdpt_title` varchar(250) DEFAULT NULL,
  `tdpt_notes` longtext,
  `tdpt_del` int(11) NOT NULL DEFAULT '0',
  `tdpt_created_by` int(11) NOT NULL DEFAULT '0',
  `tdpt_modify_by` int(11) DEFAULT NULL,
  `tdpt_delete_by` int(11) NOT NULL DEFAULT '0',
  `tdpt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdpt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdpt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_doctor_reminder;

CREATE TABLE `tbl_doctor_reminder` (
  `tdr_id` int(11) NOT NULL AUTO_INCREMENT,
  `tdr_hm_id` int(11) NOT NULL DEFAULT '0',
  `tdr_um_id` int(11) NOT NULL DEFAULT '0',
  `tdr_template_content` text,
  `tdr_delete` int(11) NOT NULL DEFAULT '0',
  `tdr_created_by` int(11) DEFAULT NULL,
  `tdr_modify_by` int(11) DEFAULT NULL,
  `tdr_delete_by` int(11) DEFAULT NULL,
  `tdr_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdr_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_doctor_setting;

CREATE TABLE `tbl_doctor_setting` (
  `tds_id` int(11) NOT NULL AUTO_INCREMENT,
  `um_id` int(11) NOT NULL,
  `tds_generic` int(11) NOT NULL DEFAULT '0',
  `tds_dia_type` int(11) NOT NULL DEFAULT '0',
  `tds_ins_lang` int(11) NOT NULL DEFAULT '0',
  `tds_created_by` int(11) NOT NULL,
  `tds_modify_by` int(11) DEFAULT NULL,
  `tds_delete_by` int(11) DEFAULT NULL,
  `tds_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tds_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tds_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_email_master;

CREATE TABLE `tbl_email_master` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subject` varchar(500) DEFAULT NULL,
  `message` longtext,
  `cc` varchar(999) DEFAULT NULL,
  `bcc` varchar(999) DEFAULT NULL,
  `email_active` varchar(21) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`email_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO tbl_email_master VALUES("1","Appointment Scheduled","Appointment Scheduled Subject","Appointment Scheduled Message","","","Y");
INSERT INTO tbl_email_master VALUES("2","Appointmen Arrived","Arrived Subject","Arrived Message","","","Y");
INSERT INTO tbl_email_master VALUES("3","Appointmen Cancel","Cancel Subject","Cancel Message","","","Y");
INSERT INTO tbl_email_master VALUES("4","Appointmen Finished","Finished Subject","Finished Message","","","Y");
INSERT INTO tbl_email_master VALUES("5","Appointmen Reschedule","Reschedule Subject","Reschedule Message","","","Y");
INSERT INTO tbl_email_master VALUES("6","Total Appointment of Tomorrow","Total Appointment of Tomorrow Subject","Total Appointment of Tomorrow Message","","","Y");
INSERT INTO tbl_email_master VALUES("7","Reminders","Reminders Subject","Reminders Message","","","Y");
INSERT INTO tbl_email_master VALUES("8","Notes","Notes Subject","Notes Message
","","","Y");
INSERT INTO tbl_email_master VALUES("9","Prescription Email","Prescription Email Subject","Prescription Email Message","","","Y");
INSERT INTO tbl_email_master VALUES("10","Patient Engagement Email","Patient Engagement Via Email Subject","Patient Engagement Via Email Message","","","Y");
INSERT INTO tbl_email_master VALUES("11","Bulk Email In Data Analytics","Bulk Email In Data Analytics Subject","Bulk Email In Data Analytics Message","","","Y");
INSERT INTO tbl_email_master VALUES("12","Email Case File","Email Case File Subject","Email Case File Message","","","Y");
INSERT INTO tbl_email_master VALUES("13","Email Discharge Summary","Email Discharge Summary Subject","Email Discharge Summary Message","","","Y");
INSERT INTO tbl_email_master VALUES("14","Billing","Billing  Subject","Billing Message","","","Y");
INSERT INTO tbl_email_master VALUES("15","3C Report","3C Report Subject","3C Report Message","","","Y");



DROP TABLE tbl_fitness_certificate;

CREATE TABLE `tbl_fitness_certificate` (
  `tfc_id` int(11) NOT NULL AUTO_INCREMENT,
  `tpc_id` int(11) NOT NULL,
  `remark` varchar(750) NOT NULL,
  PRIMARY KEY (`tfc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_followup_template_master;

CREATE TABLE `tbl_followup_template_master` (
  `tftm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tftm_title` varchar(750) DEFAULT NULL,
  `tftm_desc` longtext,
  `tftm_del` int(11) NOT NULL DEFAULT '0',
  `tftm_created_by` int(11) DEFAULT NULL,
  `tftm_modify_by` int(11) DEFAULT NULL,
  `tftm_delete_by` int(11) DEFAULT NULL,
  `tftm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tftm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tftm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_hospital_master;

CREATE TABLE `tbl_hospital_master` (
  `hm_id` int(11) NOT NULL AUTO_INCREMENT,
  `mm_id` varchar(250) DEFAULT NULL,
  `ht_id` int(11) DEFAULT NULL,
  `um_id` varchar(350) DEFAULT NULL,
  `hm_name` varchar(350) DEFAULT NULL,
  `hm_parent` int(11) DEFAULT NULL,
  `hm_email` varchar(500) DEFAULT NULL,
  `hm_password` varchar(500) DEFAULT NULL,
  `hm_contact1` varchar(50) DEFAULT NULL,
  `hm_contact2` varchar(50) DEFAULT NULL,
  `hm_address1` varchar(250) DEFAULT NULL,
  `hm_address2` varchar(250) DEFAULT NULL,
  `hm_area` varchar(150) DEFAULT NULL,
  `hm_city` varchar(150) DEFAULT NULL,
  `hm_state` varchar(150) DEFAULT NULL,
  `hm_pincode` varchar(30) DEFAULT NULL,
  `hm_sub_domain` varchar(70) DEFAULT NULL,
  `hm_sub_folder` varchar(70) DEFAULT NULL,
  `hm_logo` varchar(150) DEFAULT NULL,
  `hm_favicon` varchar(150) DEFAULT NULL,
  `hm_auth_key` varchar(450) DEFAULT NULL,
  `hm_sender_id` varchar(450) DEFAULT NULL,
  `hm_route` varchar(450) DEFAULT NULL,
  `hm_del` int(11) DEFAULT NULL,
  `hm_created_by` int(11) DEFAULT NULL,
  `hm_modify_by` int(11) DEFAULT NULL,
  `hm_delete_by` int(11) DEFAULT NULL,
  `hm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `hm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`hm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_hospital_master VALUES("1","1,2,6,7,10,11,20","1","","Umiya Children Hospital","1","admin@admin.com","e6e061838856bf47e1de730719fb2609","8735979272","7203830760","132 Feet Ring Rd, ","","Naranpura, ","Ahmedabad","Gujarat","380063","","","logo1.png","","","","","","1","1","","2018-12-29 09:57:14","2018-12-29 11:13:43");



DROP TABLE tbl_hospital_module_user_type;

CREATE TABLE `tbl_hospital_module_user_type` (
  `thmu_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `ut_id` int(11) NOT NULL,
  `mm_id` varchar(250) NOT NULL,
  PRIMARY KEY (`thmu_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO tbl_hospital_module_user_type VALUES("4","1","1","1,2,6,7,10,11,20");
INSERT INTO tbl_hospital_module_user_type VALUES("5","1","2","1,2,6,7,10,11,20");
INSERT INTO tbl_hospital_module_user_type VALUES("6","1","3","2,6,20");



DROP TABLE tbl_hospital_role_master;

CREATE TABLE `tbl_hospital_role_master` (
  `thrm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) DEFAULT NULL,
  `mm_id` int(11) NOT NULL,
  `rm_id` int(11) NOT NULL DEFAULT '0',
  `thrm_created_by` int(11) NOT NULL DEFAULT '0',
  `thrm_modify_by` int(11) DEFAULT '0',
  `thrm_delete_by` int(11) DEFAULT '0',
  `thrm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `thrm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`thrm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=204 DEFAULT CHARSET=latin1;

INSERT INTO tbl_hospital_role_master VALUES("122","1","1","9","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("123","1","1","10","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("124","1","2","1","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("125","1","2","2","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("126","1","2","3","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("127","1","2","4","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("128","1","2","5","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("129","1","2","6","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("130","1","2","8","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("131","1","2","356","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("132","1","2","362","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("133","1","6","22","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("134","1","6","23","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("135","1","6","24","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("136","1","6","25","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("137","1","6","26","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("138","1","6","27","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("139","1","6","28","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("140","1","6","357","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("141","1","6","358","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("142","1","6","369","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("143","1","7","364","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("144","1","7","365","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("145","1","7","366","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("146","1","7","367","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("147","1","7","368","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("148","1","10","30","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("149","1","10","47","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("150","1","10","48","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("151","1","10","49","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("152","1","10","50","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("153","1","11","11","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("154","1","11","33","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("155","1","11","34","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("156","1","11","35","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("157","1","11","36","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("158","1","11","37","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("159","1","11","38","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("160","1","11","39","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("161","1","11","40","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("162","1","11","41","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("163","1","11","42","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("164","1","11","43","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("165","1","11","44","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("166","1","11","45","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("167","1","11","46","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("168","1","11","359","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("169","1","11","360","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("170","1","11","361","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("171","1","11","363","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("172","1","20","268","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("173","1","20","269","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("174","1","20","270","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("175","1","20","271","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("176","1","20","272","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("177","1","20","273","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("178","1","20","274","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("179","1","20","275","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("180","1","20","276","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("181","1","20","277","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("182","1","20","278","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("183","1","20","279","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("184","1","20","280","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("185","1","20","281","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("186","1","20","282","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("187","1","20","283","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("188","1","20","284","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("189","1","20","285","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("190","1","20","286","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("191","1","20","287","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("192","1","20","288","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("193","1","20","289","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("194","1","20","290","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("195","1","20","291","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("196","1","20","292","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("197","1","20","293","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("198","1","20","294","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("199","1","20","295","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("200","1","20","296","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("201","1","20","297","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("202","1","20","298","1","0","0","2019-03-04 12:14:30","");
INSERT INTO tbl_hospital_role_master VALUES("203","1","20","299","1","0","0","2019-03-04 12:14:30","");



DROP TABLE tbl_hospital_type;

CREATE TABLE `tbl_hospital_type` (
  `ht_id` int(11) NOT NULL AUTO_INCREMENT,
  `ht_name` varchar(20) NOT NULL,
  PRIMARY KEY (`ht_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tbl_hospital_type VALUES("1","Centre");
INSERT INTO tbl_hospital_type VALUES("2","Branch");



DROP TABLE tbl_id_bill_genrerater;

CREATE TABLE `tbl_id_bill_genrerater` (
  `tig_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `id_module` varchar(150) NOT NULL,
  `id_place` varchar(20) NOT NULL,
  `prefix` varchar(15) NOT NULL,
  `prefix_num` varchar(150) DEFAULT NULL,
  `id_type` varchar(50) NOT NULL,
  `custom_opt` varchar(50) DEFAULT NULL,
  `ser_number` int(11) DEFAULT NULL,
  `tig_created_by` int(11) NOT NULL DEFAULT '0',
  `tig_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`tig_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;

INSERT INTO tbl_id_bill_genrerater VALUES("1","1","cash_memo","OPD","Yes","RS-","Custom","YearMonth","0","1","2018-12-10 14:13:09");
INSERT INTO tbl_id_bill_genrerater VALUES("2","1","invoices","OPD","Yes","INV-","Custom","YearMonth","0","1","2018-12-10 14:13:09");
INSERT INTO tbl_id_bill_genrerater VALUES("3","1","receipts","OPD","Yes","RCPT-","Custom","YearMonth","0","1","2018-12-10 14:13:09");
INSERT INTO tbl_id_bill_genrerater VALUES("4","1","advances","OPD","Yes","ADRCPT-","Custom","YearMonth","0","1","2018-12-10 14:13:09");
INSERT INTO tbl_id_bill_genrerater VALUES("5","1","credit_notes","OPD","Yes","CR-","Custom","YearMonth","0","1","2018-12-10 14:13:09");
INSERT INTO tbl_id_bill_genrerater VALUES("6","1","refund","OPD","Yes","RFD-","Custom","YearMonth","0","1","2018-12-10 14:13:09");
INSERT INTO tbl_id_bill_genrerater VALUES("7","1","estimate","OPD","Yes","EST-","Custom","YearMonth","0","1","2018-12-10 14:13:09");
INSERT INTO tbl_id_bill_genrerater VALUES("8","1","cash_memo","IPD","Yes","RS-","Custom","YearMonth","0","1","2018-12-10 14:14:17");
INSERT INTO tbl_id_bill_genrerater VALUES("9","1","invoices","IPD","Yes","INV-","Custom","YearMonth","0","1","2018-12-10 14:14:17");
INSERT INTO tbl_id_bill_genrerater VALUES("10","1","receipts","IPD","Yes","RCPT-","Custom","YearMonth","0","1","2018-12-10 14:14:17");
INSERT INTO tbl_id_bill_genrerater VALUES("11","1","advances","IPD","Yes","ADRCPT-","Custom","YearMonth","0","1","2018-12-10 14:14:17");
INSERT INTO tbl_id_bill_genrerater VALUES("12","1","credit_notes","IPD","Yes","CR-","Custom","YearMonth","0","1","2018-12-10 14:14:17");
INSERT INTO tbl_id_bill_genrerater VALUES("13","1","refund","IPD","Yes","RFD-","Custom","YearMonth","0","1","2018-12-10 14:14:17");
INSERT INTO tbl_id_bill_genrerater VALUES("14","1","estimate","IPD","Yes","EST-","Custom","YearMonth","0","1","2018-12-10 14:14:17");
INSERT INTO tbl_id_bill_genrerater VALUES("15","2","cash_memo","OPD","Yes","RS-","Custom","YearMonth","0","1","2018-12-10 14:16:23");
INSERT INTO tbl_id_bill_genrerater VALUES("16","2","invoices","OPD","Yes","INV-","Custom","YearMonth","0","1","2018-12-10 14:16:23");
INSERT INTO tbl_id_bill_genrerater VALUES("17","2","receipts","OPD","Yes","RCPT-","Custom","YearMonth","0","1","2018-12-10 14:16:23");
INSERT INTO tbl_id_bill_genrerater VALUES("18","2","advances","OPD","Yes","ADRCPT-","Custom","YearMonth","0","1","2018-12-10 14:16:23");
INSERT INTO tbl_id_bill_genrerater VALUES("19","2","credit_notes","OPD","Yes","CR-","Custom","YearMonth","0","1","2018-12-10 14:16:23");
INSERT INTO tbl_id_bill_genrerater VALUES("20","2","refund","OPD","Yes","RFD-","Custom","YearMonth","0","1","2018-12-10 14:16:23");
INSERT INTO tbl_id_bill_genrerater VALUES("21","2","estimate","OPD","Yes","EST-","Custom","YearMonth","0","1","2018-12-10 14:16:23");
INSERT INTO tbl_id_bill_genrerater VALUES("22","2","cash_memo","IPD","Yes","RS-","Custom","YearMonth","0","1","2018-12-10 14:17:13");
INSERT INTO tbl_id_bill_genrerater VALUES("23","2","invoices","IPD","Yes","INV-","Custom","YearMonth","0","1","2018-12-10 14:17:13");
INSERT INTO tbl_id_bill_genrerater VALUES("24","2","receipts","IPD","Yes","RCPT-","Custom","YearMonth","0","1","2018-12-10 14:17:13");
INSERT INTO tbl_id_bill_genrerater VALUES("25","2","advances","IPD","Yes","ADRCPT-","Custom","YearMonth","0","1","2018-12-10 14:17:13");
INSERT INTO tbl_id_bill_genrerater VALUES("26","2","credit_notes","IPD","Yes","CR-","Custom","YearMonth","0","1","2018-12-10 14:17:13");
INSERT INTO tbl_id_bill_genrerater VALUES("27","2","refund","IPD","Yes","RFD-","Custom","YearMonth","0","1","2018-12-10 14:17:13");
INSERT INTO tbl_id_bill_genrerater VALUES("28","2","estimate","IPD","Yes","EST-","Custom","YearMonth","0","1","2018-12-10 14:17:13");



DROP TABLE tbl_id_genrerater;

CREATE TABLE `tbl_id_genrerater` (
  `tig_id` int(11) NOT NULL AUTO_INCREMENT,
  `id_place` varchar(20) NOT NULL,
  `prefix` varchar(15) NOT NULL,
  `prefix_num` varchar(150) DEFAULT NULL,
  `id_type` varchar(50) NOT NULL,
  `custom_opt` varchar(50) DEFAULT NULL,
  `ser_number` int(11) DEFAULT NULL,
  `tig_created_by` int(11) NOT NULL DEFAULT '0',
  `tig_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`tig_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_id_genrerater VALUES("1","APPOINTMENT","No","","Custom","YearMonth","0","1","2018-08-14 18:02:36");



DROP TABLE tbl_id_pharmacy_genrerater;

CREATE TABLE `tbl_id_pharmacy_genrerater` (
  `tig_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `id_pharmacy` int(11) NOT NULL,
  `id_module` varchar(150) NOT NULL,
  `prefix` varchar(15) NOT NULL,
  `prefix_num` varchar(150) DEFAULT NULL,
  `id_type` varchar(50) NOT NULL,
  `custom_opt` varchar(50) DEFAULT NULL,
  `ser_number` int(11) DEFAULT NULL,
  `tig_created_by` int(11) NOT NULL DEFAULT '0',
  `tig_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`tig_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO tbl_id_pharmacy_genrerater VALUES("1","1","23","purchase_order","Yes","PO-","Custom","YearMonth","1","1","2018-12-06 11:44:02");
INSERT INTO tbl_id_pharmacy_genrerater VALUES("2","1","23","purchase_invoice","No","","Custom","YearMonth","1","1","2018-12-06 11:44:02");
INSERT INTO tbl_id_pharmacy_genrerater VALUES("3","1","23","sale_invoice","No","","Custom","YearMonth","1","1","2018-12-06 11:44:02");
INSERT INTO tbl_id_pharmacy_genrerater VALUES("4","1","23","sale_return","Yes","SR","Custom","YearMonth","1","1","2018-12-06 11:44:02");



DROP TABLE tbl_incentive_master;

CREATE TABLE `tbl_incentive_master` (
  `tim_id` int(11) NOT NULL AUTO_INCREMENT,
  `tim_user_name` varchar(250) NOT NULL,
  `tim_del` int(11) NOT NULL DEFAULT '0',
  `tim_created_by` int(11) NOT NULL DEFAULT '0',
  `tim_modify_by` int(11) NOT NULL DEFAULT '0',
  `tim_delete_by` int(11) NOT NULL DEFAULT '0',
  `tim_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tim_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO tbl_incentive_master VALUES("7","	Dr. Vijay M Patel","0","1","0","0","2019-02-07 15:05:28","");
INSERT INTO tbl_incentive_master VALUES("8","Dr. Nikita V Patel","0","1","0","0","2019-02-07 15:05:45","");



DROP TABLE tbl_inp_reference_master;

CREATE TABLE `tbl_inp_reference_master` (
  `inp_rm_id` int(11) NOT NULL AUTO_INCREMENT,
  `inp_hm_id` int(11) NOT NULL DEFAULT '0',
  `inp_um_id` int(11) NOT NULL DEFAULT '0',
  `inp_rm_type` int(11) NOT NULL DEFAULT '0',
  `inp_rm_name` varchar(200) DEFAULT NULL,
  `inp_rm_phone_no` varchar(200) DEFAULT NULL,
  `inp_rm_email` varchar(750) DEFAULT NULL,
  `inp_rm_degree` varchar(200) DEFAULT NULL,
  `inp_rm_organization` varchar(750) DEFAULT NULL,
  `inp_rm_category` int(11) NOT NULL DEFAULT '0',
  `inp_rm_location` varchar(750) DEFAULT NULL,
  `inp_rm_pincode` varchar(200) DEFAULT NULL,
  `inp_rm_area` varchar(750) DEFAULT NULL,
  `inp_rm_city` varchar(200) DEFAULT NULL,
  `inp_rm_district` varchar(750) DEFAULT NULL,
  `inp_rm_state` varchar(750) DEFAULT NULL,
  `inp_rm_country` varchar(200) DEFAULT NULL,
  `inp_rm_remark` varchar(750) DEFAULT NULL,
  `inp_rm_total` int(11) NOT NULL DEFAULT '0',
  `inp_rm_del` int(11) NOT NULL DEFAULT '0',
  `inp_rm_created_by` int(11) NOT NULL DEFAULT '0',
  `inp_rm_modify_by` int(11) NOT NULL DEFAULT '0',
  `inp_rm_delete_by` int(11) NOT NULL DEFAULT '0',
  `inp_rm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `inp_rm_modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`inp_rm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_admit_notes;

CREATE TABLE `tbl_inpatient_admit_notes` (
  `tian_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `ip_id` varchar(250) DEFAULT NULL,
  `tcm_in_chief_com` blob,
  `tcm_in_assessment_notes` blob,
  `tcm_in_history` blob,
  `tcm_in_remark` blob,
  `tcm_in_permanent_history` blob NOT NULL,
  `tcm_in_mse` blob,
  `tcm_action_final` int(11) DEFAULT NULL,
  `tian_del` int(11) NOT NULL DEFAULT '0',
  `tian_created_by` int(11) NOT NULL DEFAULT '0',
  `tian_modify_by` int(11) DEFAULT NULL,
  `tian_delete_by` int(11) NOT NULL DEFAULT '0',
  `tian_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tian_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tian_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_allergies;

CREATE TABLE `tbl_inpatient_allergies` (
  `tia_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) DEFAULT NULL,
  `pm_pid` varchar(250) DEFAULT NULL,
  `ip_id` int(11) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `tia_type` varchar(500) DEFAULT NULL,
  `tia_del` int(11) DEFAULT NULL,
  `tia_created_by` int(11) DEFAULT NULL,
  `tia_modify_by` int(11) DEFAULT NULL,
  `tia_delete_by` int(11) DEFAULT NULL,
  `tia_created_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `tia_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tia_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_body_com;

CREATE TABLE `tbl_inpatient_body_com` (
  `tibc_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tibc_height` varchar(150) DEFAULT NULL,
  `tibc_weight` varchar(150) DEFAULT NULL,
  `tibc_bmi` varchar(150) DEFAULT NULL,
  `tibc_bmr` varchar(150) DEFAULT NULL,
  `tibc_bsa` varchar(150) DEFAULT NULL,
  `tibc_del` int(11) NOT NULL DEFAULT '0',
  `tibc_created_by` int(11) NOT NULL DEFAULT '0',
  `tibc_modify_by` int(11) DEFAULT NULL,
  `tibc_delete_by` int(11) NOT NULL DEFAULT '0',
  `tibc_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tibc_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tibc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_chief_complain_master;

CREATE TABLE `tbl_inpatient_chief_complain_master` (
  `ticcm_id` int(11) NOT NULL AUTO_INCREMENT,
  `ticcm_hm_id` int(11) DEFAULT '0',
  `ticcm_um_id` int(11) DEFAULT '0',
  `ticcm_template_name` varchar(250) DEFAULT NULL,
  `ticcm_template_content` longtext,
  `ticcm_del` int(11) DEFAULT '0',
  `ticcm_created_by` int(11) DEFAULT NULL,
  `ticcm_modify_by` int(11) DEFAULT NULL,
  `ticcm_delete_by` int(11) DEFAULT NULL,
  `ticcm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ticcm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ticcm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_clinical_notes_master;

CREATE TABLE `tbl_inpatient_clinical_notes_master` (
  `ticnm_id` int(11) NOT NULL AUTO_INCREMENT,
  `ticnm_hm_id` int(11) DEFAULT '0',
  `ticnm_um_id` int(11) DEFAULT '0',
  `ticnm_template_name` varchar(250) DEFAULT NULL,
  `ticnm_template_content` longtext,
  `ticnm_del` int(11) DEFAULT '0',
  `ticnm_created_by` int(11) DEFAULT NULL,
  `ticnm_modify_by` int(11) DEFAULT NULL,
  `ticnm_delete_by` int(11) DEFAULT NULL,
  `ticnm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ticnm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ticnm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_daily_well;

CREATE TABLE `tbl_inpatient_daily_well` (
  `tidw_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tidw_days` int(11) NOT NULL DEFAULT '0',
  `tidw_time` time DEFAULT NULL,
  `tidw_sleep` varchar(150) DEFAULT NULL,
  `tidw_bowel` varchar(150) DEFAULT NULL,
  `tidw_bladder` varchar(150) DEFAULT NULL,
  `tidw_appetite` varchar(150) DEFAULT NULL,
  `tidw_ambulation` varchar(150) DEFAULT NULL,
  `tidw_eting` varchar(150) DEFAULT NULL,
  `tidw_del` int(11) NOT NULL DEFAULT '0',
  `tidw_created_by` int(11) NOT NULL DEFAULT '0',
  `tidw_modify_by` int(11) DEFAULT NULL,
  `tidw_delete_by` int(11) NOT NULL DEFAULT '0',
  `tidw_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tidw_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tidw_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_dis_summary;

CREATE TABLE `tbl_inpatient_dis_summary` (
  `tids_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `ip_id` varchar(250) DEFAULT NULL,
  `tids_procedure` longtext,
  `tids_investigation` longtext,
  `tids_radiology_report` longtext,
  `tids_history` longtext,
  `tids_dis_con` longtext,
  `tids_advice` longtext,
  `tids_tmm_id` varchar(1000) DEFAULT NULL,
  `tids_tmr_type` varchar(1000) DEFAULT NULL,
  `tids_tmr_tmm_dose` varchar(1000) DEFAULT NULL,
  `tids_tmm_medicine_name` longtext,
  `tids_tmm_generic_name` longtext,
  `tids_tmm_final_dose` varchar(1000) DEFAULT NULL,
  `tids_tmm_frequency` varchar(1000) DEFAULT NULL,
  `tids_tmm_type` varchar(750) DEFAULT NULL,
  `tids_tmm_strength` varchar(750) DEFAULT NULL,
  `tids_tmm_unit` varchar(750) DEFAULT NULL,
  `tids_tmm_time` varchar(750) DEFAULT NULL,
  `tids_tmm_days` varchar(750) DEFAULT NULL,
  `tids_tmm_duration_type` varchar(750) DEFAULT NULL,
  `tids_tmm_template_id` varchar(750) DEFAULT NULL,
  `tids_tmm_chk_value` varchar(750) DEFAULT NULL,
  `tids_tmm_custom` longtext,
  `tids_when_obt_urgent_care` longtext,
  `tids_how_obt_urgent_care` longtext,
  `tids_followup_date` date NOT NULL,
  `tids_followup_advice` longtext,
  `tids_preparred_by` varchar(500) DEFAULT NULL,
  `tids_pdf` int(11) NOT NULL DEFAULT '0',
  `tids_del` int(11) NOT NULL DEFAULT '0',
  `tids_created_by` int(11) NOT NULL DEFAULT '0',
  `tids_modify_by` int(11) DEFAULT NULL,
  `tids_delete_by` int(11) NOT NULL DEFAULT '0',
  `tids_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tids_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tids_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_discharge_diagnosis;

CREATE TABLE `tbl_inpatient_discharge_diagnosis` (
  `tidd_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tidd_diagnosis` longtext,
  `tidd_type` varchar(100) DEFAULT NULL,
  `tidd_del` int(11) NOT NULL DEFAULT '0',
  `tidd_created_by` int(11) NOT NULL DEFAULT '0',
  `tidd_modify_by` int(11) DEFAULT NULL,
  `tidd_delete_by` int(11) NOT NULL DEFAULT '0',
  `tidd_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tidd_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tidd_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_discharge_type;

CREATE TABLE `tbl_inpatient_discharge_type` (
  `tidt_id` int(11) NOT NULL AUTO_INCREMENT,
  `tidt_type` varchar(250) NOT NULL,
  `tidt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tidt_created_by` int(11) NOT NULL,
  `tidt_del` int(11) NOT NULL DEFAULT '0',
  `tidt_modify_by` int(11) DEFAULT NULL,
  `tidt_delete_by` int(11) DEFAULT NULL,
  `tidt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tidt_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO tbl_inpatient_discharge_type VALUES("1","Medical","2018-09-05 09:57:48","0","0","","","");
INSERT INTO tbl_inpatient_discharge_type VALUES("2","DAMA","2018-09-05 09:59:35","0","0","","","");
INSERT INTO tbl_inpatient_discharge_type VALUES("3","Transfer Out","2018-09-05 09:59:44","0","0","","","");
INSERT INTO tbl_inpatient_discharge_type VALUES("4","Death","2018-09-05 09:59:50","0","0","","","");



DROP TABLE tbl_inpatient_doctor_billing_sheet;

CREATE TABLE `tbl_inpatient_doctor_billing_sheet` (
  `tdbs_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tdbs_date` date DEFAULT NULL,
  `tdbs_doc_name` varchar(150) DEFAULT NULL,
  `tdbs_service` longtext,
  `tdbs_charge` varchar(150) DEFAULT NULL,
  `tdbs_remark` longtext,
  `tdbs_spo2` varchar(11) DEFAULT NULL,
  `tdbs_del` int(11) NOT NULL DEFAULT '0',
  `tdbs_created_by` int(11) NOT NULL DEFAULT '0',
  `tdbs_modify_by` int(11) DEFAULT NULL,
  `tdbs_delete_by` int(11) NOT NULL DEFAULT '0',
  `tdbs_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tiv_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdbs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_doctor_notes;

CREATE TABLE `tbl_inpatient_doctor_notes` (
  `tidn_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(350) DEFAULT NULL,
  `ip_id` varchar(350) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tidn_notes` longtext,
  `tidn_date` date DEFAULT NULL,
  `tidn_time` time DEFAULT NULL,
  `tidn_del` int(11) NOT NULL DEFAULT '0',
  `tidn_created_by` int(11) NOT NULL DEFAULT '0',
  `tidn_modify_by` int(11) DEFAULT NULL,
  `tidn_delete_by` int(11) NOT NULL DEFAULT '0',
  `tidn_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tidn_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tidn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_doctor_procedure;

CREATE TABLE `tbl_inpatient_doctor_procedure` (
  `tidp_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(350) DEFAULT NULL,
  `ip_id` varchar(350) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tidp_title` varchar(750) DEFAULT NULL,
  `tidp_notes` longtext,
  `tidp_anaesthetist` varchar(750) DEFAULT NULL,
  `tidp_date` date DEFAULT NULL,
  `tidp_time` time DEFAULT NULL,
  `tidp_del` int(11) NOT NULL DEFAULT '0',
  `tidp_created_by` int(11) NOT NULL DEFAULT '0',
  `tidp_modify_by` int(11) DEFAULT NULL,
  `tidp_delete_by` int(11) NOT NULL DEFAULT '0',
  `tidp_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tidp_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tidp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_examination_master;

CREATE TABLE `tbl_inpatient_examination_master` (
  `tiem_id` int(11) NOT NULL AUTO_INCREMENT,
  `tiem_hm_id` int(11) NOT NULL DEFAULT '0',
  `tiem_um_id` int(11) NOT NULL DEFAULT '0',
  `tiem_template_name` varchar(750) DEFAULT NULL,
  `tiem_template_content` longtext,
  `tiem_del` int(11) NOT NULL DEFAULT '0',
  `tiem_created_by` int(11) DEFAULT NULL,
  `tiem_modify_by` int(11) DEFAULT NULL,
  `tiem_delete_by` int(11) DEFAULT NULL,
  `tiem_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tiem_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tiem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_extra_medication;

CREATE TABLE `tbl_inpatient_extra_medication` (
  `tiem_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tiem_days` int(11) NOT NULL,
  `tiem_medicine` varchar(750) DEFAULT NULL,
  `tiem_time` time DEFAULT NULL,
  `tiem_remark` longtext,
  `tiem_reason` longtext,
  `tiem_del` int(11) NOT NULL DEFAULT '0',
  `tiem_created_by` int(11) NOT NULL DEFAULT '0',
  `tiem_modify_by` int(11) DEFAULT NULL,
  `tiem_delete_by` int(11) NOT NULL DEFAULT '0',
  `tiem_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tiem_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tiem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_extra_order;

CREATE TABLE `tbl_inpatient_extra_order` (
  `tieo_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tieo_days` int(11) NOT NULL,
  `tieo_details` longtext,
  `tieo_time` time DEFAULT NULL,
  `tieo_remark` longtext,
  `tieo_del` int(11) NOT NULL DEFAULT '0',
  `tieo_created_by` int(11) NOT NULL DEFAULT '0',
  `tieo_modify_by` int(11) DEFAULT NULL,
  `tieo_delete_by` int(11) NOT NULL DEFAULT '0',
  `tieo_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tieo_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tieo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_general_order;

CREATE TABLE `tbl_inpatient_general_order` (
  `tigo_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tigo_days` int(11) NOT NULL,
  `tigo_stop_days` int(11) DEFAULT NULL,
  `tigo_details` longtext,
  `tigo_status` varchar(250) DEFAULT NULL,
  `tigo_del` int(11) NOT NULL DEFAULT '0',
  `tigo_created_by` int(11) NOT NULL DEFAULT '0',
  `tigo_modify_by` int(11) DEFAULT NULL,
  `tigo_delete_by` int(11) NOT NULL DEFAULT '0',
  `tigo_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tigo_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tigo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_history_master;

CREATE TABLE `tbl_inpatient_history_master` (
  `tihm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tihm_hm_id` int(11) DEFAULT '0',
  `tihm_um_id` int(11) DEFAULT '0',
  `tihm_template_name` varchar(500) DEFAULT NULL,
  `tihm_template_content` longtext,
  `tihm_del` int(11) DEFAULT '0',
  `tihm_created_by` int(11) DEFAULT NULL,
  `tihm_modify_by` int(11) DEFAULT NULL,
  `tihm_delete_by` int(11) DEFAULT NULL,
  `tihm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tihm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tihm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_in_out_chart;

CREATE TABLE `tbl_inpatient_in_out_chart` (
  `tioc_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tioc_days` int(11) NOT NULL,
  `tioc_time` time DEFAULT NULL,
  `tioc_temp` varchar(11) DEFAULT NULL,
  `tioc_output` varchar(11) DEFAULT NULL,
  `tioc_drain_output` varchar(11) DEFAULT NULL,
  `tioc_del` int(11) NOT NULL DEFAULT '0',
  `tioc_created_by` int(11) NOT NULL DEFAULT '0',
  `tioc_modify_by` int(11) DEFAULT NULL,
  `tioc_delete_by` int(11) NOT NULL DEFAULT '0',
  `tioc_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tioc_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tioc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_investigation;

CREATE TABLE `tbl_inpatient_investigation` (
  `tii_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tii_days` int(11) NOT NULL DEFAULT '0',
  `tii_details` longtext,
  `tii_remark` longtext,
  `tii_del` int(11) NOT NULL DEFAULT '0',
  `tii_created_by` int(11) NOT NULL DEFAULT '0',
  `tii_modify_by` int(11) DEFAULT NULL,
  `tii_delete_by` int(11) NOT NULL DEFAULT '0',
  `tii_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tii_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tii_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_lab_parameter;

CREATE TABLE `tbl_inpatient_lab_parameter` (
  `tilp_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(200) DEFAULT NULL,
  `in_pid` varchar(250) DEFAULT NULL,
  `tilp_parameter_name` varchar(750) DEFAULT NULL,
  `tilp_del` int(11) NOT NULL DEFAULT '0',
  `tilp_created_by` int(11) NOT NULL DEFAULT '0',
  `tilp_modify_by` int(11) DEFAULT NULL,
  `tilp_delete_by` int(11) NOT NULL DEFAULT '0',
  `tilp_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tilp_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tilp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_lab_val;

CREATE TABLE `tbl_inpatient_lab_val` (
  `tilv_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `in_pid` varchar(250) DEFAULT NULL,
  `tilv_date` date DEFAULT NULL,
  `tilv_time` time DEFAULT NULL,
  `tilv_delete` int(11) NOT NULL DEFAULT '0',
  `tilv_created_by` int(11) NOT NULL DEFAULT '0',
  `tilv_modify_by` int(11) DEFAULT NULL,
  `tilv_delete_by` int(11) NOT NULL DEFAULT '0',
  `tilv_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tilv_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tilv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_medication_treatment;

CREATE TABLE `tbl_inpatient_medication_treatment` (
  `timt_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `timt_stop_day` int(11) DEFAULT NULL,
  `timt_days` int(11) NOT NULL,
  `timt_start_date` date NOT NULL,
  `timt_tmm_medicine_name` varchar(550) DEFAULT NULL,
  `timt_tmm_type` varchar(35) DEFAULT NULL,
  `timt_status` varchar(50) DEFAULT NULL,
  `timt_tmm_strength` varchar(50) DEFAULT NULL,
  `timt_tmm_unit` varchar(50) DEFAULT NULL,
  `timt_tmm_company` varchar(250) DEFAULT NULL,
  `timt_tmm_generic` varchar(250) DEFAULT NULL,
  `timt_tmm_time` varchar(50) DEFAULT NULL,
  `timt_tmm_custom` varchar(1000) DEFAULT NULL,
  `timt_tmm_days` int(11) NOT NULL DEFAULT '0',
  `timt_tmm_days_type` varchar(50) DEFAULT NULL,
  `timt_del` int(11) NOT NULL DEFAULT '0',
  `timt_created_by` int(11) NOT NULL DEFAULT '0',
  `timt_modify_by` int(11) DEFAULT NULL,
  `timt_delete_by` int(11) NOT NULL DEFAULT '0',
  `timt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `timt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`timt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_medicine_instruction;

CREATE TABLE `tbl_inpatient_medicine_instruction` (
  `timi_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `timi_title` varchar(150) DEFAULT NULL,
  `timi_del` int(11) NOT NULL DEFAULT '0',
  `timi_created_by` int(11) NOT NULL DEFAULT '0',
  `timi_modify_by` int(11) DEFAULT NULL,
  `timi_delete_by` int(11) NOT NULL DEFAULT '0',
  `timi_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `timi_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`timi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_nurse_billing_sheet;

CREATE TABLE `tbl_inpatient_nurse_billing_sheet` (
  `tnbs_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) DEFAULT '0',
  `tnbs_date` date DEFAULT NULL,
  `tnbs_doc_name` varchar(150) DEFAULT NULL,
  `tnbs_service` longtext,
  `tnbs_charge` varchar(150) DEFAULT NULL,
  `tnbs_remark` longtext,
  `tnbs_spo2` varchar(11) DEFAULT NULL,
  `tnbs_del` int(11) DEFAULT '0',
  `tnbs_created_by` int(11) DEFAULT '0',
  `tnbs_modify_by` int(11) DEFAULT NULL,
  `tnbs_delete_by` int(11) DEFAULT '0',
  `tnbs_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tnbs_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tnbs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_nurse_notes;

CREATE TABLE `tbl_inpatient_nurse_notes` (
  `tinn_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(350) DEFAULT NULL,
  `ip_id` varchar(350) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tinn_notes` longtext,
  `tinn_date` date DEFAULT NULL,
  `tinn_time` time DEFAULT NULL,
  `tinn_del` int(11) NOT NULL DEFAULT '0',
  `tinn_created_by` int(11) NOT NULL DEFAULT '0',
  `tinn_modify_by` int(11) DEFAULT NULL,
  `tinn_delete_by` int(11) NOT NULL DEFAULT '0',
  `tinn_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tinn_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tinn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_onadmit_diagnosis;

CREATE TABLE `tbl_inpatient_onadmit_diagnosis` (
  `tiod_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tiod_diagnosis` longtext,
  `tiod_type` varchar(100) DEFAULT NULL,
  `tiod_del` int(11) NOT NULL DEFAULT '0',
  `tiod_created_by` int(11) NOT NULL DEFAULT '0',
  `tiod_modify_by` int(11) DEFAULT NULL,
  `tiod_delete_by` int(11) NOT NULL DEFAULT '0',
  `tiod_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tiod_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tiod_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_radiology_report;

CREATE TABLE `tbl_inpatient_radiology_report` (
  `tirr_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(350) DEFAULT NULL,
  `ip_id` varchar(350) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tirr_title` varchar(250) DEFAULT NULL,
  `tirr_notes` longtext,
  `tirr_radiologist` varchar(250) DEFAULT NULL,
  `tirr_date` date DEFAULT NULL,
  `tirr_time` time DEFAULT NULL,
  `tirr_del` int(11) NOT NULL DEFAULT '0',
  `tirr_created_by` int(11) NOT NULL DEFAULT '0',
  `tirr_modify_by` int(11) DEFAULT NULL,
  `tirr_delete_by` int(11) NOT NULL DEFAULT '0',
  `tirr_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tirr_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tirr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_remarks_master;

CREATE TABLE `tbl_inpatient_remarks_master` (
  `tirm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tirm_hm_id` int(11) DEFAULT '0',
  `tirm_um_id` int(11) DEFAULT '0',
  `tirm_template_name` varchar(750) DEFAULT NULL,
  `tirm_template_content` longtext,
  `tirm_del` int(11) DEFAULT '0',
  `tirm_created_by` int(11) DEFAULT NULL,
  `tirm_modify_by` int(11) DEFAULT NULL,
  `tirm_delete_by` int(11) DEFAULT NULL,
  `tirm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tirm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tirm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatient_vitals;

CREATE TABLE `tbl_inpatient_vitals` (
  `tiv_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `ip_id` varchar(250) DEFAULT NULL,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tiv_days` int(11) NOT NULL,
  `tiv_time` time DEFAULT NULL,
  `tiv_temp` varchar(11) DEFAULT NULL,
  `tiv_pres` varchar(11) DEFAULT NULL,
  `tiv_resp_rate` varchar(11) DEFAULT NULL,
  `tiv_blood_press` varchar(11) DEFAULT NULL,
  `tiv_spo2` varchar(11) DEFAULT NULL,
  `tiv_del` int(11) NOT NULL DEFAULT '0',
  `tiv_created_by` int(11) NOT NULL DEFAULT '0',
  `tiv_modify_by` int(11) DEFAULT NULL,
  `tiv_delete_by` int(11) NOT NULL DEFAULT '0',
  `tiv_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tiv_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tiv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_inpatinet_lab_para_value;

CREATE TABLE `tbl_inpatinet_lab_para_value` (
  `tilpv_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `in_pid` varchar(250) DEFAULT NULL,
  `tilp_id` int(11) NOT NULL DEFAULT '0',
  `tilv_id` int(11) NOT NULL DEFAULT '0',
  `tilpv_value` varchar(750) DEFAULT NULL,
  `tilpv_del` int(11) NOT NULL DEFAULT '0',
  `tilpv_created_by` int(11) NOT NULL DEFAULT '0',
  `tilpv_modify_by` int(11) DEFAULT NULL,
  `tilpv_delete_by` int(11) NOT NULL DEFAULT '0',
  `tilpv_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tilpv_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tilpv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_invoice_master;

CREATE TABLE `tbl_invoice_master` (
  `im_id` int(20) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `im_pid` text NOT NULL,
  `in_pid` text,
  `im_invoice_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `im_sub_total` double(10,2) NOT NULL,
  `im_rebate_type` varchar(250) NOT NULL,
  `im_rebate_amount` double(10,2) NOT NULL,
  `im_grand_total` double(10,2) NOT NULL,
  `im_notes` varchar(250) NOT NULL,
  `im_payment_status` int(11) NOT NULL,
  `im_parent` int(11) DEFAULT '0',
  `im_status` int(11) NOT NULL DEFAULT '0',
  `im_accountant` int(11) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `im_taxtion` varchar(255) NOT NULL,
  `im_total_cgst` double(10,2) NOT NULL,
  `im_total_sgst` double(10,2) NOT NULL,
  `im_total_net_tax_amt` double(10,2) NOT NULL,
  `im_total_gross` double(10,2) NOT NULL,
  `im_total_discount` double(10,2) NOT NULL,
  `im_invoice_date` date NOT NULL,
  `im_created_id` int(11) DEFAULT NULL,
  `im_modify_by` int(11) DEFAULT '0',
  `im_delete_by` int(11) DEFAULT '0',
  `im_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `im_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`im_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_invoice_service;

CREATE TABLE `tbl_invoice_service` (
  `is_id` int(11) NOT NULL AUTO_INCREMENT,
  `im_invoice_id` text NOT NULL,
  `tbms_id` int(11) NOT NULL DEFAULT '0',
  `service_id` int(11) NOT NULL DEFAULT '0',
  `ims_price` double(10,2) NOT NULL,
  `discount` int(11) NOT NULL DEFAULT '0',
  `tax_amount` int(11) NOT NULL DEFAULT '0',
  `ims_qty` int(11) NOT NULL DEFAULT '0',
  `ims_total` double(10,2) NOT NULL,
  `is_parent` int(11) NOT NULL DEFAULT '0',
  `is_status` int(11) NOT NULL DEFAULT '0',
  `ims_sgroup` int(11) NOT NULL DEFAULT '0',
  `im_id` int(21) NOT NULL DEFAULT '0',
  `hm_id` int(21) NOT NULL DEFAULT '0',
  `bill_id` int(21) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `is_cgst_per` double(10,2) NOT NULL,
  `is_sgst_per` double(10,2) NOT NULL,
  `is_cgst` double(10,2) NOT NULL,
  `is_sgst` double(10,2) NOT NULL,
  `is_tax_amt` double(10,2) NOT NULL,
  `im_ser_description` varchar(2000) DEFAULT NULL,
  `im_services_date` date DEFAULT NULL,
  `is_delete_by` varchar(255) DEFAULT NULL,
  `ims_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`is_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_ipd_default_value;

CREATE TABLE `tbl_ipd_default_value` (
  `tdv_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) DEFAULT '0',
  `admit_um_id` int(11) NOT NULL DEFAULT '0',
  `admit_dp_id` int(11) NOT NULL DEFAULT '0',
  `dp_created_by` int(11) DEFAULT '0',
  `tdv_modify_by` int(11) DEFAULT '0',
  `tdv_delete_by` int(11) DEFAULT '0',
  `tdv_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tdv_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tdv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_login_page_master;

CREATE TABLE `tbl_login_page_master` (
  `tlpmid` int(11) NOT NULL AUTO_INCREMENT,
  `tlpm_title` varchar(255) DEFAULT NULL,
  `tlpm_logo` varchar(255) DEFAULT NULL,
  `tlpm_bg_image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`tlpmid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_login_page_master VALUES("1","Welcome","login_logo1.png","login_bg1.jpg");



DROP TABLE tbl_manage_rece_dash_dep;

CREATE TABLE `tbl_manage_rece_dash_dep` (
  `mrdd_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `dp_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`mrdd_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_medical_certificate;

CREATE TABLE `tbl_medical_certificate` (
  `tmc_id` int(11) NOT NULL AUTO_INCREMENT,
  `tpc_id` int(11) DEFAULT NULL,
  `type` varchar(25) DEFAULT NULL,
  `from_date` date DEFAULT NULL,
  `to_date` date DEFAULT NULL,
  `remark` varchar(750) DEFAULT NULL,
  PRIMARY KEY (`tmc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_medicine_instruction;

CREATE TABLE `tbl_medicine_instruction` (
  `tmi_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `dp_id` int(11) NOT NULL DEFAULT '0',
  `tmi_title` varchar(750) CHARACTER SET utf8 DEFAULT NULL,
  `tmi_english` varchar(750) CHARACTER SET utf8 DEFAULT NULL,
  `tmi_hindi` varchar(750) CHARACTER SET utf8 DEFAULT NULL,
  `tmi_gujarati` varchar(750) CHARACTER SET utf8 DEFAULT NULL,
  `tmi_del` int(11) NOT NULL DEFAULT '0',
  `tmi_created_by` int(11) NOT NULL DEFAULT '0',
  `tmi_modify_by` int(11) DEFAULT NULL,
  `tmi_delete_by` int(11) NOT NULL DEFAULT '0',
  `tmi_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tmi_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tmi_id`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=latin1;

INSERT INTO tbl_medicine_instruction VALUES("13","1","7","6","1-0-0","One in the morning, none midday, none in evening","???? ??? ??,????? ????, ??? ?? ????","????? ??, ????? ????, ????? ????","0","7","","0","2018-10-09 10:38:29","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("14","1","7","6","0-1-0","None in the morning, one midday, none in evening","???? ????,????? ??? ??, ??? ?? ????","????? ????, ?? ????, ????? ????","0","7","","0","2018-10-09 10:41:08","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("15","1","7","6","1-0-1","One in the morning, none midday, one in evening","???? ??? ??,????? ????, ??? ?? ??","????? ??, ????? ????, ?? ?????","0","7","","0","2018-10-09 10:42:47","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("16","1","7","6","1-1-0","One in the morning, one midday, none in evening","???? ??? ??,????? ??? ??, ??? ?? ????","?? ?????, ?? ?????, ????? ????","0","7","","0","2018-10-09 10:43:46","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("17","1","7","6","0-1-1","None in the morning, one midday, one in evening","???? ????,????? ??? ??, ??? ?? ??","????? ????, ?? ?????, ?? ?????","0","7","","0","2018-10-09 10:44:18","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("18","1","7","6","1-1-1","One in the morning, one midday, one in evening","???? ??? ??,????? ??? ??, ??? ?? ??","?? ?????, ?? ?????, ?? ?????","0","7","","0","2018-10-09 10:44:49","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("19","1","7","6","1 in a day","One in a Day","?? ??? ??? ??","?? ??????? ??","0","7","","0","2018-10-09 10:45:25","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("20","1","7","6","2 in a day","Two in a Day","?? ??? ??? ??","?? ??????? ??","0","7","","0","2018-10-09 10:45:57","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("21","1","7","6","3 in a day","Three in a Day","?? ??? ??? ???","?? ??????? ????","0","7","","0","2018-10-09 10:46:29","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("22","1","7","6","4 in a day","Four in a Day","?? ??? ??? ???","?? ??????? ???","0","7","","0","2018-10-09 10:46:58","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("23","1","7","6","1 at bedtime","One at Bedtime","???? ?? ??? ?? ??","???? ???? ?? ","0","7","","0","2018-10-09 10:47:50","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("24","1","7","6","2 at bedtime","Two at Bedtime","???? ?? ??? ?? ??","???? ???? ??","0","7","","0","2018-10-09 10:48:27","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("25","1","7","6","hourly one","Every hour one","?? ???? ??","?? ????? ??","0","7","","0","2018-10-09 10:49:43","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("26","1","7","6","as needed","Take as needed","????????????? ??","???????? ??????? ??","0","7","","0","2018-10-09 10:50:41","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("110","1","7","6","1-0-0","One in the morning, none midday, none in evening","???? ??? ??,????? ????, ??? ?? ????","????? ??, ????? ????, ????? ????","0","7","","0","2018-10-09 10:38:29","2018-12-29 11:03:18");
INSERT INTO tbl_medicine_instruction VALUES("111","1","1","9","3 times","","","","0","1","","0","2019-01-03 13:42:53","");



DROP TABLE tbl_medicine_master;

CREATE TABLE `tbl_medicine_master` (
  `tmm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) DEFAULT '0',
  `um_id` int(11) DEFAULT '0',
  `dp_id` int(11) NOT NULL,
  `tmm_medicine_name` varchar(500) DEFAULT NULL,
  `tmm_type` varchar(150) DEFAULT NULL,
  `tmm_strength` varchar(150) DEFAULT NULL,
  `tmm_unit` varchar(70) DEFAULT NULL,
  `tmm_generic` varchar(350) DEFAULT NULL,
  `tmm_company` varchar(350) DEFAULT NULL,
  `tmm_time` varchar(50) DEFAULT NULL,
  `tmm_dose` float NOT NULL DEFAULT '0',
  `tmm_dose_unit` varchar(50) DEFAULT NULL,
  `tmm_day_dose` varchar(50) DEFAULT NULL,
  `tmm_frequency` float NOT NULL DEFAULT '0',
  `tmm_concentration` float NOT NULL DEFAULT '0',
  `tmm_con_unit` varchar(50) DEFAULT NULL,
  `tmm_tmi_id` int(11) DEFAULT '0',
  `tmm_del` int(11) DEFAULT '0',
  `tmm_created_by` int(11) DEFAULT NULL,
  `tmm_modify_by` int(11) DEFAULT NULL,
  `tmm_delete_by` int(11) DEFAULT NULL,
  `tmm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tmm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tmm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_medicine_master VALUES("1","1","1","9","syp. calpol","","","","paracetamol","gsk","","0","","","0","0","","0","0","1","","","2019-01-03 13:37:01","2019-02-07 15:04:41");



DROP TABLE tbl_medicine_report;

CREATE TABLE `tbl_medicine_report` (
  `tmr_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `tcm_id` int(11) NOT NULL,
  `tcm_datetime` datetime NOT NULL,
  `pm_pid` varchar(500) NOT NULL,
  `um_id` int(11) NOT NULL,
  `tmr_case_type` varchar(150) DEFAULT NULL,
  `tmr_type` varchar(30) NOT NULL,
  `tmm_id` int(11) NOT NULL,
  `tmm_generic` varchar(500) DEFAULT NULL,
  `tmm_company` varchar(500) DEFAULT NULL,
  `tmr_tmm_dose` int(11) NOT NULL,
  `tmr_created_by` int(11) NOT NULL,
  `tmr_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`tmr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_medicine_template_detail;

CREATE TABLE `tbl_medicine_template_detail` (
  `tmtd_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) DEFAULT '0',
  `um_id` int(11) DEFAULT '0',
  `tmtd_template_name` varchar(750) DEFAULT NULL,
  `tmtd_tmm_id` varchar(750) DEFAULT NULL,
  `tmtd_strength` varchar(750) DEFAULT NULL,
  `tmtd_unit` varchar(750) DEFAULT NULL,
  `tmtd_time` varchar(750) DEFAULT NULL,
  `tmtd_del` int(11) DEFAULT '0',
  `tmtd_created_by` int(11) DEFAULT NULL,
  `tmtd_modify_by` int(11) DEFAULT NULL,
  `tmtd_delete_by` int(11) DEFAULT NULL,
  `tmtd_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tmtd_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tmtd_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_medicine_template_detail VALUES("1","1","1","fever","1","","","After Food","0","1","","","2019-01-03 13:37:20","");



DROP TABLE tbl_medicine_type;

CREATE TABLE `tbl_medicine_type` (
  `tmt_id` int(11) NOT NULL AUTO_INCREMENT,
  `short_name` varchar(30) DEFAULT NULL,
  `name` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`tmt_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

INSERT INTO tbl_medicine_type VALUES("1","CAP","Capule");
INSERT INTO tbl_medicine_type VALUES("2","CREAM","Cream");
INSERT INTO tbl_medicine_type VALUES("3","DROPS","Drops");
INSERT INTO tbl_medicine_type VALUES("4","FOAM","Foam");
INSERT INTO tbl_medicine_type VALUES("5","GEL","Gel");
INSERT INTO tbl_medicine_type VALUES("6","INHALER","Inhaler");
INSERT INTO tbl_medicine_type VALUES("7","INJ","Injection");
INSERT INTO tbl_medicine_type VALUES("8","LOTION","Lotion");
INSERT INTO tbl_medicine_type VALUES("9","MTHWSH","Mouthwash");
INSERT INTO tbl_medicine_type VALUES("10","OINT","Ointment");
INSERT INTO tbl_medicine_type VALUES("11","POWDR","Powder");
INSERT INTO tbl_medicine_type VALUES("12","SHAMPOO","Shampoo");
INSERT INTO tbl_medicine_type VALUES("13","SPRAY","Spray");
INSERT INTO tbl_medicine_type VALUES("14","SYRINGE","Syringe");
INSERT INTO tbl_medicine_type VALUES("15","SYRUP","Syruo");
INSERT INTO tbl_medicine_type VALUES("16","I.V.","I.V.");
INSERT INTO tbl_medicine_type VALUES("17","I.M.","I.M.");
INSERT INTO tbl_medicine_type VALUES("18","TAB","Tablet");



DROP TABLE tbl_medicine_unit_type;

CREATE TABLE `tbl_medicine_unit_type` (
  `tmut_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`tmut_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO tbl_medicine_unit_type VALUES("1","mg");
INSERT INTO tbl_medicine_unit_type VALUES("2","gm");
INSERT INTO tbl_medicine_unit_type VALUES("3","mcg");
INSERT INTO tbl_medicine_unit_type VALUES("4","mg SR");
INSERT INTO tbl_medicine_unit_type VALUES("5","million spores");
INSERT INTO tbl_medicine_unit_type VALUES("6","ml");
INSERT INTO tbl_medicine_unit_type VALUES("7","IU");
INSERT INTO tbl_medicine_unit_type VALUES("8","units");
INSERT INTO tbl_medicine_unit_type VALUES("9","%");
INSERT INTO tbl_medicine_unit_type VALUES("10","% w/v");
INSERT INTO tbl_medicine_unit_type VALUES("11","%w/w");
INSERT INTO tbl_medicine_unit_type VALUES("12","NA");



DROP TABLE tbl_medico_legal_certificate;

CREATE TABLE `tbl_medico_legal_certificate` (
  `tmlc_id` int(11) NOT NULL AUTO_INCREMENT,
  `tpc_id` int(11) DEFAULT NULL,
  `mlc_no` varchar(150) DEFAULT NULL,
  `ex_date` date DEFAULT NULL,
  `ex_time` time DEFAULT NULL,
  `acc_date` date DEFAULT NULL,
  `acc_time` time DEFAULT NULL,
  `age_of_injury` varchar(150) DEFAULT NULL,
  `cause_of_injury` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`tmlc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_module_master;

CREATE TABLE `tbl_module_master` (
  `mm_id` int(11) NOT NULL AUTO_INCREMENT,
  `mm_parent` int(11) DEFAULT '0',
  `mm_module_name` varchar(150) DEFAULT NULL,
  `mm_module_status` int(11) DEFAULT '0',
  `mm_home_folder` varchar(250) NOT NULL,
  `mm_homepage_link` varchar(250) NOT NULL,
  `mm_icon` varchar(40) DEFAULT NULL,
  `mm_home_index` int(11) NOT NULL DEFAULT '0',
  `mm_module_index` int(11) NOT NULL DEFAULT '0',
  `mm_admin_right` int(11) NOT NULL DEFAULT '0',
  `pharma_id` int(11) NOT NULL DEFAULT '0',
  `billing_id` int(11) NOT NULL DEFAULT '0',
  `bill_type` varchar(50) DEFAULT NULL,
  `mm_del` int(11) DEFAULT '0',
  `mm_created_by` int(11) DEFAULT NULL,
  `mm_modify_by` int(11) DEFAULT '0',
  `mm_delete_by` int(11) DEFAULT '0',
  `mm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `mm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`mm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

INSERT INTO tbl_module_master VALUES("1","0","Doctor Dashboard","0","","doctor_dashborad","fa-user-md","0","0","0","0","0","","0","1","1","0","2018-06-21 11:06:17","2018-07-25 14:46:36");
INSERT INTO tbl_module_master VALUES("2","0","Appointments","0","reception","reception_dashboard","fa-calendar-plus-o","0","0","0","0","0","","0","1","0","0","2018-06-21 11:06:17","2019-04-22 10:06:08");
INSERT INTO tbl_module_master VALUES("3","0","Inpatient","1","inpatient","inpatient","fa-bed","0","0","0","0","0","","1","0","0","0","2018-06-21 11:06:17","2018-12-29 09:53:15");
INSERT INTO tbl_module_master VALUES("4","0","Ward Management","1","ward_management","ward_dashboard","fa-hospital-o","0","0","0","0","0","","1","0","0","0","2018-06-21 11:06:17","2018-12-29 09:53:17");
INSERT INTO tbl_module_master VALUES("5","0","Admission Transfer Discharge","1","admission_transfer_discharge","atd_dashboard","fa-user-plus","0","0","0","0","0","","1","0","0","0","2018-06-21 11:06:17","2018-12-29 09:53:19");
INSERT INTO tbl_module_master VALUES("6","0","Data Analytics","0","master_data","master_dashboard","fa-database","0","0","0","0","0","","0","0","0","0","2018-06-21 11:08:04","2018-10-10 10:05:59");
INSERT INTO tbl_module_master VALUES("7","0","Vaccination","0","vaccination","reception_vacc","fa-eyedropper","0","0","0","0","0","","0","0","0","0","2018-06-21 11:08:04","2018-12-29 09:53:40");
INSERT INTO tbl_module_master VALUES("10","0","Settings","0","settings","setting","fa-cogs","0","0","0","0","0","","0","0","0","0","2018-06-21 11:08:04","2018-10-10 10:05:42");
INSERT INTO tbl_module_master VALUES("11","0","Case Manager","0","case_manager","","","1","0","0","0","0","","0","1","0","0","2018-06-21 13:26:24","2018-06-25 09:51:20");
INSERT INTO tbl_module_master VALUES("15","0","Pharmacy","1","pharmacy","pharmacy","fa-medkit","1","0","1","0","0","","1","1","1","0","2018-07-06 13:43:28","2018-12-29 09:53:43");
INSERT INTO tbl_module_master VALUES("19","0","Billing","0","billing","billing","fa-money","1","0","1","0","0","","0","1","1","0","2018-07-09 10:04:50","2018-07-25 14:48:16");
INSERT INTO tbl_module_master VALUES("20","19","OPD Billing","0","billing_opd","billing","fa-money","0","1","0","0","1","opd","0","1","0","0","2018-12-29 10:00:57","");



DROP TABLE tbl_msg;

CREATE TABLE `tbl_msg` (
  `tm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tm_hospital` varchar(250) DEFAULT NULL,
  `tm_auth_key` varchar(250) NOT NULL,
  `tm_sender` varchar(250) NOT NULL,
  PRIMARY KEY (`tm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_msg VALUES("1","","254538A0dWxrxmH5c2c3843","STRAUS");



DROP TABLE tbl_nurse_notes_template;

CREATE TABLE `tbl_nurse_notes_template` (
  `tnnt_id` int(11) NOT NULL AUTO_INCREMENT,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `tnnt_title` varchar(750) DEFAULT NULL,
  `tnnt_notes` longtext,
  `tnnt_del` int(11) NOT NULL DEFAULT '0',
  `tnnt_created_by` int(11) NOT NULL DEFAULT '0',
  `tnnt_modify_by` int(11) DEFAULT NULL,
  `tnnt_delete_by` int(11) NOT NULL DEFAULT '0',
  `tnnt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tnnt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tnnt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_opd_billing_advance_master;

CREATE TABLE `tbl_opd_billing_advance_master` (
  `am_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `am_advance_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `am_pid` text NOT NULL,
  `in_pid` text,
  `im_invoice_id` text NOT NULL,
  `am_advance_amount` double(10,2) NOT NULL,
  `am_parent` int(11) DEFAULT NULL,
  `am_status` int(11) NOT NULL DEFAULT '0',
  `payment_option` int(11) NOT NULL DEFAULT '0',
  `pay_ref_no` varchar(255) DEFAULT NULL,
  `bill_type` varchar(255) DEFAULT NULL,
  `am_del` int(11) NOT NULL DEFAULT '0',
  `am_date` date NOT NULL,
  `am_created_by` int(11) DEFAULT NULL,
  `am_modify_by` int(11) DEFAULT '0',
  `am_delete_by` int(11) DEFAULT '0',
  `am_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `am_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`am_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_opd_billing_credit_master;

CREATE TABLE `tbl_opd_billing_credit_master` (
  `tbcm_id` int(20) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `pid` text NOT NULL,
  `in_pid` text,
  `im_invoice_id` text NOT NULL,
  `tbcm_invoice_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `tbcm_sub_total` double(10,2) NOT NULL,
  `tbcm_rebate_type` varchar(250) NOT NULL,
  `tbcm_rebate_amount` double(10,2) NOT NULL,
  `tbcm_grand_total` double(10,2) NOT NULL,
  `tbcm_notes` varchar(250) NOT NULL,
  `tbcm_payment_status` int(11) NOT NULL DEFAULT '0',
  `tbcm_parent` int(11) DEFAULT '0',
  `tbcm_status` int(11) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `tbcm_taxtion` varchar(255) NOT NULL,
  `tbcm_total_cgst` double(10,2) NOT NULL,
  `tbcm_total_sgst` double(10,2) NOT NULL,
  `tbcm_total_net_tax_amt` double(10,2) NOT NULL,
  `tbcm_total_gross` double(10,2) NOT NULL,
  `tbcm_total_discount` double(10,2) NOT NULL,
  `tbcm_accountant` int(11) NOT NULL DEFAULT '0',
  `im_cum_ri_invoice_id` varchar(300) DEFAULT NULL,
  `im_invoice_type` varchar(255) DEFAULT NULL,
  `tbcm_invoice_date` date NOT NULL,
  `tbcm_created_id` int(11) DEFAULT NULL,
  `tbcm_modify_by` int(11) DEFAULT '0',
  `tbcm_delete_by` int(11) DEFAULT '0',
  `tbcm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbcm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbcm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_opd_billing_credit_service;

CREATE TABLE `tbl_opd_billing_credit_service` (
  `tbcs_id` int(11) NOT NULL AUTO_INCREMENT,
  `tbcs_invoice_id` text NOT NULL,
  `tbms_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `tbcs_price` double(10,2) NOT NULL,
  `discount` int(11) NOT NULL,
  `tax_amount` int(11) NOT NULL DEFAULT '0',
  `tbcs_qty` int(11) NOT NULL,
  `tbcs_total` double(10,2) NOT NULL,
  `tbcs_parent` int(11) DEFAULT '0',
  `tbcs_status` int(11) DEFAULT '0',
  `tbcs_sgroup` int(11) NOT NULL DEFAULT '0',
  `tbcs_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbcm_id` int(21) NOT NULL DEFAULT '0',
  `hm_id` int(21) NOT NULL DEFAULT '0',
  `bill_id` int(21) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `tbcs_cgst_per` double(10,2) NOT NULL,
  `tbcs_sgst_per` double(10,2) NOT NULL,
  `tbcs_cgst` double(10,2) NOT NULL,
  `tbcs_sgst` double(10,2) NOT NULL,
  `tbcs_tax_amt` double(10,2) NOT NULL,
  `tbcs_ser_description` varchar(2000) DEFAULT NULL,
  `tbcs_services_date` date DEFAULT NULL,
  `tbcs_delete_by` int(21) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tbcs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_opd_billing_estimate_master;

CREATE TABLE `tbl_opd_billing_estimate_master` (
  `tbem_id` int(20) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `tbem_pid` text NOT NULL,
  `in_pid` text,
  `tbem_invoice_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `tbem_sub_total` double(10,2) NOT NULL,
  `tbem_rebate_type` varchar(250) NOT NULL,
  `tbem_rebate_amount` double(10,2) NOT NULL,
  `tbem_grand_total` double(10,2) NOT NULL,
  `tbem_notes` varchar(250) NOT NULL,
  `tbem_payment_status` int(11) NOT NULL DEFAULT '0',
  `tbem_parent` int(11) DEFAULT NULL,
  `tbem_status` int(11) NOT NULL DEFAULT '0',
  `tbem_pname` varchar(255) DEFAULT NULL,
  `tbem_pcontact` varchar(20) DEFAULT NULL,
  `tbem_paddress` varchar(500) DEFAULT NULL,
  `bill_type` varchar(255) DEFAULT NULL,
  `tbem_invoice_date` date NOT NULL,
  `tbem_created_id` int(11) DEFAULT NULL,
  `tbem_modify_by` int(11) DEFAULT NULL,
  `tbem_delete_by` int(11) DEFAULT NULL,
  `tbem_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbem_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_opd_billing_estimate_service;

CREATE TABLE `tbl_opd_billing_estimate_service` (
  `tbes_id` int(11) NOT NULL AUTO_INCREMENT,
  `im_invoice_id` text NOT NULL,
  `tbms_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  `tbes_price` double(10,2) NOT NULL,
  `discount` int(11) NOT NULL DEFAULT '0',
  `tax_amount` int(11) NOT NULL DEFAULT '0',
  `tbes_qty` int(11) NOT NULL,
  `tbes_total` double(10,2) NOT NULL,
  `tbes_parent` int(11) NOT NULL DEFAULT '0',
  `tbes_status` int(11) DEFAULT '0',
  `tbem_id` int(21) NOT NULL DEFAULT '0',
  `hm_id` int(21) NOT NULL DEFAULT '0',
  `bill_id` int(21) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `tbes_delete_by` int(11) NOT NULL DEFAULT '0',
  `tbes_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_opd_billing_invoice_master;

CREATE TABLE `tbl_opd_billing_invoice_master` (
  `im_id` int(20) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `im_pid` text NOT NULL,
  `in_pid` text,
  `im_invoice_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `im_sub_total` double(10,2) NOT NULL,
  `im_rebate_type` varchar(250) NOT NULL,
  `im_rebate_amount` double(10,2) NOT NULL,
  `im_grand_total` double(10,2) NOT NULL,
  `im_notes` varchar(250) NOT NULL,
  `im_payment_status` int(11) NOT NULL,
  `im_parent` int(11) DEFAULT '0',
  `im_status` int(11) NOT NULL DEFAULT '0',
  `im_accountant` int(11) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `im_taxtion` varchar(255) NOT NULL,
  `im_total_cgst` double(10,2) NOT NULL,
  `im_total_sgst` double(10,2) NOT NULL,
  `im_total_net_tax_amt` double(10,2) NOT NULL,
  `im_total_gross` double(10,2) NOT NULL,
  `im_total_discount` double(10,2) NOT NULL,
  `im_invoice_date` date NOT NULL,
  `im_created_id` int(11) DEFAULT NULL,
  `im_modify_by` int(11) DEFAULT '0',
  `im_delete_by` int(11) DEFAULT '0',
  `im_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `im_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`im_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_opd_billing_invoice_service;

CREATE TABLE `tbl_opd_billing_invoice_service` (
  `is_id` int(11) NOT NULL AUTO_INCREMENT,
  `im_invoice_id` text NOT NULL,
  `tbms_id` int(11) NOT NULL DEFAULT '0',
  `service_id` int(11) NOT NULL DEFAULT '0',
  `ims_price` double(10,2) NOT NULL,
  `discount` int(11) NOT NULL DEFAULT '0',
  `tax_amount` int(11) NOT NULL DEFAULT '0',
  `ims_qty` int(11) NOT NULL DEFAULT '0',
  `ims_total` double(10,2) NOT NULL,
  `is_parent` int(11) NOT NULL DEFAULT '0',
  `is_status` int(11) NOT NULL DEFAULT '0',
  `ims_sgroup` int(11) NOT NULL DEFAULT '0',
  `im_id` int(21) NOT NULL DEFAULT '0',
  `hm_id` int(21) NOT NULL DEFAULT '0',
  `bill_id` int(21) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `is_cgst_per` double(10,2) NOT NULL,
  `is_sgst_per` double(10,2) NOT NULL,
  `is_cgst` double(10,2) NOT NULL,
  `is_sgst` double(10,2) NOT NULL,
  `is_tax_amt` double(10,2) NOT NULL,
  `im_ser_description` varchar(2000) DEFAULT NULL,
  `im_services_date` date DEFAULT NULL,
  `is_delete_by` varchar(255) DEFAULT NULL,
  `ims_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`is_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_opd_billing_receipt_master;

CREATE TABLE `tbl_opd_billing_receipt_master` (
  `rm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `rm_receipt_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `im_invoice_id` text NOT NULL,
  `rm_pid` text NOT NULL,
  `in_pid` text,
  `rm_total` double NOT NULL,
  `rm_given_amount` double NOT NULL,
  `rm_pending_amount` double NOT NULL,
  `rm_date` date NOT NULL,
  `rm_parent` int(11) DEFAULT NULL,
  `rm_status` int(11) NOT NULL DEFAULT '0',
  `payment_option` int(11) NOT NULL DEFAULT '0',
  `pay_ref_no` varchar(255) DEFAULT NULL,
  `bill_type` varchar(255) DEFAULT NULL,
  `rm_created_id` int(11) DEFAULT NULL,
  `rm_modify_id` int(11) DEFAULT NULL,
  `rm_delete_id` int(11) DEFAULT NULL,
  `rm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_opd_billing_refund_master;

CREATE TABLE `tbl_opd_billing_refund_master` (
  `tbrm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `tbrm_receipt_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `im_invoice_id` text NOT NULL,
  `tbrm_pid` text NOT NULL,
  `in_pid` text,
  `tbrm_total` double NOT NULL,
  `tbrm_given_amount` double NOT NULL,
  `tbrm_pending_amount` double NOT NULL,
  `tbrm_advance_id` int(11) DEFAULT NULL,
  `tbrm_date` date NOT NULL,
  `tbrm_parent` int(11) DEFAULT NULL,
  `tbrm_status` int(11) NOT NULL DEFAULT '0',
  `bill_type` varchar(255) DEFAULT NULL,
  `tbrm_advance_id_new` varchar(255) DEFAULT NULL,
  `im_invoice_type` varchar(255) DEFAULT NULL,
  `payment_option` int(11) NOT NULL DEFAULT '0',
  `pay_ref_no` varchar(255) DEFAULT NULL,
  `tbrm_created_id` int(11) DEFAULT NULL,
  `tbrm_modify_id` int(11) DEFAULT '0',
  `tbrm_delete_id` int(11) DEFAULT '0',
  `tbrm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tbrm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tbrm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_opd_case_type;

CREATE TABLE `tbl_opd_case_type` (
  `toct_id` int(11) NOT NULL AUTO_INCREMENT,
  `toct_type` varchar(250) NOT NULL,
  `toct_default` int(11) NOT NULL DEFAULT '0',
  `toct_del` int(11) NOT NULL DEFAULT '0',
  `toct_created_by` int(11) NOT NULL,
  `toct_modify_by` int(11) NOT NULL DEFAULT '0',
  `toct_delete_by` int(11) NOT NULL DEFAULT '0',
  `toct_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `toct_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`toct_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO tbl_opd_case_type VALUES("1","New","0","0","0","0","0","2018-11-21 09:31:45","2018-11-21 09:56:56");
INSERT INTO tbl_opd_case_type VALUES("2","Follow-up","0","0","0","0","0","2018-11-21 09:39:34","2018-11-21 09:55:19");
INSERT INTO tbl_opd_case_type VALUES("3","Urgent","0","0","0","0","0","2018-11-21 09:39:52","2018-11-21 09:44:38");



DROP TABLE tbl_ophtho_case_manager;

CREATE TABLE `tbl_ophtho_case_manager` (
  `tocm_id` bigint(21) NOT NULL AUTO_INCREMENT,
  `tcm_id` bigint(21) NOT NULL,
  `pm_id` bigint(21) NOT NULL,
  `pm_pid` varchar(500) NOT NULL,
  `tcm_sph_re_dis_type` varchar(50) DEFAULT NULL,
  `tcm_sph_re_dis_value` varchar(50) DEFAULT NULL,
  `tcm_cyl_re_dis_type` varchar(50) DEFAULT NULL,
  `tcm_cyl_re_dis_value` varchar(50) DEFAULT NULL,
  `tcm_axi_re_dis` varchar(500) DEFAULT NULL,
  `tcm_pri_re_dis_type` varchar(50) DEFAULT NULL,
  `tcm_pri_re_dis_value` varchar(50) DEFAULT NULL,
  `tcm_base_re_dis` varchar(500) DEFAULT NULL,
  `tcm_add_re_dis_type` varchar(50) DEFAULT NULL,
  `tcm_add_re_dis_value` varchar(50) DEFAULT NULL,
  `tcm_cv_re_dis` varchar(500) DEFAULT NULL,
  `tcm_sph_le_dis_type` varchar(50) DEFAULT NULL,
  `tcm_sph_le_dis_value` varchar(50) DEFAULT NULL,
  `tcm_cyl_le_dis_type` varchar(50) DEFAULT NULL,
  `tcm_cyl_le_dis_value` varchar(50) DEFAULT NULL,
  `tcm_axi_le_dis` varchar(500) DEFAULT NULL,
  `tcm_pri_le_dis_type` varchar(50) DEFAULT NULL,
  `tcm_pri_le_dis_value` varchar(50) DEFAULT NULL,
  `tcm_base_le_dis` varchar(500) DEFAULT NULL,
  `tcm_add_le_dis_type` varchar(50) DEFAULT NULL,
  `tcm_add_le_dis_value` varchar(50) DEFAULT NULL,
  `tcm_cv_le_dis` varchar(500) DEFAULT NULL,
  `tcm_sph_re_near_type` varchar(50) DEFAULT NULL,
  `tcm_sph_re_near_value` varchar(50) DEFAULT NULL,
  `tcm_cyl_re_near_type` varchar(50) DEFAULT NULL,
  `tcm_cyl_re_near_value` varchar(50) DEFAULT NULL,
  `tcm_axi_re_near` varchar(500) DEFAULT NULL,
  `tcm_pri_re_near_type` varchar(50) DEFAULT NULL,
  `tcm_pri_re_near_value` varchar(50) DEFAULT NULL,
  `tcm_base_re_near` varchar(500) DEFAULT NULL,
  `tcm_add_re_near_type` varchar(50) DEFAULT NULL,
  `tcm_add_re_near_value` varchar(50) DEFAULT NULL,
  `tcm_cv_re_near` varchar(500) DEFAULT NULL,
  `tcm_sph_le_near_type` varchar(50) DEFAULT NULL,
  `tcm_sph_le_near_value` varchar(50) DEFAULT NULL,
  `tcm_cyl_le_near_type` varchar(50) DEFAULT NULL,
  `tcm_cyl_le_near_value` varchar(50) DEFAULT NULL,
  `tcm_axi_le_near` varchar(500) DEFAULT NULL,
  `tcm_pri_le_near_type` varchar(50) DEFAULT NULL,
  `tcm_pri_le_near_value` varchar(50) DEFAULT NULL,
  `tcm_base_le_near` varchar(500) DEFAULT NULL,
  `tcm_add_le_near_type` varchar(50) DEFAULT NULL,
  `tcm_add_le_near_value` varchar(50) DEFAULT NULL,
  `tcm_cv_le_near` varchar(500) DEFAULT NULL,
  `tcm_tocm_pd` varchar(500) DEFAULT NULL,
  `tcm_tocm_remark` text,
  `tcm_re_lid_app` varchar(500) DEFAULT NULL,
  `tcm_re_con_scl` varchar(500) DEFAULT NULL,
  `tcm_re_comea` varchar(500) DEFAULT NULL,
  `tcm_re_ane_cha` varchar(500) DEFAULT NULL,
  `tcm_re_iris_pup` varchar(500) DEFAULT NULL,
  `tcm_re_lens` varchar(500) DEFAULT NULL,
  `tcm_re_after_dil` varchar(500) DEFAULT NULL,
  `tcm_re_add_slit_lamp` varchar(500) DEFAULT NULL,
  `tcm_re_find` varchar(500) DEFAULT NULL,
  `tcm_re_flu_sta` varchar(500) DEFAULT NULL,
  `tcm_re_sch_test` varchar(500) DEFAULT NULL,
  `tcm_le_lid_app` varchar(500) DEFAULT NULL,
  `tcm_le_con_scl` varchar(500) DEFAULT NULL,
  `tcm_le_comea` varchar(500) DEFAULT NULL,
  `tcm_le_ane_cha` varchar(500) DEFAULT NULL,
  `tcm_le_iris_pup` varchar(500) DEFAULT NULL,
  `tcm_le_lens` varchar(500) DEFAULT NULL,
  `tcm_le_after_dil` varchar(500) DEFAULT NULL,
  `tcm_le_add_slit_lamp` varchar(500) DEFAULT NULL,
  `tcm_le_find` varchar(500) DEFAULT NULL,
  `tcm_le_flu_sta` varchar(500) DEFAULT NULL,
  `tcm_le_sch_test` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`tocm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_ot_plan_certificate;

CREATE TABLE `tbl_ot_plan_certificate` (
  `topc_id` int(11) NOT NULL AUTO_INCREMENT,
  `tpc_id` int(11) DEFAULT NULL,
  `ex_no` varchar(150) DEFAULT NULL,
  `surgery_no` varchar(150) DEFAULT NULL,
  `bed_rest` varchar(30) DEFAULT NULL,
  `remark` varchar(750) DEFAULT NULL,
  PRIMARY KEY (`topc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_advice_master;

CREATE TABLE `tbl_outpatient_advice_master` (
  `toam_id` int(11) NOT NULL AUTO_INCREMENT,
  `toam_hm_id` int(11) DEFAULT '0',
  `toam_um_id` int(11) DEFAULT '0',
  `toam_template_name` varchar(750) DEFAULT NULL,
  `toam_template_content` longtext,
  `toam_delete` int(11) DEFAULT '0',
  `toam_created_by` int(11) DEFAULT NULL,
  `toam_modify_by` int(11) DEFAULT NULL,
  `toam_delete_by` int(11) DEFAULT NULL,
  `toam_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `toam_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`toam_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_outpatient_advice_master VALUES("1","1","1","fever","nbgh","0","1","","","2019-01-03 13:39:30","");



DROP TABLE tbl_outpatient_assessment_notes_master;

CREATE TABLE `tbl_outpatient_assessment_notes_master` (
  `toanm_id` int(11) NOT NULL AUTO_INCREMENT,
  `toanm_hm_id` int(11) DEFAULT '0',
  `toanm_um_id` int(11) DEFAULT '0',
  `toanm_template_name` varchar(750) DEFAULT NULL,
  `toanm_template_content` longtext,
  `toanm_delete` int(11) DEFAULT '0',
  `toanm_created_by` int(11) DEFAULT NULL,
  `toanm_modify_by` int(11) DEFAULT NULL,
  `toanm_delete_by` int(11) DEFAULT NULL,
  `toanm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `toanm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`toanm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_chief_complain_master;

CREATE TABLE `tbl_outpatient_chief_complain_master` (
  `toccm_id` int(11) NOT NULL AUTO_INCREMENT,
  `toccm_hm_id` int(11) NOT NULL DEFAULT '0',
  `toccm_um_id` int(11) NOT NULL DEFAULT '0',
  `toccm_template_name` varchar(750) DEFAULT NULL,
  `toccm_template_content` longtext,
  `toccm_created_by` int(11) DEFAULT NULL,
  `toccm_modify_by` int(11) DEFAULT NULL,
  `toccm_delete_by` int(11) DEFAULT NULL,
  `toccm_delete` int(11) NOT NULL DEFAULT '0',
  `toccm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `toccm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`toccm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_diagnosis_master;

CREATE TABLE `tbl_outpatient_diagnosis_master` (
  `todm_id` int(11) NOT NULL AUTO_INCREMENT,
  `todm_hm_id` int(11) DEFAULT '0',
  `todm_um_id` int(11) DEFAULT '0',
  `todm_diagnosis` longtext,
  `todm_tmtd_id` int(11) DEFAULT NULL,
  `todm_toam_id` int(11) DEFAULT NULL,
  `todm_delete` int(11) DEFAULT '0',
  `todm_created_by` int(11) DEFAULT NULL,
  `todm_modify_by` int(11) DEFAULT NULL,
  `todm_delete_by` int(11) DEFAULT NULL,
  `todm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `todm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`todm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_examination_box_master;

CREATE TABLE `tbl_outpatient_examination_box_master` (
  `toebm_id` int(11) NOT NULL AUTO_INCREMENT,
  `toebm_hm_id` int(11) NOT NULL DEFAULT '0',
  `toebm_um_id` int(11) NOT NULL DEFAULT '0',
  `toebm_template_name` varchar(750) DEFAULT NULL,
  `toebm_template_content` blob,
  `toebm_created_by` int(11) DEFAULT NULL,
  `toebm_modify_by` int(11) DEFAULT NULL,
  `toebm_delete_by` int(11) DEFAULT NULL,
  `toebm_delete` int(11) NOT NULL DEFAULT '0',
  `toebm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `toebm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`toebm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_history_box_master;

CREATE TABLE `tbl_outpatient_history_box_master` (
  `tohbm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tohbm_hm_id` int(11) NOT NULL DEFAULT '0',
  `tohbm_um_id` int(11) NOT NULL DEFAULT '0',
  `tohbm_template_name` varchar(750) DEFAULT NULL,
  `tohbm_template_content` blob,
  `tohbm_created_by` int(11) DEFAULT NULL,
  `tohbm_modify_by` int(11) DEFAULT NULL,
  `tohbm_delete_by` int(11) DEFAULT NULL,
  `tohbm_delete` int(11) NOT NULL DEFAULT '0',
  `tohbm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tohbm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tohbm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_history_master;

CREATE TABLE `tbl_outpatient_history_master` (
  `tohm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tohm_hm_id` int(11) DEFAULT '0',
  `tohm_um_id` int(11) DEFAULT '0',
  `tohm_template_name` varchar(750) DEFAULT NULL,
  `tohm_template_content` longtext,
  `tohm_delete` int(11) DEFAULT '0',
  `tohm_created_by` int(11) DEFAULT NULL,
  `tohm_modify_by` int(11) DEFAULT NULL,
  `tohm_delete_by` int(11) DEFAULT NULL,
  `tohm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tohpm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tohm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_history_present_master;

CREATE TABLE `tbl_outpatient_history_present_master` (
  `tohpm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tohpm_hm_id` int(11) DEFAULT '0',
  `tohpm_um_id` int(11) DEFAULT '0',
  `tohpm_template_name` varchar(750) DEFAULT NULL,
  `tohpm_template_content` longtext,
  `tohpm_delete` int(11) DEFAULT '0',
  `tohpm_created_by` int(11) DEFAULT NULL,
  `tohpm_modify_by` int(11) DEFAULT NULL,
  `tohpm_delete_by` int(11) DEFAULT NULL,
  `tohpm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tohpm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tohpm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_investigation_master;

CREATE TABLE `tbl_outpatient_investigation_master` (
  `toim_id` int(11) NOT NULL AUTO_INCREMENT,
  `toim_hm_id` int(11) DEFAULT '0',
  `toim_um_id` int(11) DEFAULT '0',
  `toim_template_name` varchar(750) DEFAULT NULL,
  `toim_template_content` longtext,
  `toim_delete` int(11) DEFAULT '0',
  `toim_created_by` int(11) DEFAULT NULL,
  `toim_modify_by` int(11) DEFAULT NULL,
  `toim_delete_by` int(11) DEFAULT NULL,
  `toim_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `toim_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`toim_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_lab_parameter;

CREATE TABLE `tbl_outpatient_lab_parameter` (
  `tolp_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(200) DEFAULT NULL,
  `tolp_parameter_name` varchar(750) DEFAULT NULL,
  `tolp_del` int(11) NOT NULL DEFAULT '0',
  `tolp_created_by` int(11) NOT NULL DEFAULT '0',
  `tolp_modify_by` int(11) DEFAULT NULL,
  `tolp_delete_by` int(11) NOT NULL DEFAULT '0',
  `tolp_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tolp_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tolp_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_outpatient_lab_parameter VALUES("1","1","1","20190103001","CBC","0","1","","0","2019-01-03 13:34:59","");



DROP TABLE tbl_outpatient_lab_val;

CREATE TABLE `tbl_outpatient_lab_val` (
  `tolv_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `tolv_date` date DEFAULT NULL,
  `tolv_time` time DEFAULT NULL,
  `tolv_del` int(11) NOT NULL DEFAULT '0',
  `tolv_created_by` int(11) NOT NULL DEFAULT '0',
  `tolv_modify_by` int(11) DEFAULT NULL,
  `tolv_delete_by` int(11) NOT NULL DEFAULT '0',
  `tolv_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tolv_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tolv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_mental_status_master;

CREATE TABLE `tbl_outpatient_mental_status_master` (
  `tomsm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tomsm_hm_id` int(11) DEFAULT '0',
  `tomsm_um_id` int(11) DEFAULT '0',
  `tomsm_template_name` varbinary(750) DEFAULT NULL,
  `tomsm_template_content` longtext,
  `tomsm_delete` int(11) DEFAULT '0',
  `tomsm_created_by` int(11) DEFAULT NULL,
  `tomsm_modify_by` int(11) DEFAULT NULL,
  `tomsm_delete_by` int(11) DEFAULT NULL,
  `tomsm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tomsm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tomsm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_precipitating_master;

CREATE TABLE `tbl_outpatient_precipitating_master` (
  `topm_id` int(11) NOT NULL AUTO_INCREMENT,
  `topm_hm_id` int(11) DEFAULT '0',
  `topm_um_id` int(11) DEFAULT '0',
  `topm_template_name` varchar(750) CHARACTER SET utf8 DEFAULT NULL,
  `topm_template_content` longtext CHARACTER SET utf8,
  `topm_delete` int(11) DEFAULT '0',
  `topm_created_by` int(11) DEFAULT NULL,
  `topm_modify_by` int(11) DEFAULT NULL,
  `topm_delete_by` int(11) DEFAULT NULL,
  `topm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `topm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`topm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_psychiatric_assessment_master;

CREATE TABLE `tbl_outpatient_psychiatric_assessment_master` (
  `topam_id` int(11) NOT NULL AUTO_INCREMENT,
  `topam_hm_id` int(11) DEFAULT '0',
  `topam_um_id` int(11) DEFAULT '0',
  `topam_template_name` varchar(750) DEFAULT NULL,
  `topam_template_content` longtext,
  `topam_delete` int(11) DEFAULT '0',
  `topam_created_by` int(11) DEFAULT NULL,
  `topam_modify_by` int(11) DEFAULT NULL,
  `topam_delete_by` int(11) DEFAULT NULL,
  `topam_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `topam_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`topam_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatient_treatment_master;

CREATE TABLE `tbl_outpatient_treatment_master` (
  `totm_id` int(11) NOT NULL AUTO_INCREMENT,
  `totm_hm_id` int(11) DEFAULT '0',
  `totm_um_id` int(11) DEFAULT '0',
  `totm_template_name` varchar(250) DEFAULT NULL,
  `totm_delete` int(11) DEFAULT '0',
  `totm_template_content` text,
  `totm_created_by` int(11) DEFAULT NULL,
  `totm_modify_by` int(11) DEFAULT NULL,
  `totm_delete_by` int(11) DEFAULT NULL,
  `totm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `totm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`totm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_outpatinet_lab_para_value;

CREATE TABLE `tbl_outpatinet_lab_para_value` (
  `tolpv_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `tolp_id` int(11) NOT NULL DEFAULT '0',
  `tolv_id` int(11) NOT NULL DEFAULT '0',
  `tolpv_value` varchar(750) DEFAULT NULL,
  `tolpv_del` int(11) NOT NULL DEFAULT '0',
  `tolpv_created_by` int(11) NOT NULL DEFAULT '0',
  `tolpv_modify_by` int(11) DEFAULT NULL,
  `tolpv_delete_by` int(11) NOT NULL DEFAULT '0',
  `tolpv_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tolpv_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tolpv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_patient_certificate;

CREATE TABLE `tbl_patient_certificate` (
  `tpc_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `pm_pid` varchar(350) DEFAULT NULL,
  `pm_id` int(11) DEFAULT NULL,
  `certy_type` varchar(120) DEFAULT NULL,
  `certy_no` varchar(150) DEFAULT NULL,
  `tpc_del` int(11) DEFAULT NULL,
  `tpc_created_by` int(11) DEFAULT NULL,
  `tpc_modify_by` int(11) DEFAULT NULL,
  `tpc_delete_by` int(11) DEFAULT NULL,
  `tpc_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpc_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_patient_demo_master;

CREATE TABLE `tbl_patient_demo_master` (
  `pm_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_pid` varchar(150) DEFAULT NULL,
  `pm_ref_id` varchar(150) DEFAULT NULL,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `rm_id` int(11) NOT NULL DEFAULT '0',
  `pm_rm_name` varchar(150) DEFAULT NULL,
  `other_ref` int(11) NOT NULL DEFAULT '0',
  `pc_id` int(11) NOT NULL DEFAULT '0',
  `pm_salutation` varchar(50) DEFAULT NULL,
  `pm_first_name` varchar(150) DEFAULT NULL,
  `pm_middle_name` varchar(150) DEFAULT NULL,
  `pm_last_name` varchar(150) DEFAULT NULL,
  `pm_gender` varchar(30) DEFAULT NULL,
  `pm_dob` date NOT NULL,
  `pm_contact_no` varchar(150) DEFAULT NULL,
  `pm_email` varchar(150) DEFAULT NULL,
  `pm_address` varchar(150) DEFAULT NULL,
  `pm_pincode` varchar(50) DEFAULT NULL,
  `pm_area` varchar(70) DEFAULT NULL,
  `pm_city` varchar(50) DEFAULT NULL,
  `pm_district` varchar(70) DEFAULT NULL,
  `pm_state` varchar(50) DEFAULT NULL,
  `pm_country` varchar(50) DEFAULT NULL,
  `pm_blood_group` varchar(30) DEFAULT NULL,
  `pm_mediclaim` varchar(20) DEFAULT NULL,
  `pm_remarks` varchar(350) DEFAULT NULL,
  `pm_reception_remark` varchar(1000) DEFAULT NULL,
  `pm_doctor_remark` varchar(1000) DEFAULT NULL,
  `pm_second_name` varchar(150) DEFAULT NULL,
  `pm_contact_no2` varchar(50) DEFAULT NULL,
  `pm_relation` varchar(50) DEFAULT NULL,
  `pm_appointment_date` date DEFAULT NULL,
  `pm_appointment_time` time DEFAULT NULL,
  `pm_appointment_type` varchar(30) DEFAULT NULL,
  `pm_case_type` varchar(30) DEFAULT NULL,
  `pm_del` int(11) NOT NULL DEFAULT '0',
  `pm_created_by` int(11) NOT NULL DEFAULT '0',
  `pm_modify_by` int(11) DEFAULT NULL,
  `pm_delete_by` int(11) DEFAULT NULL,
  `pm_dnd` int(11) NOT NULL DEFAULT '0',
  `pm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`pm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_patient_followup;

CREATE TABLE `tbl_patient_followup` (
  `tpf_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `um_id` int(11) NOT NULL,
  `pm_pid` varchar(350) NOT NULL,
  `tcm_id` int(11) NOT NULL,
  `tpf_date` date NOT NULL,
  `tpf_advice` longtext,
  `tpf_del` int(11) NOT NULL DEFAULT '0',
  `tpf_created_by` int(11) NOT NULL,
  `tpf_modify_by` int(11) NOT NULL DEFAULT '0',
  `tpf_delete_by` int(11) NOT NULL DEFAULT '0',
  `tpf_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpf_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpf_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO tbl_patient_followup VALUES("1","1","1","20190103001","1","2019-01-08","","0","1","0","0","2019-01-03 13:43:06","");



DROP TABLE tbl_patient_insurance;

CREATE TABLE `tbl_patient_insurance` (
  `tpi_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) DEFAULT NULL,
  `pm_pid` varchar(350) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `title` varchar(150) DEFAULT NULL,
  `policy_number` varchar(250) DEFAULT NULL,
  `tpa_number` varchar(250) DEFAULT NULL,
  `tpi_del` int(11) DEFAULT NULL,
  `tpi_created_by` int(11) DEFAULT NULL,
  `tpi_modify_by` int(11) DEFAULT NULL,
  `tpi_delete_by` int(11) DEFAULT NULL,
  `tpi_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpi_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_patient_master;

CREATE TABLE `tbl_patient_master` (
  `pm_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_pid` varchar(150) DEFAULT NULL,
  `seq_no` bigint(20) NOT NULL,
  `pm_ref_id` varchar(150) DEFAULT NULL,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL DEFAULT '0',
  `rm_id` int(11) NOT NULL DEFAULT '0',
  `pm_rm_name` varchar(150) DEFAULT NULL,
  `other_ref` int(11) NOT NULL DEFAULT '0',
  `pc_id` int(11) NOT NULL DEFAULT '0',
  `pm_salutation` varchar(50) DEFAULT NULL,
  `pm_first_name` varchar(150) DEFAULT NULL,
  `pm_middle_name` varchar(150) DEFAULT NULL,
  `pm_last_name` varchar(150) DEFAULT NULL,
  `pm_gender` varchar(30) DEFAULT NULL,
  `pm_dob` date NOT NULL,
  `pm_contact_no` varchar(150) DEFAULT NULL,
  `pm_email` varchar(150) DEFAULT NULL,
  `pm_address` varchar(150) DEFAULT NULL,
  `pm_pincode` varchar(50) DEFAULT NULL,
  `pm_area` varchar(70) DEFAULT NULL,
  `pm_city` varchar(50) DEFAULT NULL,
  `pm_district` varchar(70) DEFAULT NULL,
  `pm_state` varchar(50) DEFAULT NULL,
  `pm_country` varchar(50) DEFAULT NULL,
  `pm_blood_group` varchar(30) DEFAULT NULL,
  `pm_mediclaim` varchar(20) DEFAULT NULL,
  `pm_remarks` varchar(350) DEFAULT NULL,
  `pm_reception_remark` varchar(1000) DEFAULT NULL,
  `pm_doctor_remark` varchar(1000) DEFAULT NULL,
  `pm_second_name` varchar(150) DEFAULT NULL,
  `pm_contact_no2` varchar(50) DEFAULT NULL,
  `pm_relation` varchar(50) DEFAULT NULL,
  `pm_appointment_date` date DEFAULT NULL,
  `pm_appointment_time` time DEFAULT NULL,
  `pm_appointment_type` varchar(30) DEFAULT NULL,
  `pm_case_type` varchar(30) DEFAULT NULL,
  `toct_id` int(11) NOT NULL DEFAULT '0',
  `pm_barcode_image` varchar(300) DEFAULT NULL,
  `pm_del` int(11) NOT NULL DEFAULT '0',
  `pm_created_by` int(11) NOT NULL DEFAULT '0',
  `pm_modify_by` int(11) DEFAULT NULL,
  `pm_delete_by` int(11) DEFAULT NULL,
  `pm_dnd` int(11) NOT NULL DEFAULT '0',
  `pm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`pm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tbl_patient_master VALUES("1","20190103001","20190103001","","1","1","0","","0","0","","Daksh","","Kulheri","Male","2013-01-03","9898784152","","","","","","","","","","","","","","","","","2019-01-03","13:26:00","Walk","New","1","barcode_20190103001.png","0","1","","","0","2019-01-03 13:28:38","2019-04-22 10:35:37");
INSERT INTO tbl_patient_master VALUES("2","20190122001","20190122001","","1","1","0","","0","0","","Ishakvi","","Chauhan","Female","2018-01-10","9898784152","","","","","","","","","","","","","","","","","2019-01-22","12:15:00","Walk","New","1","barcode_20190122001.png","0","1","","","0","2019-01-22 12:28:03","2019-04-22 10:35:37");



DROP TABLE tbl_patient_permanent_history;

CREATE TABLE `tbl_patient_permanent_history` (
  `tpph_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(250) DEFAULT NULL,
  `tpph_history` blob,
  `tpph_del` int(11) NOT NULL DEFAULT '0',
  `tpph_created_by` int(11) NOT NULL DEFAULT '0',
  `tpph_modify_by` int(11) DEFAULT NULL,
  `tpph_delete_by` int(11) NOT NULL DEFAULT '0',
  `tpph_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpph_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpph_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO tbl_patient_permanent_history VALUES("5","1","20190103001","","0","1","","0","2019-01-03 13:43:06","");
INSERT INTO tbl_patient_permanent_history VALUES("6","2","20190122001","","0","1","","0","2019-01-22 12:32:22","");



DROP TABLE tbl_patient_private_notes;

CREATE TABLE `tbl_patient_private_notes` (
  `ppn_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) DEFAULT NULL,
  `pm_pid` varchar(250) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `notes` longtext,
  `ppn_del` int(11) DEFAULT NULL,
  `ppn_created_by` int(11) DEFAULT NULL,
  `ppn_modify_by` int(11) DEFAULT NULL,
  `ppn_delete_by` int(11) DEFAULT NULL,
  `ppn_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ppn_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ppn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_patient_type;

CREATE TABLE `tbl_patient_type` (
  `pt_id` int(11) NOT NULL AUTO_INCREMENT,
  `pt_name` varchar(70) DEFAULT NULL,
  `pt_del` int(11) DEFAULT '0',
  `pt_created_by` int(11) DEFAULT '0',
  `pt_modify_by` int(11) DEFAULT '0',
  `pt_delete_by` int(11) DEFAULT '0',
  `pt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`pt_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO tbl_patient_type VALUES("10","VIP","0","1","1","0","2018-02-28 17:46:22","2018-05-07 12:14:06");
INSERT INTO tbl_patient_type VALUES("11","VVIP","0","1","1","0","2018-02-28 17:46:51","2018-05-07 12:14:46");
INSERT INTO tbl_patient_type VALUES("12","Relative","0","1","1","0","2018-02-28 17:46:58","2018-05-07 12:14:52");
INSERT INTO tbl_patient_type VALUES("13","FOC","0","1","1","0","2018-03-01 17:16:13","2018-05-07 12:14:57");
INSERT INTO tbl_patient_type VALUES("14","Politician","0","1","0","0","2018-05-07 12:15:02","0000-00-00 00:00:00");
INSERT INTO tbl_patient_type VALUES("15","Police Officer","0","1","0","0","2018-05-07 12:15:11","0000-00-00 00:00:00");



DROP TABLE tbl_patient_visit_logs;

CREATE TABLE `tbl_patient_visit_logs` (
  `tpvl_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) DEFAULT NULL,
  `pam_id` int(11) DEFAULT NULL,
  `pm_id` int(11) DEFAULT NULL,
  `pm_pid` varchar(350) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `tpvl_created_by` int(11) DEFAULT NULL,
  `tpvl_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpvl_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO tbl_patient_visit_logs VALUES("1","1","1","1","20190103001","1","1","2019-01-03 13:28:39");
INSERT INTO tbl_patient_visit_logs VALUES("2","1","2","2","20190122001","1","1","2019-01-22 12:28:03");



DROP TABLE tbl_permanent_histroy_master;

CREATE TABLE `tbl_permanent_histroy_master` (
  `tphm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) DEFAULT '0',
  `um_id` int(11) DEFAULT '0',
  `tphm_template_name` varchar(750) DEFAULT NULL,
  `tphm_template_content` longtext,
  `tphm_del` int(11) DEFAULT '0',
  `tphm_created_by` int(11) DEFAULT NULL,
  `tphm_modify_by` int(11) DEFAULT NULL,
  `tphm_delete_by` int(11) DEFAULT NULL,
  `tphm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tphm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tphm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_medicine;

CREATE TABLE `tbl_pha_medicine` (
  `tpm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL DEFAULT '0',
  `pharma_id` int(11) NOT NULL DEFAULT '0',
  `tpm_name` varchar(250) DEFAULT NULL,
  `tpmg_id` int(11) NOT NULL DEFAULT '0',
  `tpmc_id` int(11) NOT NULL DEFAULT '0',
  `tpmgn_id` int(11) NOT NULL DEFAULT '0',
  `tpm_qty` int(11) NOT NULL DEFAULT '0',
  `tpm_location` varchar(150) DEFAULT NULL,
  `tpm_reorder_reminder` int(11) NOT NULL DEFAULT '0',
  `tpm_expire_reminder` int(11) NOT NULL DEFAULT '0',
  `tpm_del` int(11) NOT NULL DEFAULT '0',
  `tpm_created_by` int(11) NOT NULL DEFAULT '0',
  `tpm_modify_by` int(11) DEFAULT NULL,
  `tpm_delete_by` int(11) NOT NULL DEFAULT '0',
  `tpm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_medicine_batch;

CREATE TABLE `tbl_pha_medicine_batch` (
  `tpmb_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL DEFAULT '0',
  `pharma_id` int(11) NOT NULL DEFAULT '0',
  `tpm_id` int(11) NOT NULL,
  `tpmb_name` varchar(250) DEFAULT NULL,
  `tpmb_exp_date` date DEFAULT NULL,
  `tpmb_mrp_cost` double(10,2) NOT NULL DEFAULT '0.00',
  `tpmb_single_unit_cost` double(10,2) NOT NULL DEFAULT '0.00',
  `tpmb_qty` int(11) NOT NULL DEFAULT '0',
  `tpmb_gst_rate` double(10,2) NOT NULL,
  `tpmb_gst_type` varchar(150) DEFAULT NULL,
  `tpmb_gst_amount` double(10,2) NOT NULL,
  `tpmb_del` int(11) NOT NULL DEFAULT '0',
  `tpmb_created_by` int(11) NOT NULL DEFAULT '0',
  `tpmb_modify_by` int(11) DEFAULT NULL,
  `tpmb_delete_by` int(11) NOT NULL DEFAULT '0',
  `tpmb_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpmb_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpmb_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_medicine_company;

CREATE TABLE `tbl_pha_medicine_company` (
  `tpmc_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL DEFAULT '3',
  `pharma_id` int(11) NOT NULL DEFAULT '13',
  `tpmc_name` varchar(250) DEFAULT NULL,
  `tpmc_del` int(11) NOT NULL DEFAULT '0',
  `tpmc_created_by` int(11) NOT NULL DEFAULT '0',
  `tpmc_modify_by` int(11) DEFAULT NULL,
  `tpmc_delete_by` int(11) NOT NULL DEFAULT '0',
  `tpmc_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpmc_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpmc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_medicine_expire_reminder;

CREATE TABLE `tbl_pha_medicine_expire_reminder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `days` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_medicine_generic;

CREATE TABLE `tbl_pha_medicine_generic` (
  `tpmgn_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL DEFAULT '0',
  `pharma_id` int(11) NOT NULL DEFAULT '0',
  `tpmgn_name` varchar(250) DEFAULT NULL,
  `tpmgn_del` int(11) NOT NULL DEFAULT '0',
  `tpmgn_created_by` int(11) NOT NULL DEFAULT '0',
  `tpmgn_modify_by` int(11) DEFAULT NULL,
  `tpmgn_delete_by` int(11) NOT NULL DEFAULT '0',
  `tpmgn_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpmgn_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpmgn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_medicine_group;

CREATE TABLE `tbl_pha_medicine_group` (
  `tpmg_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL,
  `pharma_id` int(11) NOT NULL,
  `tpmg_name` varchar(250) DEFAULT NULL,
  `tpmg_del` int(11) NOT NULL DEFAULT '0',
  `tpmg_created_by` int(11) NOT NULL DEFAULT '0',
  `tpmg_modify_by` int(11) DEFAULT NULL,
  `tpmg_delete_by` int(11) NOT NULL DEFAULT '0',
  `tpmg_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpmg_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpmg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_phy_stock_varify;

CREATE TABLE `tbl_pha_phy_stock_varify` (
  `tppsv_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL DEFAULT '0',
  `pharma_id` int(11) NOT NULL DEFAULT '0',
  `tppsv_created_by` int(11) NOT NULL DEFAULT '0',
  `tppsv_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`tppsv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_phy_stock_varify_qty;

CREATE TABLE `tbl_pha_phy_stock_varify_qty` (
  `tppsvq_id` int(11) NOT NULL AUTO_INCREMENT,
  `tppsv_id` int(11) NOT NULL DEFAULT '0',
  `hos_id` int(11) NOT NULL DEFAULT '0',
  `pharma_id` int(11) NOT NULL DEFAULT '0',
  `tpm_id` int(11) NOT NULL DEFAULT '0',
  `tpmb_id` int(11) NOT NULL DEFAULT '0',
  `qty_stystem` int(11) NOT NULL DEFAULT '0',
  `actual_qty` int(11) NOT NULL DEFAULT '0',
  `qty_less` int(11) NOT NULL DEFAULT '0',
  `reason` varchar(500) DEFAULT NULL,
  `tppsvq_created_by` int(11) NOT NULL DEFAULT '0',
  `tppsvq_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`tppsvq_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_purchase_invoice;

CREATE TABLE `tbl_pha_purchase_invoice` (
  `tppi_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL,
  `pharma_id` int(11) NOT NULL,
  `tppi_pid` varchar(250) DEFAULT NULL,
  `seq_no` bigint(20) NOT NULL,
  `tppi_ref_id` varchar(250) DEFAULT NULL,
  `ts_id` int(11) NOT NULL DEFAULT '0',
  `tppo_id` varchar(500) DEFAULT NULL,
  `tppi_sub_total` double(10,2) NOT NULL,
  `tppi_all_gst` varchar(25) NOT NULL,
  `tppi_gst_total` double(10,2) NOT NULL,
  `tppi_dis_total` double(10,2) NOT NULL,
  `tppi_text_total` double(10,2) NOT NULL,
  `tppi_main_total` double(10,2) NOT NULL,
  `tppi_rebate_type` varchar(15) DEFAULT NULL,
  `tppi_rebate_amount` double(10,2) DEFAULT NULL,
  `tppi_grand_total` double(10,2) NOT NULL,
  `tppi_invoice_date` date DEFAULT NULL,
  `tppi_del` int(11) NOT NULL DEFAULT '0',
  `tppi_created_by` int(11) NOT NULL DEFAULT '0',
  `tppi_modify_by` int(11) DEFAULT NULL,
  `tppi_delete_by` int(11) NOT NULL DEFAULT '0',
  `tppi_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tppi_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tppi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_purchase_invoice_qty;

CREATE TABLE `tbl_pha_purchase_invoice_qty` (
  `tppiq_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL,
  `pharma_id` int(11) NOT NULL,
  `tppi_id` int(11) NOT NULL,
  `tpm_id` int(11) NOT NULL,
  `tpmb_id` int(11) NOT NULL,
  `tppiq_exp_date` date DEFAULT NULL,
  `tppiq_pack` int(11) NOT NULL DEFAULT '0',
  `tppiq_free_pack` int(11) NOT NULL DEFAULT '0',
  `tppiq_hsn` varchar(250) DEFAULT NULL,
  `tppiq_itemperpack` int(11) NOT NULL DEFAULT '0',
  `tppiq_qty` int(11) NOT NULL DEFAULT '0',
  `tppiq_mrp_cost` double(10,2) NOT NULL DEFAULT '0.00',
  `tppiq_pur_cost` double(10,2) NOT NULL,
  `tppiq_single_unit_cost` double(10,2) NOT NULL,
  `tppiq_gst_rate` double(10,2) NOT NULL,
  `tppiq_gst_type` varchar(150) DEFAULT NULL,
  `tppiq_gst_amount` double(10,2) NOT NULL,
  `tppiq_dis_rate` double(10,2) NOT NULL,
  `tppiq_dis_type` varchar(150) DEFAULT NULL,
  `tppiq_dis_amount` double(10,2) NOT NULL,
  `tppiq_text_total` double(10,2) NOT NULL,
  `tppiq_total` double(10,2) NOT NULL,
  `tppiq_del` int(11) NOT NULL DEFAULT '0',
  `tppiq_created_by` int(11) NOT NULL DEFAULT '0',
  `tppiq_modify_by` int(11) NOT NULL DEFAULT '0',
  `tppiq_delete_by` int(11) NOT NULL DEFAULT '0',
  `tppiq_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tppiq_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tppiq_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_purchase_order;

CREATE TABLE `tbl_pha_purchase_order` (
  `tppo_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL,
  `pharma_id` int(11) NOT NULL,
  `ts_id` int(11) NOT NULL,
  `po_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `tppo_status` int(11) NOT NULL DEFAULT '0',
  `tppo_del` int(11) NOT NULL DEFAULT '0',
  `tppo_created_by` int(11) NOT NULL DEFAULT '0',
  `tppo_modify_by` int(11) DEFAULT NULL,
  `tppo_delete_by` int(11) NOT NULL DEFAULT '0',
  `tppo_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tppo_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tppo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_purchase_order_qty;

CREATE TABLE `tbl_pha_purchase_order_qty` (
  `tppoq_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL DEFAULT '0',
  `pharma_id` int(11) NOT NULL DEFAULT '0',
  `tppo_id` int(11) NOT NULL DEFAULT '0',
  `tpm_id` int(11) NOT NULL DEFAULT '0',
  `tppoq_qty` int(11) NOT NULL DEFAULT '0',
  `tppoq_status` int(11) NOT NULL DEFAULT '0',
  `tppoq_credit_qty` int(11) NOT NULL DEFAULT '0',
  `tppoq_del` int(11) NOT NULL DEFAULT '0',
  `tppoq_created_by` int(11) NOT NULL DEFAULT '0',
  `tppoq_modify_by` int(11) NOT NULL DEFAULT '0',
  `tppoq_delete_by` int(11) NOT NULL DEFAULT '0',
  `tppoq_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tppoq_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tppoq_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_purchase_return;

CREATE TABLE `tbl_pha_purchase_return` (
  `tppr_id` int(11) NOT NULL AUTO_INCREMENT,
  `tppr_pid` varchar(250) NOT NULL,
  `hos_id` int(11) NOT NULL,
  `pharma_id` int(11) NOT NULL,
  `ts_id` int(11) NOT NULL,
  `tppr_del` int(11) NOT NULL DEFAULT '0',
  `tppr_created_by` int(11) NOT NULL DEFAULT '0',
  `tppr_modify_by` int(11) DEFAULT NULL,
  `tppr_delete_by` int(11) NOT NULL DEFAULT '0',
  `tppr_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tppr_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tppr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_purchase_return_qty;

CREATE TABLE `tbl_pha_purchase_return_qty` (
  `tpprq_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL DEFAULT '0',
  `pharma_id` int(11) NOT NULL DEFAULT '0',
  `tppr_id` int(11) NOT NULL DEFAULT '0',
  `tppi_id` int(11) NOT NULL DEFAULT '0',
  `tppiq_id` int(11) NOT NULL DEFAULT '0',
  `tpprq_total_qty` int(11) NOT NULL DEFAULT '0',
  `tpprq_return_qty` int(11) NOT NULL DEFAULT '0',
  `tppoq_del` int(11) NOT NULL DEFAULT '0',
  `tppoq_created_by` int(11) NOT NULL DEFAULT '0',
  `tppoq_modify_by` int(11) NOT NULL DEFAULT '0',
  `tppoq_delete_by` int(11) NOT NULL DEFAULT '0',
  `tppoq_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tppoq_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpprq_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_sales_invoice;

CREATE TABLE `tbl_pha_sales_invoice` (
  `tpsi_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL,
  `pharma_id` int(11) NOT NULL,
  `tpsi_pid` varchar(250) NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `ts_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` text NOT NULL,
  `in_pid` text,
  `patient_type` text NOT NULL,
  `tpsi_date` date NOT NULL,
  `doctor_name` varchar(150) DEFAULT NULL,
  `tpsi_all_gst` varchar(25) DEFAULT NULL,
  `tpsi_sub_total` double(10,2) NOT NULL,
  `tpsi_gst_total` double(10,2) NOT NULL,
  `tpsi_sgst_total` double(10,2) NOT NULL,
  `tpsi_dis_total` double(10,2) NOT NULL,
  `tpsi_text_total` double(10,2) NOT NULL,
  `tpsi_main_total` double(10,2) NOT NULL,
  `tpsi_rebate_type` varchar(15) NOT NULL,
  `tpsi_rebate_amount` double(10,2) NOT NULL,
  `tpsi_grand_total` double(10,2) NOT NULL,
  `tpsi_del` int(11) NOT NULL DEFAULT '0',
  `tpsi_created_by` int(11) NOT NULL DEFAULT '0',
  `tpsi_modify_by` int(11) NOT NULL DEFAULT '0',
  `tpsi_delete_by` int(11) NOT NULL DEFAULT '0',
  `tpsi_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpsi_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpsi_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_sales_invoice_qty;

CREATE TABLE `tbl_pha_sales_invoice_qty` (
  `tpsiq_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL,
  `pharma_id` int(11) NOT NULL,
  `tpsi_id` int(11) NOT NULL,
  `tpm_id` int(11) NOT NULL,
  `tpmb_id` int(11) NOT NULL,
  `tpsiq_exp_date` date DEFAULT NULL,
  `tpsiq_mrp_cost` double NOT NULL,
  `tpsiq_single_unit_cost` double NOT NULL,
  `tpsiq_qty` int(11) NOT NULL,
  `tpsiq_gst_rate` double NOT NULL,
  `tpsiq_gst_type` varchar(150) NOT NULL,
  `tpsiq_gst_amount` double NOT NULL,
  `tpsiq_sgst_rate` double(10,2) NOT NULL,
  `tpsiq_sgst_type` varchar(25) NOT NULL,
  `tpsiq_sgst_amount` double(10,2) NOT NULL,
  `tpsiq_tax_amt` double(10,2) NOT NULL,
  `tpsiq_dis_rate` double(10,2) NOT NULL,
  `tpsiq_dis_type` varchar(150) NOT NULL,
  `tpsiq_dis_amount` double NOT NULL,
  `tpsiq_text_total` double(10,2) NOT NULL,
  `tpsiq_total` double NOT NULL,
  `tpsiq_del` int(11) NOT NULL DEFAULT '0',
  `tpsiq_created_by` int(11) NOT NULL,
  `tpsiq_modify_by` int(11) NOT NULL DEFAULT '0',
  `tpsiq_delete_by` int(11) NOT NULL DEFAULT '0',
  `tpsiq_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpsiq_modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`tpsiq_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_sales_return;

CREATE TABLE `tbl_pha_sales_return` (
  `tpsr_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL,
  `pharma_id` int(11) NOT NULL,
  `tpsi_pid` varchar(250) NOT NULL,
  `tpsr_main_id` varchar(250) NOT NULL,
  `tpsr_pid` varchar(250) NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `ts_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` text NOT NULL,
  `in_pid` text NOT NULL,
  `patient_type` text NOT NULL,
  `tpsr_date` date NOT NULL,
  `tpsr_all_gst` varchar(25) NOT NULL,
  `tpsr_sub_total` double(10,2) NOT NULL,
  `tpsr_gst_total` double(10,2) NOT NULL,
  `tpsr_sgst_total` double(10,2) NOT NULL,
  `tpsr_dis_total` double(10,2) NOT NULL,
  `tpsr_text_total` double(10,2) NOT NULL,
  `tpsr_main_total` double(10,2) NOT NULL,
  `tpsr_rebate_type` varchar(15) NOT NULL,
  `tpsr_rebate_amount` double(10,2) NOT NULL,
  `tpsr_grand_total` double(10,2) NOT NULL,
  `tpsr_del` int(11) NOT NULL DEFAULT '0',
  `tpsr_created_by` int(11) NOT NULL DEFAULT '0',
  `tpsr_modify_by` int(11) NOT NULL DEFAULT '0',
  `tpsr_delete_by` int(11) NOT NULL DEFAULT '0',
  `tpsr_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpsr_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpsr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pha_sales_return_qty;

CREATE TABLE `tbl_pha_sales_return_qty` (
  `tpsrq_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL,
  `pharma_id` int(11) NOT NULL,
  `tpsr_id` int(11) NOT NULL,
  `tpm_id` int(11) NOT NULL,
  `tpmb_id` int(11) NOT NULL,
  `tpsrq_exp_date` date DEFAULT NULL,
  `tpsrq_mrp_cost` double NOT NULL,
  `tpsrq_single_unit_cost` double NOT NULL,
  `tpsrq_qty` int(11) NOT NULL,
  `tpsrq_gst_rate` double NOT NULL,
  `tpsrq_gst_type` varchar(150) NOT NULL,
  `tpsrq_gst_amount` double NOT NULL,
  `tpsrq_sgst_rate` double(10,2) NOT NULL,
  `tpsrq_sgst_type` varchar(25) NOT NULL,
  `tpsrq_sgst_amount` double(10,2) NOT NULL,
  `tpsrq_tax_amt` double(10,2) NOT NULL,
  `tpsrq_dis_rate` double(10,2) NOT NULL,
  `tpsrq_dis_type` varchar(150) NOT NULL,
  `tpsrq_dis_amount` double NOT NULL,
  `tpsrq_text_total` double(10,2) NOT NULL,
  `tpsrq_total` double NOT NULL,
  `tpsrq_del` int(11) NOT NULL DEFAULT '0',
  `tpsrq_created_by` int(11) NOT NULL,
  `tpsrq_modify_by` int(11) NOT NULL DEFAULT '0',
  `tpsrq_delete_by` int(11) NOT NULL DEFAULT '0',
  `tpsrq_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tpsrq_modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`tpsrq_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_pharmacy;

CREATE TABLE `tbl_pharmacy` (
  `pharma_id` int(11) NOT NULL AUTO_INCREMENT,
  `pharma_name` varchar(250) NOT NULL,
  `hm_id` int(11) NOT NULL,
  `pharma_mm_id` int(11) NOT NULL,
  `pharma_contact` varchar(150) NOT NULL,
  `pharma_address` varchar(350) NOT NULL,
  `pharma_area` varchar(150) NOT NULL,
  `pharma_city` varchar(150) NOT NULL,
  `pharma_state` varchar(150) NOT NULL,
  `pharma_pincode` varchar(35) NOT NULL,
  `pharma_dlno` varchar(350) NOT NULL,
  `pharma_gstno` varchar(350) NOT NULL,
  `pharma_cgstno` varchar(350) NOT NULL,
  `pharma_del` int(11) NOT NULL DEFAULT '0',
  `pharma_create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pharma_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `pharma_created_by` int(11) NOT NULL DEFAULT '0',
  `pharma_modify_by` int(11) NOT NULL DEFAULT '0',
  `pharma_deleted_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pharma_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_print_header_body;

CREATE TABLE `tbl_print_header_body` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `print_type` int(11) NOT NULL DEFAULT '0',
  `print_page_type` varchar(255) DEFAULT NULL,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `del` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=latin1;

INSERT INTO tbl_print_header_body VALUES("1","2","out_patient_registration_casesheet_casefile","1","Patient ID","0");
INSERT INTO tbl_print_header_body VALUES("2","2","out_patient_registration_casesheet_casefile","1","Name","0");
INSERT INTO tbl_print_header_body VALUES("3","2","out_patient_registration_casesheet_casefile","1","Dob","0");
INSERT INTO tbl_print_header_body VALUES("4","2","out_patient_registration_casesheet_casefile","1","Age","0");
INSERT INTO tbl_print_header_body VALUES("5","2","out_patient_registration_casesheet_casefile","1","Gender","0");
INSERT INTO tbl_print_header_body VALUES("6","2","out_patient_registration_casesheet_casefile","1","Date","0");
INSERT INTO tbl_print_header_body VALUES("13","2","out_patient_prescription","1","Name","0");
INSERT INTO tbl_print_header_body VALUES("14","2","out_patient_prescription","1","Patient ID","0");
INSERT INTO tbl_print_header_body VALUES("16","2","out_patient_prescription","1","Age/Gender","0");
INSERT INTO tbl_print_header_body VALUES("18","1","dis_summary","1","Name","0");
INSERT INTO tbl_print_header_body VALUES("19","1","dis_summary","1","Patient ID","0");
INSERT INTO tbl_print_header_body VALUES("20","1","dis_summary","1","Inpatient ID","0");
INSERT INTO tbl_print_header_body VALUES("21","1","dis_summary","1","Age/Gender","0");
INSERT INTO tbl_print_header_body VALUES("22","1","dis_summary","1","Ward","0");
INSERT INTO tbl_print_header_body VALUES("23","1","dis_summary","1","Room/Bed","0");
INSERT INTO tbl_print_header_body VALUES("24","1","dis_summary","1","Department","0");
INSERT INTO tbl_print_header_body VALUES("25","1","dis_summary","1","Admission Date","0");
INSERT INTO tbl_print_header_body VALUES("26","1","dis_summary","1","Discharge Date","0");
INSERT INTO tbl_print_header_body VALUES("27","2","out_patient_registration_casesheet_casefile","2","Patient ID","0");
INSERT INTO tbl_print_header_body VALUES("28","2","out_patient_registration_casesheet_casefile","2","Name","0");
INSERT INTO tbl_print_header_body VALUES("29","2","out_patient_registration_casesheet_casefile","2","Dob","0");
INSERT INTO tbl_print_header_body VALUES("30","2","out_patient_registration_casesheet_casefile","2","Age","0");
INSERT INTO tbl_print_header_body VALUES("31","2","out_patient_registration_casesheet_casefile","2","Gender","0");
INSERT INTO tbl_print_header_body VALUES("32","2","out_patient_registration_casesheet_casefile","2","Date","0");
INSERT INTO tbl_print_header_body VALUES("33","2","out_patient_prescription","2","Name","0");
INSERT INTO tbl_print_header_body VALUES("34","2","out_patient_prescription","2","Patient ID","0");
INSERT INTO tbl_print_header_body VALUES("35","2","out_patient_prescription","2","Age/Gender","0");
INSERT INTO tbl_print_header_body VALUES("37","1","dis_summary","2","Name","0");
INSERT INTO tbl_print_header_body VALUES("38","1","dis_summary","2","Patient ID","0");
INSERT INTO tbl_print_header_body VALUES("39","1","dis_summary","2","Inpatient ID","0");
INSERT INTO tbl_print_header_body VALUES("40","1","dis_summary","2","Age/Gender","0");
INSERT INTO tbl_print_header_body VALUES("41","1","dis_summary","2","Ward","0");
INSERT INTO tbl_print_header_body VALUES("42","1","dis_summary","2","Room/Bed","0");
INSERT INTO tbl_print_header_body VALUES("43","1","dis_summary","2","Department","0");
INSERT INTO tbl_print_header_body VALUES("44","1","dis_summary","2","Admission Date","0");
INSERT INTO tbl_print_header_body VALUES("45","1","dis_summary","2","Discharge Date","0");
INSERT INTO tbl_print_header_body VALUES("46","2","out_patient_registration_casesheet_casefile","1","Email","0");
INSERT INTO tbl_print_header_body VALUES("47","2","out_patient_registration_casesheet_casefile","2","Email","0");
INSERT INTO tbl_print_header_body VALUES("48","2","out_patient_registration_casesheet_casefile","1","Secondary Name","0");
INSERT INTO tbl_print_header_body VALUES("49","2","out_patient_registration_casesheet_casefile","2","Secondary Name","0");
INSERT INTO tbl_print_header_body VALUES("50","2","out_patient_registration_casesheet_casefile","1","Secondary Contact","0");
INSERT INTO tbl_print_header_body VALUES("51","2","out_patient_registration_casesheet_casefile","2","Secondary Contact","0");
INSERT INTO tbl_print_header_body VALUES("52","2","out_patient_registration_casesheet_casefile","1","Address","0");
INSERT INTO tbl_print_header_body VALUES("53","2","out_patient_registration_casesheet_casefile","2","Address","0");
INSERT INTO tbl_print_header_body VALUES("54","2","out_patient_prescription","1","Email","0");
INSERT INTO tbl_print_header_body VALUES("55","2","out_patient_prescription","2","Email","0");
INSERT INTO tbl_print_header_body VALUES("56","2","out_patient_prescription","1","Secondary Name","0");
INSERT INTO tbl_print_header_body VALUES("57","2","out_patient_prescription","2","Secondary Name","0");
INSERT INTO tbl_print_header_body VALUES("58","2","out_patient_prescription","1","Secondary Contact","0");
INSERT INTO tbl_print_header_body VALUES("59","2","out_patient_prescription","2","Secondary Contact","0");
INSERT INTO tbl_print_header_body VALUES("60","2","out_patient_prescription","1","Address","0");
INSERT INTO tbl_print_header_body VALUES("61","2","out_patient_prescription","2","Address","0");
INSERT INTO tbl_print_header_body VALUES("62","2","out_patient_prescription","1","Followup Date
","0");
INSERT INTO tbl_print_header_body VALUES("63","2","out_patient_prescription","2","Followup Date","0");
INSERT INTO tbl_print_header_body VALUES("64","1","dis_summary","1","MLC Number","0");
INSERT INTO tbl_print_header_body VALUES("65","1","dis_summary","2","MLC Number","0");
INSERT INTO tbl_print_header_body VALUES("66","1","indoo_registration_form_other_pages","2","Address","0");
INSERT INTO tbl_print_header_body VALUES("67","1","indoo_registration_form_other_pages","1","Address","0");
INSERT INTO tbl_print_header_body VALUES("68","1","indoo_registration_form_other_pages","2","Secondary Contact","0");
INSERT INTO tbl_print_header_body VALUES("69","1","indoo_registration_form_other_pages","1","Secondary Contact","0");
INSERT INTO tbl_print_header_body VALUES("70","1","indoo_registration_form_other_pages","2","Secondary Name","0");
INSERT INTO tbl_print_header_body VALUES("71","1","indoo_registration_form_other_pages","1","Secondary Name","0");
INSERT INTO tbl_print_header_body VALUES("72","1","indoo_registration_form_other_pages","2","Email","0");
INSERT INTO tbl_print_header_body VALUES("73","1","indoo_registration_form_other_pages","1","Email","0");
INSERT INTO tbl_print_header_body VALUES("74","1","indoo_registration_form_other_pages","2","Date","0");
INSERT INTO tbl_print_header_body VALUES("75","1","indoo_registration_form_other_pages","2","Gender","0");
INSERT INTO tbl_print_header_body VALUES("76","1","indoo_registration_form_other_pages","2","Age","0");
INSERT INTO tbl_print_header_body VALUES("77","1","indoo_registration_form_other_pages","2","Dob","0");
INSERT INTO tbl_print_header_body VALUES("78","1","indoo_registration_form_other_pages","2","Name","0");
INSERT INTO tbl_print_header_body VALUES("79","1","indoo_registration_form_other_pages","2","Patient ID","0");
INSERT INTO tbl_print_header_body VALUES("80","1","indoo_registration_form_other_pages","1","Date","0");
INSERT INTO tbl_print_header_body VALUES("81","1","indoo_registration_form_other_pages","1","Gender","0");
INSERT INTO tbl_print_header_body VALUES("82","1","indoo_registration_form_other_pages","1","Age","0");
INSERT INTO tbl_print_header_body VALUES("83","1","indoo_registration_form_other_pages","1","Dob","0");
INSERT INTO tbl_print_header_body VALUES("84","1","indoo_registration_form_other_pages","1","Name","0");
INSERT INTO tbl_print_header_body VALUES("85","1","indoo_registration_form_other_pages","1","Patient ID","0");
INSERT INTO tbl_print_header_body VALUES("86","1","indoo_registration_form_other_pages","1","Age/Gender","0");
INSERT INTO tbl_print_header_body VALUES("87","1","indoo_registration_form_other_pages","2","Age/Gender","0");
INSERT INTO tbl_print_header_body VALUES("88","1","dis_summary","1","Age","0");
INSERT INTO tbl_print_header_body VALUES("89","1","dis_summary","2","Age","0");
INSERT INTO tbl_print_header_body VALUES("90","1","dis_summary","1","Gender","0");
INSERT INTO tbl_print_header_body VALUES("91","1","dis_summary","2","Gender","0");
INSERT INTO tbl_print_header_body VALUES("92","2","out_patient_prescription","1","Age","0");
INSERT INTO tbl_print_header_body VALUES("93","2","out_patient_prescription","2","Age","0");
INSERT INTO tbl_print_header_body VALUES("94","2","out_patient_prescription","1","Gender","0");
INSERT INTO tbl_print_header_body VALUES("95","2","out_patient_prescription","2","Gender","0");
INSERT INTO tbl_print_header_body VALUES("96","2","out_patient_registration_casesheet_casefile","1","Age/Gender","0");
INSERT INTO tbl_print_header_body VALUES("97","2","out_patient_registration_casesheet_casefile","2","Age/Gender","0");
INSERT INTO tbl_print_header_body VALUES("98","2","out_patient_prescription","1","Date","0");
INSERT INTO tbl_print_header_body VALUES("99","1","dis_summary","1","Address","0");
INSERT INTO tbl_print_header_body VALUES("100","1","dis_summary","2","Address","0");
INSERT INTO tbl_print_header_body VALUES("101","1","dis_summary","1","Dob","0");
INSERT INTO tbl_print_header_body VALUES("102","1","dis_summary","2","Dob","0");
INSERT INTO tbl_print_header_body VALUES("103","1","dis_summary","1","Days of Stay","0");
INSERT INTO tbl_print_header_body VALUES("104","1","dis_summary","2","Days of Stay","0");
INSERT INTO tbl_print_header_body VALUES("105","1","dis_summary","1","Discharge Type","0");
INSERT INTO tbl_print_header_body VALUES("106","1","dis_summary","2","Discharge Type","0");



DROP TABLE tbl_print_settings_master;

CREATE TABLE `tbl_print_settings_master` (
  `tpsm_id` int(11) NOT NULL AUTO_INCREMENT,
  `tpsm_title` varchar(400) DEFAULT NULL,
  `hmid` int(11) NOT NULL DEFAULT '0',
  `tpsm_tm` varchar(11) NOT NULL DEFAULT '0',
  `tpsm_bm` varchar(11) NOT NULL DEFAULT '0',
  `tpsm_rm` varchar(11) NOT NULL DEFAULT '0',
  `tpsm_lm` varchar(11) NOT NULL DEFAULT '0',
  `tpsm_page_size` varchar(20) DEFAULT NULL,
  `tpsm_page_orientation` varchar(100) DEFAULT NULL,
  `tpsm_heading_font_size` varchar(20) DEFAULT NULL,
  `tpsm_content_font_size` varchar(20) DEFAULT NULL,
  `tpsm_left` varchar(20) NOT NULL DEFAULT 'N',
  `tpsm_left_sign` varchar(255) DEFAULT NULL,
  `tpsm_right` varchar(20) NOT NULL DEFAULT 'N',
  `tpsm_right_sign` varchar(255) DEFAULT NULL,
  `tpsm_include_header` varchar(20) NOT NULL DEFAULT 'Y',
  `tpsm_include_logo` varchar(20) NOT NULL DEFAULT 'Y',
  `tpsm_header_text` varchar(500) DEFAULT NULL,
  `tpsm_header_sub_text` varchar(700) NOT NULL,
  `tpsm_header_sub_text_2` varchar(1000) DEFAULT NULL,
  `tpsm_header_sub_text_3` varchar(1000) DEFAULT NULL,
  `tpsm_hstf` varchar(20) DEFAULT NULL,
  `tpsm_del_by` int(11) NOT NULL DEFAULT '0',
  `tpsm_include_footer` varchar(20) NOT NULL DEFAULT 'Y',
  `tpsm_footer_text` longtext,
  `tpsm_doctor_display` int(11) NOT NULL DEFAULT '0',
  `tpsm_doctor_name_display` varchar(20) DEFAULT 'Y',
  `tpsm_gmc_no` varchar(20) DEFAULT 'Y',
  `tpsm_mobile_no` varchar(20) DEFAULT 'Y',
  `tpsm_watermark` varchar(20) NOT NULL DEFAULT 'N',
  `tpsm_footer_font_size` varchar(20) DEFAULT NULL,
  `tpsm_label1` varchar(255) DEFAULT NULL,
  `tpsm_label2` varchar(255) DEFAULT NULL,
  `tpsm_label3` varchar(255) DEFAULT NULL,
  `tpsm_label4` varchar(255) DEFAULT NULL,
  `tpsm_label5` varchar(255) DEFAULT NULL,
  `tpsm_label6` varchar(255) DEFAULT NULL,
  `tpsm_label7` varchar(255) DEFAULT NULL,
  `tpsm_label8` varchar(255) DEFAULT NULL,
  `tpsm_label9` varchar(255) DEFAULT NULL,
  `tpsm_label10` varchar(255) DEFAULT NULL,
  `tpsm_label11` varchar(255) DEFAULT NULL,
  `tpsm_label12` varchar(255) DEFAULT NULL,
  `tpsm_label13` varchar(255) DEFAULT NULL,
  `tpsm_label14` varchar(255) DEFAULT NULL,
  `tpsm_label15` varchar(255) DEFAULT NULL,
  `tpsm_label16` varchar(255) DEFAULT NULL,
  `tpsm_label17` varchar(255) DEFAULT NULL,
  `tpsm_label18` varchar(255) DEFAULT NULL,
  `tpsm_label19` varchar(255) DEFAULT NULL,
  `tpsm_label20` varchar(255) DEFAULT NULL,
  `tpsm_display_accountant_name` varchar(255) NOT NULL DEFAULT 'Y',
  `tpsm_display_signature` varchar(255) NOT NULL DEFAULT 'N',
  `tpsm_bill_overview_display` varchar(255) DEFAULT 'N',
  `tpsm_display_printedby` varchar(20) NOT NULL DEFAULT 'Y',
  `tpsm_display_printedon` varchar(20) NOT NULL DEFAULT 'Y',
  `tpsm_display_createdby` varchar(20) NOT NULL DEFAULT 'Y',
  `tpsm_display_createdon` varchar(20) NOT NULL DEFAULT 'Y',
  `tpsm_display_bdetails` varchar(20) NOT NULL DEFAULT 'N',
  `tpsm_display_recesign` varchar(20) NOT NULL DEFAULT 'N',
  `tpsm_type` varchar(11) DEFAULT NULL COMMENT '1-IPD,2-OPD,3-IPD Pharmacy,4-OPD Pharmacy,5-IPD Billing,6-OPD Billing',
  `tpsm_page_type` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`tpsm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;

INSERT INTO tbl_print_settings_master VALUES("1","Indoor Registration Form , Other Pages","1","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009 Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","85","84","83","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","1","indoo_registration_form_other_pages");
INSERT INTO tbl_print_settings_master VALUES("2","Out Patient Registration , Case Sheet , Case File","1","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","2","1","3","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","2","out_patient_registration_casesheet_casefile");
INSERT INTO tbl_print_settings_master VALUES("3","IPD Pharmacy","1","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","3","ipd_pharmacy");
INSERT INTO tbl_print_settings_master VALUES("4","OPD Pharmacy","1","2","1.5","1","1","A4","portrait","24","14","","","","","Y","N","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","4","opd_pharmacy");
INSERT INTO tbl_print_settings_master VALUES("5","IPD Billing","1","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","5","ipd_billing");
INSERT INTO tbl_print_settings_master VALUES("6","OPD Billing","1","2","1.5","1","1","A5","landscape","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","6","opd_billing");
INSERT INTO tbl_print_settings_master VALUES("7","Inpatient Billing Overview","1","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","5","inpatient_billing_overview");
INSERT INTO tbl_print_settings_master VALUES("9","Discharge Summary","1","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","18","19","20","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","1","dis_summary");
INSERT INTO tbl_print_settings_master VALUES("10","Out Patient Prescription","1","1.5","1.5","1","1","A5","landscape","10","16","","","","","Y","Y","Strauss Super specialty Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Super specialty Hospital","0","Y","Y","Y","N","16","13","14","16","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","2","out_patient_prescription");
INSERT INTO tbl_print_settings_master VALUES("11","Indoor Registration Form , Other Pages","3","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009 Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","1","indoo_registration_form_other_pages");
INSERT INTO tbl_print_settings_master VALUES("12","Out Patient Registration , Case Sheet , Case File","3","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","2","out_patient_registration_casesheet_casefile");
INSERT INTO tbl_print_settings_master VALUES("13","IPD Pharmacy","3","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","3","ipd_pharmacy");
INSERT INTO tbl_print_settings_master VALUES("14","OPD Pharmacy","3","2","1.5","1","1","A4","portrait","24","14","","","","","Y","N","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","4","opd_pharmacy");
INSERT INTO tbl_print_settings_master VALUES("15","IPD Billing","3","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","5","ipd_billing");
INSERT INTO tbl_print_settings_master VALUES("16","OPD Billing","3","2","1.5","1","1","A5","landscape","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","6","opd_billing");
INSERT INTO tbl_print_settings_master VALUES("17","Inpatient Billing Overview","3","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","5","inpatient_billing_overview");
INSERT INTO tbl_print_settings_master VALUES("18","Discharge Summary","3","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","1","dis_summary");
INSERT INTO tbl_print_settings_master VALUES("19","Out Patient Prescription","3","1.5","1.5","1","1","A5","landscape","22","14","","","","","Y","Y","Strauss Super specialty Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Super specialty Hospital","0","Y","Y","Y","N","14","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","2","out_patient_prescription");
INSERT INTO tbl_print_settings_master VALUES("20","PDO","3","50","40","1","1","A4","portrait","24","14","","","","","N","N","","","","","16","0","N","","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","7","document_13");
INSERT INTO tbl_print_settings_master VALUES("21","Policy","3","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Super Speciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","7","document_14");
INSERT INTO tbl_print_settings_master VALUES("22","Policy","1","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Super Speciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","7","document_15");
INSERT INTO tbl_print_settings_master VALUES("23","Outpatient Billing Overview","1","2","1.5","1","1","A4","portrait","24","14","","","","","Y","Y","Strauss Super Speciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","6","opd_billing_overview");
INSERT INTO tbl_print_settings_master VALUES("24","Outpatient Billing Overview","3","2","1.5","1","1","A5","landscape","24","14","","","","","Y","Y","Strauss Superspeciality Hospital","Bsquare, 4th Floor, 3rd Eye Vision Complex, IIM Road - Ahmedabad 380009","","","16","0","Y","Strauss Healthcare Private Limited","0","Y","Y","Y","N","16","","","","","","","","","","","","","","","","","","","","","Y","N","N","Y","Y","Y","Y","N","N","6","opd_billing_overview");



DROP TABLE tbl_radiology_report_template;

CREATE TABLE `tbl_radiology_report_template` (
  `trrt_id` int(11) NOT NULL AUTO_INCREMENT,
  `um_id` int(11) NOT NULL DEFAULT '0',
  `trrt_title` varchar(750) DEFAULT NULL,
  `trrt_notes` longtext,
  `trrt_del` int(11) NOT NULL DEFAULT '0',
  `trrt_created_by` int(11) NOT NULL DEFAULT '0',
  `trrt_modify_by` int(11) DEFAULT NULL,
  `trrt_delete_by` int(11) NOT NULL DEFAULT '0',
  `trrt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `trrt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`trrt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_receipt_master;

CREATE TABLE `tbl_receipt_master` (
  `rm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  `um_id` int(11) NOT NULL,
  `rm_receipt_id` text NOT NULL,
  `seq_no` bigint(20) NOT NULL,
  `im_invoice_id` text NOT NULL,
  `rm_pid` text NOT NULL,
  `in_pid` text,
  `rm_total` double NOT NULL,
  `rm_given_amount` double NOT NULL,
  `rm_pending_amount` double NOT NULL,
  `rm_date` date NOT NULL,
  `rm_parent` int(11) DEFAULT NULL,
  `rm_status` int(11) NOT NULL DEFAULT '0',
  `payment_option` int(11) NOT NULL DEFAULT '0',
  `pay_ref_no` varchar(255) DEFAULT NULL,
  `bill_type` varchar(255) DEFAULT NULL,
  `rm_created_id` int(11) DEFAULT NULL,
  `rm_modify_id` int(11) DEFAULT NULL,
  `rm_delete_id` int(11) DEFAULT NULL,
  `rm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_refer_category;

CREATE TABLE `tbl_refer_category` (
  `rc_id` int(11) NOT NULL AUTO_INCREMENT,
  `rc_name` varchar(70) DEFAULT NULL,
  `rc_del` int(11) NOT NULL DEFAULT '0',
  `rc_created_by` int(11) DEFAULT NULL,
  `rc_modify_by` int(11) DEFAULT NULL,
  `rc_delete_by` int(11) NOT NULL DEFAULT '0',
  `rc_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rc_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rc_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;

INSERT INTO tbl_refer_category VALUES("10","Normal","0","1","1","0","2018-02-28 17:46:22","2018-05-07 12:22:27");
INSERT INTO tbl_refer_category VALUES("11","Special","0","1","1","0","2018-02-28 17:46:51","2018-05-07 12:22:33");
INSERT INTO tbl_refer_category VALUES("12","VIP","0","1","1","0","2018-02-28 17:46:58","2018-05-07 12:22:37");
INSERT INTO tbl_refer_category VALUES("13","VVIP","0","1","1","0","2018-03-01 17:16:13","2018-05-07 12:22:42");
INSERT INTO tbl_refer_category VALUES("14","urgent","0","1","0","0","2018-05-07 12:23:06","0000-00-00 00:00:00");



DROP TABLE tbl_refer_type;

CREATE TABLE `tbl_refer_type` (
  `rt_id` int(11) NOT NULL AUTO_INCREMENT,
  `rt_name` varchar(70) DEFAULT NULL,
  `rt_del` int(11) NOT NULL DEFAULT '0',
  `rt_created_by` int(11) DEFAULT NULL,
  `rt_modify_by` int(11) DEFAULT NULL,
  `rt_delete_by` int(11) DEFAULT NULL,
  `rt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rt_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

INSERT INTO tbl_refer_type VALUES("10","Doctor","0","1","1","0","2018-02-28 17:46:22","2018-05-07 12:28:18");
INSERT INTO tbl_refer_type VALUES("11","Relative","0","1","1","0","2018-02-28 17:46:51","2018-05-07 12:28:23");
INSERT INTO tbl_refer_type VALUES("12","Other individual","0","1","1","0","2018-02-28 17:46:58","2018-05-07 12:28:30");
INSERT INTO tbl_refer_type VALUES("13","Google","0","1","1","0","2018-03-01 17:16:13","2018-05-07 12:28:41");
INSERT INTO tbl_refer_type VALUES("14","Newpaper","0","1","0","0","2018-05-07 12:28:48","0000-00-00 00:00:00");
INSERT INTO tbl_refer_type VALUES("15","TV Advertisement","0","1","0","0","2018-05-07 12:29:06","0000-00-00 00:00:00");
INSERT INTO tbl_refer_type VALUES("16","Radio Advertisement","0","1","0","0","2018-05-07 12:29:14","0000-00-00 00:00:00");



DROP TABLE tbl_reference_certificate;

CREATE TABLE `tbl_reference_certificate` (
  `trc_id` int(11) NOT NULL AUTO_INCREMENT,
  `tpc_id` int(11) DEFAULT NULL,
  `addressed_no` varchar(150) DEFAULT NULL,
  `remark` varchar(750) DEFAULT NULL,
  PRIMARY KEY (`trc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_reference_master;

CREATE TABLE `tbl_reference_master` (
  `rm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(150) DEFAULT NULL,
  `rm_type` int(11) DEFAULT NULL,
  `rm_name` varchar(150) DEFAULT NULL,
  `rm_phone_no` varchar(50) DEFAULT NULL,
  `rm_email` varchar(250) DEFAULT NULL,
  `rm_degree` varchar(150) DEFAULT NULL,
  `rm_organization` varchar(70) DEFAULT NULL,
  `rm_category` int(11) NOT NULL DEFAULT '0',
  `rm_location` varchar(150) DEFAULT NULL,
  `rm_pincode` varchar(250) DEFAULT NULL,
  `rm_area` varchar(250) DEFAULT NULL,
  `rm_city` varchar(250) DEFAULT NULL,
  `rm_district` varchar(250) DEFAULT NULL,
  `rm_state` varchar(250) DEFAULT NULL,
  `rm_country` varchar(250) DEFAULT NULL,
  `rm_remark` varchar(750) DEFAULT NULL,
  `rm_total` int(11) NOT NULL DEFAULT '0',
  `rm_del` int(11) NOT NULL DEFAULT '0',
  `rm_created_by` int(11) NOT NULL DEFAULT '0',
  `rm_modify_by` int(11) DEFAULT NULL,
  `rm_delete_by` int(11) DEFAULT NULL,
  `rm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_role_master;

CREATE TABLE `tbl_role_master` (
  `rm_id` int(11) NOT NULL AUTO_INCREMENT,
  `mm_id` int(11) DEFAULT NULL,
  `rm_role_name` varchar(150) DEFAULT NULL,
  `rm_module_status` int(11) DEFAULT '0',
  `rm_del` int(11) DEFAULT '0',
  `rm_created_by` int(11) NOT NULL DEFAULT '0',
  `rm_modify_by` int(11) DEFAULT '0',
  `rm_delete_by` int(11) DEFAULT '0',
  `rm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`rm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=370 DEFAULT CHARSET=latin1;

INSERT INTO tbl_role_master VALUES("1","2","Add Patient","0","0","1","0","0","2018-06-21 11:16:56","2018-07-06 08:59:37");
INSERT INTO tbl_role_master VALUES("2","2","Edit Patient","0","0","1","0","0","2018-06-21 11:16:56","");
INSERT INTO tbl_role_master VALUES("3","2","Change Appointment Status","0","0","1","0","0","2018-06-21 11:16:56","");
INSERT INTO tbl_role_master VALUES("4","2","Delete Appointment","0","0","0","0","0","2018-06-21 11:16:56","2018-06-25 12:02:02");
INSERT INTO tbl_role_master VALUES("5","2","Add Reschedule","0","0","1","0","0","2018-06-21 11:16:56","");
INSERT INTO tbl_role_master VALUES("6","2","Add Clinical Data","0","0","1","0","0","2018-06-21 11:17:31","2018-12-28 09:35:03");
INSERT INTO tbl_role_master VALUES("7","2","Add body compositions","1","1","1","0","0","2018-06-21 11:17:31","2018-12-28 09:35:03");
INSERT INTO tbl_role_master VALUES("8","2","Print Label & Registration Details","0","0","1","1","0","2018-06-21 11:17:48","2018-07-24 15:40:13");
INSERT INTO tbl_role_master VALUES("9","1","View All Appointment","0","0","1","0","0","2018-06-21 13:25:45","");
INSERT INTO tbl_role_master VALUES("10","1","Add Patient","0","0","1","0","0","2018-06-21 13:25:45","");
INSERT INTO tbl_role_master VALUES("11","11","view Consultation/Visit","0","0","1","0","0","2018-06-21 13:26:47","2018-06-25 16:51:49");
INSERT INTO tbl_role_master VALUES("12","4","Add Ward","0","0","1","0","0","2018-06-21 13:31:08","");
INSERT INTO tbl_role_master VALUES("13","4","Edit Ward","0","0","1","0","0","2018-06-21 13:31:08","");
INSERT INTO tbl_role_master VALUES("14","4","Delete Ward","0","0","1","0","0","2018-06-21 13:31:08","");
INSERT INTO tbl_role_master VALUES("15","4","Add Room/Bed","0","0","1","0","0","2018-06-21 13:31:08","");
INSERT INTO tbl_role_master VALUES("16","4","Edit Room/Bed","0","0","1","0","0","2018-06-21 13:31:08","");
INSERT INTO tbl_role_master VALUES("17","4","Delete Room/Bed","0","0","1","0","0","2018-06-21 13:31:22","");
INSERT INTO tbl_role_master VALUES("18","5","Add Admission","0","0","1","0","0","2018-06-21 13:33:06","");
INSERT INTO tbl_role_master VALUES("19","5","Edit Inpatient Details","0","0","1","0","0","2018-06-21 13:33:06","");
INSERT INTO tbl_role_master VALUES("20","5","Transfer Patient","0","0","1","0","0","2018-06-21 13:33:06","");
INSERT INTO tbl_role_master VALUES("21","5","Discharge/ Re-admit","0","0","1","0","0","2018-06-21 13:33:06","");
INSERT INTO tbl_role_master VALUES("22","6","Show Inpatient","0","0","1","0","0","2018-06-21 13:34:53","");
INSERT INTO tbl_role_master VALUES("23","6","Show Outpatient","0","0","1","0","0","2018-06-21 13:34:53","");
INSERT INTO tbl_role_master VALUES("24","6","Send SMS","0","0","1","0","0","2018-06-21 13:34:53","");
INSERT INTO tbl_role_master VALUES("25","6","Print Patient Label","0","0","1","1","0","2018-06-21 13:34:53","2018-07-24 17:11:28");
INSERT INTO tbl_role_master VALUES("26","6","Show Reference Database","0","0","1","0","0","2018-06-21 13:34:53","");
INSERT INTO tbl_role_master VALUES("27","6","Edit Other reference","0","0","1","0","0","2018-06-21 13:34:53","");
INSERT INTO tbl_role_master VALUES("28","6","Delete other reference","0","0","1","0","0","2018-06-21 13:34:53","");
INSERT INTO tbl_role_master VALUES("30","10","Inpatient Master","0","0","1","0","0","2018-06-21 13:35:57","2018-06-29 15:01:19");
INSERT INTO tbl_role_master VALUES("33","11","Add Consultation/Visit","0","0","1","0","0","2018-06-25 16:32:06","2018-06-25 16:51:52");
INSERT INTO tbl_role_master VALUES("34","11","Show Clinical data","0","0","1","0","0","2018-06-25 16:32:06","");
INSERT INTO tbl_role_master VALUES("35","11","Add Clinical data","0","0","1","0","0","2018-06-25 16:32:06","");
INSERT INTO tbl_role_master VALUES("36","11","Edit Clinical data","0","0","1","0","0","2018-06-25 16:32:06","");
INSERT INTO tbl_role_master VALUES("37","11","Delete Clinical data","0","0","1","0","0","2018-06-25 16:32:06","");
INSERT INTO tbl_role_master VALUES("38","11","Show Patient Engagement","0","0","1","0","0","2018-06-25 16:32:06","");
INSERT INTO tbl_role_master VALUES("39","11","Add Patient Engagement","0","0","1","0","0","2018-06-25 16:32:06","");
INSERT INTO tbl_role_master VALUES("40","11","Edit Patient Engagement","0","0","1","0","0","2018-06-25 16:32:06","");
INSERT INTO tbl_role_master VALUES("41","11","Delete Patient Engagement","0","0","1","0","0","2018-06-25 16:32:06","");
INSERT INTO tbl_role_master VALUES("42","11","Show Documents","0","0","1","0","0","2018-06-25 16:32:06","2018-06-25 17:18:06");
INSERT INTO tbl_role_master VALUES("43","11","Add Documents","0","0","1","0","0","2018-06-25 16:32:37","2018-06-25 17:18:07");
INSERT INTO tbl_role_master VALUES("44","11","Delete Document","0","0","1","0","0","2018-06-25 16:32:37","2018-06-25 17:18:07");
INSERT INTO tbl_role_master VALUES("45","11","Show SMS Logs","0","0","1","0","0","2018-06-25 16:32:50","2018-06-25 17:18:07");
INSERT INTO tbl_role_master VALUES("46","11","Show Patient History","0","0","1","0","0","2018-06-25 17:18:20","");
INSERT INTO tbl_role_master VALUES("47","10","Out Patient Master","0","0","1","0","0","2018-06-29 15:02:19","");
INSERT INTO tbl_role_master VALUES("48","10","Medicine Master","0","0","1","0","0","2018-06-29 15:02:19","");
INSERT INTO tbl_role_master VALUES("49","10","Patient Engagement","0","0","1","0","0","2018-06-29 15:02:19","");
INSERT INTO tbl_role_master VALUES("50","10","Billing Master","0","0","1","0","0","2018-06-29 15:02:19","");
INSERT INTO tbl_role_master VALUES("116","20","Show Purchase Order","0","0","1","0","0","2018-07-09 10:14:31","");
INSERT INTO tbl_role_master VALUES("117","20","Add Purchase Order","0","0","1","0","0","2018-07-09 10:14:40","");
INSERT INTO tbl_role_master VALUES("118","20","List Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:40","");
INSERT INTO tbl_role_master VALUES("119","20","Add Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:46","");
INSERT INTO tbl_role_master VALUES("120","20","Edit Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:52","");
INSERT INTO tbl_role_master VALUES("121","20","Delete Purchase Invoice","0","0","1","0","0","2018-07-09 10:20:05","");
INSERT INTO tbl_role_master VALUES("122","20","List Sales Invoice","0","0","1","0","0","2018-07-09 10:21:36","");
INSERT INTO tbl_role_master VALUES("123","20","Add Sales Invoice","0","0","1","0","0","2018-07-09 10:21:42","");
INSERT INTO tbl_role_master VALUES("124","20","Edit Sales Invoice","0","0","1","0","0","2018-07-09 10:21:49","");
INSERT INTO tbl_role_master VALUES("125","20","delete Sales Invoice","0","0","1","0","0","2018-07-09 10:21:56","");
INSERT INTO tbl_role_master VALUES("126","20","List Sales Return","0","0","1","0","0","2018-07-09 10:22:31","");
INSERT INTO tbl_role_master VALUES("127","20","Add  Sales Return","0","0","1","0","0","2018-07-09 10:22:38","");
INSERT INTO tbl_role_master VALUES("128","20","Edit Sales Return","0","0","1","0","0","2018-07-09 10:22:45","");
INSERT INTO tbl_role_master VALUES("129","20","Delete Sales Return","0","0","1","0","0","2018-07-09 10:23:09","");
INSERT INTO tbl_role_master VALUES("130","20","View Stock details","0","0","1","0","0","2018-07-09 10:24:42","");
INSERT INTO tbl_role_master VALUES("131","20","Add Physical Stock Verification","0","0","1","0","0","2018-07-09 10:25:31","");
INSERT INTO tbl_role_master VALUES("132","20","List Stock Loss","0","0","1","0","0","2018-07-09 10:25:40","");
INSERT INTO tbl_role_master VALUES("133","20","Show Reports","0","0","1","0","0","2018-07-09 10:26:03","");
INSERT INTO tbl_role_master VALUES("134","20","Show Supplier Master","0","0","1","0","0","2018-07-09 10:27:20","");
INSERT INTO tbl_role_master VALUES("135","20","Add Supplier Master","0","0","1","0","0","2018-07-09 10:27:25","");
INSERT INTO tbl_role_master VALUES("136","20","Edit Supplier Master","0","0","1","0","0","2018-07-09 10:27:31","");
INSERT INTO tbl_role_master VALUES("137","20","Delete Supplier Master","0","0","1","0","0","2018-07-09 10:27:41","");
INSERT INTO tbl_role_master VALUES("138","20","Show Medicine Master","0","0","1","0","0","2018-07-09 10:28:04","");
INSERT INTO tbl_role_master VALUES("139","20","Add Medicine Master","0","0","1","1","0","2018-07-09 10:28:11","2018-07-09 10:28:42");
INSERT INTO tbl_role_master VALUES("140","20","Edit Medicine Master","0","0","1","0","0","2018-07-09 10:28:49","");
INSERT INTO tbl_role_master VALUES("141","20","Delete Medicine Master","0","0","1","0","0","2018-07-09 10:28:55","");
INSERT INTO tbl_role_master VALUES("142","20","Show Medicine Group Master","0","0","1","0","0","2018-07-09 10:31:16","");
INSERT INTO tbl_role_master VALUES("143","20","Add Medicine Group","0","0","1","0","0","2018-07-09 10:31:30","");
INSERT INTO tbl_role_master VALUES("144","20","Edit Medicine Group","0","0","1","0","0","2018-07-09 10:31:33","");
INSERT INTO tbl_role_master VALUES("145","20","Delete Medicine Group","0","0","1","0","0","2018-07-09 10:31:41","");
INSERT INTO tbl_role_master VALUES("146","20","Show Generic Master","0","0","1","1","0","2018-07-09 10:32:00","2018-07-09 10:33:13");
INSERT INTO tbl_role_master VALUES("147","20","Add Medicine Generic","0","0","1","1","0","2018-07-09 10:32:09","2018-07-09 10:33:27");
INSERT INTO tbl_role_master VALUES("148","20","Edit Medicine Generic","0","0","1","1","0","2018-07-09 10:32:33","2018-07-09 10:33:35");
INSERT INTO tbl_role_master VALUES("149","20","Delete Medicine Generic","0","0","1","0","0","2018-07-09 10:32:56","");
INSERT INTO tbl_role_master VALUES("150","20","Show Medicine Company Master","0","0","1","0","0","2018-07-09 10:36:15","");
INSERT INTO tbl_role_master VALUES("151","20","Add Medicine Company","0","0","1","0","0","2018-07-09 10:36:25","");
INSERT INTO tbl_role_master VALUES("152","20","Edit Medicine Company","0","0","1","0","0","2018-07-09 10:36:37","");
INSERT INTO tbl_role_master VALUES("153","20","Delete Medicine Company","0","0","1","0","0","2018-07-09 10:36:54","");
INSERT INTO tbl_role_master VALUES("154","21","Show Purchase Order","0","0","1","0","0","2018-07-09 10:14:31","");
INSERT INTO tbl_role_master VALUES("155","21","Add Purchase Order","0","0","1","0","0","2018-07-09 10:14:40","");
INSERT INTO tbl_role_master VALUES("156","21","List Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:40","");
INSERT INTO tbl_role_master VALUES("157","21","Add Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:46","");
INSERT INTO tbl_role_master VALUES("158","21","Edit Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:52","");
INSERT INTO tbl_role_master VALUES("159","21","Delete Purchase Invoice","0","0","1","0","0","2018-07-09 10:20:05","");
INSERT INTO tbl_role_master VALUES("160","21","List Sales Invoice","0","0","1","0","0","2018-07-09 10:21:36","");
INSERT INTO tbl_role_master VALUES("161","21","Add Sales Invoice","0","0","1","0","0","2018-07-09 10:21:42","");
INSERT INTO tbl_role_master VALUES("162","21","Edit Sales Invoice","0","0","1","0","0","2018-07-09 10:21:49","");
INSERT INTO tbl_role_master VALUES("163","21","delete Sales Invoice","0","0","1","0","0","2018-07-09 10:21:56","");
INSERT INTO tbl_role_master VALUES("164","21","List Sales Return","0","0","1","0","0","2018-07-09 10:22:31","");
INSERT INTO tbl_role_master VALUES("165","21","Add  Sales Return","0","0","1","0","0","2018-07-09 10:22:38","");
INSERT INTO tbl_role_master VALUES("166","21","Edit Sales Return","0","0","1","0","0","2018-07-09 10:22:45","");
INSERT INTO tbl_role_master VALUES("167","21","Delete Sales Return","0","0","1","0","0","2018-07-09 10:23:09","");
INSERT INTO tbl_role_master VALUES("168","21","View Stock details","0","0","1","0","0","2018-07-09 10:24:42","");
INSERT INTO tbl_role_master VALUES("169","21","Add Physical Stock Verification","0","0","1","0","0","2018-07-09 10:25:31","");
INSERT INTO tbl_role_master VALUES("170","21","List Stock Loss","0","0","1","0","0","2018-07-09 10:25:40","");
INSERT INTO tbl_role_master VALUES("171","21","Show Reports","0","0","1","0","0","2018-07-09 10:26:03","");
INSERT INTO tbl_role_master VALUES("172","21","Show Supplier Master","0","0","1","0","0","2018-07-09 10:27:20","");
INSERT INTO tbl_role_master VALUES("173","21","Add Supplier Master","0","0","1","0","0","2018-07-09 10:27:25","");
INSERT INTO tbl_role_master VALUES("174","21","Edit Supplier Master","0","0","1","0","0","2018-07-09 10:27:31","");
INSERT INTO tbl_role_master VALUES("175","21","Delete Supplier Master","0","0","1","0","0","2018-07-09 10:27:41","");
INSERT INTO tbl_role_master VALUES("176","21","Show Medicine Master","0","0","1","0","0","2018-07-09 10:28:04","");
INSERT INTO tbl_role_master VALUES("177","21","Add Medicine Master","0","0","1","1","0","2018-07-09 10:28:11","2018-07-09 10:28:42");
INSERT INTO tbl_role_master VALUES("178","21","Edit Medicine Master","0","0","1","0","0","2018-07-09 10:28:49","");
INSERT INTO tbl_role_master VALUES("179","21","Delete Medicine Master","0","0","1","0","0","2018-07-09 10:28:55","");
INSERT INTO tbl_role_master VALUES("180","21","Show Medicine Group Master","0","0","1","0","0","2018-07-09 10:31:16","");
INSERT INTO tbl_role_master VALUES("181","21","Add Medicine Group","0","0","1","0","0","2018-07-09 10:31:30","");
INSERT INTO tbl_role_master VALUES("182","21","Edit Medicine Group","0","0","1","0","0","2018-07-09 10:31:33","");
INSERT INTO tbl_role_master VALUES("183","21","Delete Medicine Group","0","0","1","0","0","2018-07-09 10:31:41","");
INSERT INTO tbl_role_master VALUES("184","21","Show Generic Master","0","0","1","1","0","2018-07-09 10:32:00","2018-07-09 10:33:13");
INSERT INTO tbl_role_master VALUES("185","21","Add Medicine Generic","0","0","1","1","0","2018-07-09 10:32:09","2018-07-09 10:33:27");
INSERT INTO tbl_role_master VALUES("186","21","Edit Medicine Generic","0","0","1","1","0","2018-07-09 10:32:33","2018-07-09 10:33:35");
INSERT INTO tbl_role_master VALUES("187","21","Delete Medicine Generic","0","0","1","0","0","2018-07-09 10:32:56","");
INSERT INTO tbl_role_master VALUES("188","21","Show Medicine Company Master","0","0","1","0","0","2018-07-09 10:36:15","");
INSERT INTO tbl_role_master VALUES("189","21","Add Medicine Company","0","0","1","0","0","2018-07-09 10:36:25","");
INSERT INTO tbl_role_master VALUES("190","21","Edit Medicine Company","0","0","1","0","0","2018-07-09 10:36:37","");
INSERT INTO tbl_role_master VALUES("191","21","Delete Medicine Company","0","0","1","0","0","2018-07-09 10:36:54","");
INSERT INTO tbl_role_master VALUES("192","22","Show Purchase Order","0","0","1","0","0","2018-07-09 10:14:31","");
INSERT INTO tbl_role_master VALUES("193","22","Add Purchase Order","0","0","1","0","0","2018-07-09 10:14:40","");
INSERT INTO tbl_role_master VALUES("194","22","List Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:40","");
INSERT INTO tbl_role_master VALUES("195","22","Add Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:46","");
INSERT INTO tbl_role_master VALUES("196","22","Edit Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:52","");
INSERT INTO tbl_role_master VALUES("197","22","Delete Purchase Invoice","0","0","1","0","0","2018-07-09 10:20:05","");
INSERT INTO tbl_role_master VALUES("198","22","List Sales Invoice","0","0","1","0","0","2018-07-09 10:21:36","");
INSERT INTO tbl_role_master VALUES("199","22","Add Sales Invoice","0","0","1","0","0","2018-07-09 10:21:42","");
INSERT INTO tbl_role_master VALUES("200","22","Edit Sales Invoice","0","0","1","0","0","2018-07-09 10:21:49","");
INSERT INTO tbl_role_master VALUES("201","22","delete Sales Invoice","0","0","1","0","0","2018-07-09 10:21:56","");
INSERT INTO tbl_role_master VALUES("202","22","List Sales Return","0","0","1","0","0","2018-07-09 10:22:31","");
INSERT INTO tbl_role_master VALUES("203","22","Add  Sales Return","0","0","1","0","0","2018-07-09 10:22:38","");
INSERT INTO tbl_role_master VALUES("204","22","Edit Sales Return","0","0","1","0","0","2018-07-09 10:22:45","");
INSERT INTO tbl_role_master VALUES("205","22","Delete Sales Return","0","0","1","0","0","2018-07-09 10:23:09","");
INSERT INTO tbl_role_master VALUES("206","22","View Stock details","0","0","1","0","0","2018-07-09 10:24:42","");
INSERT INTO tbl_role_master VALUES("207","22","Add Physical Stock Verification","0","0","1","0","0","2018-07-09 10:25:31","");
INSERT INTO tbl_role_master VALUES("208","22","List Stock Loss","0","0","1","0","0","2018-07-09 10:25:40","");
INSERT INTO tbl_role_master VALUES("209","22","Show Reports","0","0","1","0","0","2018-07-09 10:26:03","");
INSERT INTO tbl_role_master VALUES("210","22","Show Supplier Master","0","0","1","0","0","2018-07-09 10:27:20","");
INSERT INTO tbl_role_master VALUES("211","22","Add Supplier Master","0","0","1","0","0","2018-07-09 10:27:25","");
INSERT INTO tbl_role_master VALUES("212","22","Edit Supplier Master","0","0","1","0","0","2018-07-09 10:27:31","");
INSERT INTO tbl_role_master VALUES("213","22","Delete Supplier Master","0","0","1","0","0","2018-07-09 10:27:41","");
INSERT INTO tbl_role_master VALUES("214","22","Show Medicine Master","0","0","1","0","0","2018-07-09 10:28:04","");
INSERT INTO tbl_role_master VALUES("215","22","Add Medicine Master","0","0","1","1","0","2018-07-09 10:28:11","2018-07-09 10:28:42");
INSERT INTO tbl_role_master VALUES("216","22","Edit Medicine Master","0","0","1","0","0","2018-07-09 10:28:49","");
INSERT INTO tbl_role_master VALUES("217","22","Delete Medicine Master","0","0","1","0","0","2018-07-09 10:28:55","");
INSERT INTO tbl_role_master VALUES("218","22","Show Medicine Group Master","0","0","1","0","0","2018-07-09 10:31:16","");
INSERT INTO tbl_role_master VALUES("219","22","Add Medicine Group","0","0","1","0","0","2018-07-09 10:31:30","");
INSERT INTO tbl_role_master VALUES("220","22","Edit Medicine Group","0","0","1","0","0","2018-07-09 10:31:33","");
INSERT INTO tbl_role_master VALUES("221","22","Delete Medicine Group","0","0","1","0","0","2018-07-09 10:31:41","");
INSERT INTO tbl_role_master VALUES("222","22","Show Generic Master","0","0","1","1","0","2018-07-09 10:32:00","2018-07-09 10:33:13");
INSERT INTO tbl_role_master VALUES("223","22","Add Medicine Generic","0","0","1","1","0","2018-07-09 10:32:09","2018-07-09 10:33:27");
INSERT INTO tbl_role_master VALUES("224","22","Edit Medicine Generic","0","0","1","1","0","2018-07-09 10:32:33","2018-07-09 10:33:35");
INSERT INTO tbl_role_master VALUES("225","22","Delete Medicine Generic","0","0","1","0","0","2018-07-09 10:32:56","");
INSERT INTO tbl_role_master VALUES("226","22","Show Medicine Company Master","0","0","1","0","0","2018-07-09 10:36:15","");
INSERT INTO tbl_role_master VALUES("227","22","Add Medicine Company","0","0","1","0","0","2018-07-09 10:36:25","");
INSERT INTO tbl_role_master VALUES("228","22","Edit Medicine Company","0","0","1","0","0","2018-07-09 10:36:37","");
INSERT INTO tbl_role_master VALUES("229","22","Delete Medicine Company","0","0","1","0","0","2018-07-09 10:36:54","");
INSERT INTO tbl_role_master VALUES("230","15","Show Purchase Order","0","0","1","0","0","2018-07-09 10:14:31","");
INSERT INTO tbl_role_master VALUES("231","15","Add Purchase Order","0","0","1","0","0","2018-07-09 10:14:40","");
INSERT INTO tbl_role_master VALUES("232","15","List Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:40","");
INSERT INTO tbl_role_master VALUES("233","15","Add Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:46","");
INSERT INTO tbl_role_master VALUES("234","15","Edit Purchase Invoice","0","0","1","0","0","2018-07-09 10:19:52","");
INSERT INTO tbl_role_master VALUES("235","15","Add Payment","0","0","1","1","0","2018-07-09 10:20:05","2018-07-25 09:37:31");
INSERT INTO tbl_role_master VALUES("236","15","List Sales Invoice","0","0","1","0","0","2018-07-09 10:21:36","");
INSERT INTO tbl_role_master VALUES("237","15","Add Sales Invoice","0","0","1","0","0","2018-07-09 10:21:42","");
INSERT INTO tbl_role_master VALUES("238","15","Edit Sales Invoice","0","0","1","0","0","2018-07-09 10:21:49","");
INSERT INTO tbl_role_master VALUES("239","15","delete Sales Invoice","0","0","1","0","0","2018-07-09 10:21:56","");
INSERT INTO tbl_role_master VALUES("240","15","List Sales Return","0","0","1","0","0","2018-07-09 10:22:31","");
INSERT INTO tbl_role_master VALUES("241","15","Add  Sales Return","0","0","1","0","0","2018-07-09 10:22:38","");
INSERT INTO tbl_role_master VALUES("242","15","Edit Sales Return","0","0","1","0","0","2018-07-09 10:22:45","");
INSERT INTO tbl_role_master VALUES("243","15","Delete Sales Return","0","0","1","0","0","2018-07-09 10:23:09","");
INSERT INTO tbl_role_master VALUES("244","15","View Stock details","0","0","1","0","0","2018-07-09 10:24:42","");
INSERT INTO tbl_role_master VALUES("245","15","Add Physical Stock Verification","0","0","1","0","0","2018-07-09 10:25:31","");
INSERT INTO tbl_role_master VALUES("246","15","List Stock Loss","0","0","1","0","0","2018-07-09 10:25:40","");
INSERT INTO tbl_role_master VALUES("247","15","Show Reports","0","0","1","0","0","2018-07-09 10:26:03","");
INSERT INTO tbl_role_master VALUES("248","15","Show Supplier Master","0","0","1","0","0","2018-07-09 10:27:20","");
INSERT INTO tbl_role_master VALUES("249","15","Add Supplier Master","0","0","1","0","0","2018-07-09 10:27:25","");
INSERT INTO tbl_role_master VALUES("250","15","Edit Supplier Master","0","0","1","0","0","2018-07-09 10:27:31","");
INSERT INTO tbl_role_master VALUES("251","15","Delete Supplier Master","0","0","1","0","0","2018-07-09 10:27:41","");
INSERT INTO tbl_role_master VALUES("252","15","Show Medicine Master","0","0","1","0","0","2018-07-09 10:28:04","");
INSERT INTO tbl_role_master VALUES("253","15","Add Medicine Master","0","0","1","1","0","2018-07-09 10:28:11","2018-07-09 10:28:42");
INSERT INTO tbl_role_master VALUES("254","15","Edit Medicine Master","0","0","1","0","0","2018-07-09 10:28:49","");
INSERT INTO tbl_role_master VALUES("255","15","Delete Medicine Master","0","0","1","0","0","2018-07-09 10:28:55","");
INSERT INTO tbl_role_master VALUES("256","15","Show Medicine Group Master","0","0","1","0","0","2018-07-09 10:31:16","");
INSERT INTO tbl_role_master VALUES("257","15","Add Medicine Group","0","0","1","0","0","2018-07-09 10:31:30","");
INSERT INTO tbl_role_master VALUES("258","15","Edit Medicine Group","0","0","1","0","0","2018-07-09 10:31:33","");
INSERT INTO tbl_role_master VALUES("259","15","Delete Medicine Group","0","0","1","0","0","2018-07-09 10:31:41","");
INSERT INTO tbl_role_master VALUES("260","15","Show Generic Master","0","0","1","1","0","2018-07-09 10:32:00","2018-07-09 10:33:13");
INSERT INTO tbl_role_master VALUES("261","15","Add Medicine Generic","0","0","1","1","0","2018-07-09 10:32:09","2018-07-09 10:33:27");
INSERT INTO tbl_role_master VALUES("262","15","Edit Medicine Generic","0","0","1","1","0","2018-07-09 10:32:33","2018-07-09 10:33:35");
INSERT INTO tbl_role_master VALUES("263","15","Delete Medicine Generic","0","0","1","0","0","2018-07-09 10:32:56","");
INSERT INTO tbl_role_master VALUES("264","15","Show Medicine Company Master","0","0","1","0","0","2018-07-09 10:36:15","");
INSERT INTO tbl_role_master VALUES("265","15","Add Medicine Company","0","0","1","0","0","2018-07-09 10:36:25","");
INSERT INTO tbl_role_master VALUES("266","15","Edit Medicine Company","0","0","1","0","0","2018-07-09 10:36:37","");
INSERT INTO tbl_role_master VALUES("267","15","Delete Medicine Company","0","0","1","0","0","2018-07-09 10:36:54","");
INSERT INTO tbl_role_master VALUES("268","19","Show Billing Overview","0","0","1","0","0","2018-07-18 09:21:35","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("269","19","Show Estimate","0","0","1","0","0","2018-07-18 09:22:16","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("270","19","Add Estimate","0","0","1","0","0","2018-07-18 09:22:23","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("271","19","Edit Estimate","0","0","1","0","0","2018-07-18 09:22:30","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("272","19","Delete/Cancel Estimate","0","0","1","0","0","2018-07-18 09:22:40","2019-03-04 12:12:50");
INSERT INTO tbl_role_master VALUES("273","19","Show Case Memo","0","0","1","0","0","2018-07-18 09:24:02","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("274","19","Add Cash Memo","0","0","1","0","0","2018-07-18 09:24:07","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("275","19","Edit Cash Memo","0","0","1","0","0","2018-07-18 09:24:13","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("276","19","Delete/Cancel Case Memo","0","0","1","0","0","2018-07-18 09:24:19","2019-03-04 12:12:50");
INSERT INTO tbl_role_master VALUES("277","19","Add/Edit Cash Memo Incentive","0","0","1","0","0","2018-07-18 09:24:40","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("278","19","Show Invoice","0","0","1","0","0","2018-07-18 09:24:45","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("279","19","Add Invoice","0","0","1","0","0","2018-07-18 09:24:51","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("280","19","Edit Invoice","0","0","1","0","0","2018-07-18 09:24:57","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("281","19","Delete/Cancel Invoice","0","0","1","0","0","2018-07-18 09:25:34","2019-03-04 12:12:50");
INSERT INTO tbl_role_master VALUES("282","19","Add/Edit Invoice Incentive","0","0","1","0","0","2018-07-18 09:25:39","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("283","19","Show Receipt","0","0","1","0","0","2018-07-18 09:25:44","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("284","19","Add Receipt","0","0","1","0","0","2018-07-18 09:25:52","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("285","19","Edit Receipt","0","0","1","0","0","2018-07-18 09:26:45","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("286","19","Delete/Cancel Receipt","0","0","1","0","0","2018-07-18 09:26:51","2019-03-04 12:12:50");
INSERT INTO tbl_role_master VALUES("287","19","Show Advance","0","0","1","0","0","2018-07-18 09:26:57","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("288","19","Add Advance","0","0","1","0","0","2018-07-18 09:27:04","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("289","19","Edit Advance","0","0","1","0","0","2018-07-18 09:27:25","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("290","19","Delete/Cancel Advance","0","0","1","0","0","2018-07-18 09:27:30","2019-03-04 12:12:50");
INSERT INTO tbl_role_master VALUES("291","19","Show Credit Notes","0","0","1","0","0","2018-07-18 09:27:37","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("292","19","Add Credit Notes","0","0","1","0","0","2018-07-18 09:27:48","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("293","19","Edit Credit Notes","0","0","1","0","0","2018-07-18 09:28:07","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("294","19","Delete/Cancel Credit Notes","0","0","1","0","0","2018-07-18 09:28:12","2019-03-04 12:12:50");
INSERT INTO tbl_role_master VALUES("295","19","Add/Edit Credit Notes Incentive","0","0","1","0","0","2018-07-18 09:28:17","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("296","19","Show Refund","0","0","1","0","0","2018-07-18 09:28:24","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("297","19","Add Refund","0","0","1","0","0","2018-07-18 09:29:13","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("298","19","Edit Refund","0","0","1","0","0","2018-07-18 09:29:19","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("299","19","Delete/Cancel Refund","0","0","1","0","0","2018-07-18 09:29:25","2019-03-04 12:12:50");
INSERT INTO tbl_role_master VALUES("300","19","Delete Outpatient Billing Retail Sales","1","0","1","0","0","2018-07-18 09:29:31","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("301","19","Show Outpatient Billing Invoice","1","0","1","0","0","2018-07-18 09:29:51","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("302","19","Add Outpatient Billing Invoice","1","0","1","0","0","2018-07-18 09:29:56","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("303","19","Edit Outpatient Billing Invoice","1","0","1","0","0","2018-07-18 09:30:02","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("304","19","Delete Outpatient Billing Invoice","1","0","1","0","0","2018-07-18 09:30:09","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("305","19","Show Outpatient Billing Receipt","1","0","1","0","0","2018-07-18 09:30:26","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("306","19","Add Outpatient Billing Receipt","1","0","1","0","0","2018-07-18 09:30:31","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("307","19","Edit Outpatient Billing Receipt","1","0","1","0","0","2018-07-18 09:30:36","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("308","19","Delete Outpatient Billing Receipt","1","0","1","0","0","2018-07-18 09:30:47","2019-03-04 12:12:44");
INSERT INTO tbl_role_master VALUES("309","5","Print Label & Registration Details","0","0","1","0","0","2018-07-24 16:38:26","2019-04-22 10:06:08");
INSERT INTO tbl_role_master VALUES("310","3","Show Admission Notes","0","0","1","0","0","2018-07-25 17:07:08","");
INSERT INTO tbl_role_master VALUES("311","3","Add Admission Notes","0","0","1","0","0","2018-07-25 17:07:20","");
INSERT INTO tbl_role_master VALUES("312","3","Show Diagnosis","0","0","1","0","0","2018-07-25 17:07:29","");
INSERT INTO tbl_role_master VALUES("313","3","Add Diagnosis","0","0","1","0","0","2018-07-25 17:07:35","");
INSERT INTO tbl_role_master VALUES("314","3","Edit Diagnosis","0","0","1","0","0","2018-07-25 17:07:42","");
INSERT INTO tbl_role_master VALUES("315","3","Delete Diagnosis","0","0","1","0","0","2018-07-25 17:07:49","");
INSERT INTO tbl_role_master VALUES("316","3","Show Vital Parameters","0","0","1","0","0","2018-07-25 17:07:56","");
INSERT INTO tbl_role_master VALUES("317","3","Add Vital Parameters","0","0","1","0","0","2018-07-25 17:08:03","");
INSERT INTO tbl_role_master VALUES("318","3","Edit Vital Parameters","0","0","1","0","0","2018-07-25 17:08:13","");
INSERT INTO tbl_role_master VALUES("319","3","Show Treatment Sheet","0","0","1","0","0","2018-07-25 17:08:22","");
INSERT INTO tbl_role_master VALUES("320","3","Add Treatment Sheet","0","0","1","0","0","2018-07-25 17:08:30","");
INSERT INTO tbl_role_master VALUES("321","3","Edit Treatment Sheet","0","0","1","0","0","2018-07-25 17:08:36","");
INSERT INTO tbl_role_master VALUES("322","3","Delete Treatment Sheet","0","0","1","0","0","2018-07-25 17:08:43","");
INSERT INTO tbl_role_master VALUES("323","3","Show Extra Order","0","0","1","0","0","2018-07-25 17:08:50","");
INSERT INTO tbl_role_master VALUES("324","3","Add Extra Order","0","0","1","0","0","2018-07-25 17:08:57","");
INSERT INTO tbl_role_master VALUES("325","3","Edit Extra Order","0","0","1","0","0","2018-07-25 17:09:06","");
INSERT INTO tbl_role_master VALUES("326","3","Delete Extra Order","0","0","1","0","0","2018-07-25 17:09:12","");
INSERT INTO tbl_role_master VALUES("327","3","Show Procedure","0","0","1","0","0","2018-07-25 17:09:18","");
INSERT INTO tbl_role_master VALUES("328","3","Add Procedure","0","0","1","0","0","2018-07-25 17:09:23","");
INSERT INTO tbl_role_master VALUES("329","3","Edit Procedure","0","0","1","0","0","2018-07-25 17:09:34","");
INSERT INTO tbl_role_master VALUES("330","3","Show Doctor Notes","0","0","1","0","0","2018-07-25 17:09:40","");
INSERT INTO tbl_role_master VALUES("331","3","Add Doctor Notes","0","0","1","0","0","2018-07-25 17:09:46","");
INSERT INTO tbl_role_master VALUES("332","3","Edit Doctor Notes","0","0","1","0","0","2018-07-25 17:09:54","");
INSERT INTO tbl_role_master VALUES("333","3","Show Nurse Notes","0","0","1","0","0","2018-07-25 17:10:01","");
INSERT INTO tbl_role_master VALUES("334","3","Add Nurse Notes","0","0","1","0","0","2018-07-25 17:10:08","");
INSERT INTO tbl_role_master VALUES("335","3","Edit Nurse Notes","0","0","1","0","0","2018-07-25 17:10:15","");
INSERT INTO tbl_role_master VALUES("336","3","Show Lab Report","0","0","1","0","0","2018-07-25 17:10:31","");
INSERT INTO tbl_role_master VALUES("337","3","Add Lab Report","0","0","1","0","0","2018-07-25 17:10:38","");
INSERT INTO tbl_role_master VALUES("338","3","Edit Lab Report","0","0","1","0","0","2018-07-25 17:10:43","");
INSERT INTO tbl_role_master VALUES("339","3","Show Radiology Report","0","0","1","0","0","2018-07-25 17:10:55","");
INSERT INTO tbl_role_master VALUES("340","3","Add Radiology Report","0","0","1","0","0","2018-07-25 17:11:00","");
INSERT INTO tbl_role_master VALUES("341","3","Edit Radiology Report","0","0","1","0","0","2018-07-25 17:11:05","");
INSERT INTO tbl_role_master VALUES("342","3","Show Documents","0","0","1","0","0","2018-07-25 17:11:17","");
INSERT INTO tbl_role_master VALUES("343","3","Add Documents","0","0","1","0","0","2018-07-25 17:11:23","");
INSERT INTO tbl_role_master VALUES("344","3","Delete Documents","0","0","1","0","0","2018-07-25 17:11:29","");
INSERT INTO tbl_role_master VALUES("345","3","Show Doctor Billing Sheet","0","0","1","0","0","2018-07-25 17:11:44","");
INSERT INTO tbl_role_master VALUES("346","3","Add Doctor Billing Sheet","0","0","1","0","0","2018-07-25 17:11:50","");
INSERT INTO tbl_role_master VALUES("347","3","Edit Doctor Billing Sheet","0","0","1","0","0","2018-07-25 17:11:56","");
INSERT INTO tbl_role_master VALUES("348","3","Delete Doctor Billing Sheet","0","0","1","0","0","2018-07-25 17:12:01","");
INSERT INTO tbl_role_master VALUES("349","3","Show Nurse Billing Sheet","0","0","1","0","0","2018-07-25 17:12:17","");
INSERT INTO tbl_role_master VALUES("350","3","Add Nurse Billing Sheet","0","0","1","0","0","2018-07-25 17:12:21","");
INSERT INTO tbl_role_master VALUES("351","3","Edit Nurse Billing Sheet","0","0","1","0","0","2018-07-25 17:12:26","");
INSERT INTO tbl_role_master VALUES("352","3","Delete Nurse Billing Sheet","0","0","1","0","0","2018-07-25 17:12:32","");
INSERT INTO tbl_role_master VALUES("353","3","Show Discharge Summery ","0","0","1","0","0","2018-07-25 17:12:56","");
INSERT INTO tbl_role_master VALUES("354","3","Add Discharge Summery","0","0","1","0","0","2018-07-25 17:13:03","");
INSERT INTO tbl_role_master VALUES("355","3","Show Patient Activity","0","0","1","0","0","2018-07-25 17:13:10","");
INSERT INTO tbl_role_master VALUES("356","2","Print Document","0","0","1","0","0","2018-11-15 10:31:53","");
INSERT INTO tbl_role_master VALUES("357","6","Print Document","0","0","1","0","0","2018-11-15 10:32:45","");
INSERT INTO tbl_role_master VALUES("358","6","Add Patient","0","0","1","0","0","2018-11-15 11:51:23","");
INSERT INTO tbl_role_master VALUES("359","11","Show Diagnosis","0","0","1","0","0","2019-02-07 15:03:59","");
INSERT INTO tbl_role_master VALUES("360","11","Add Diagnosis","0","0","1","0","0","2019-02-07 15:03:59","");
INSERT INTO tbl_role_master VALUES("361","11","Edit (Own) Diagnosis","0","0","1","0","0","2019-02-07 15:03:59","");
INSERT INTO tbl_role_master VALUES("362","2","Create Bill","0","0","1","0","0","2019-02-07 15:03:59","");
INSERT INTO tbl_role_master VALUES("363","11","Create Bill","0","0","1","0","0","2019-02-07 15:03:59","");
INSERT INTO tbl_role_master VALUES("364","7","Add Patient","0","0","1","0","0","2019-03-04 12:12:50","");
INSERT INTO tbl_role_master VALUES("365","7","View Daily vaccine","0","0","1","0","0","2019-03-04 12:12:50","");
INSERT INTO tbl_role_master VALUES("366","7","View Vaccination Dashboard","0","0","1","0","0","2019-03-04 12:12:50","");
INSERT INTO tbl_role_master VALUES("367","7","Create Bill","0","0","1","0","0","2019-03-04 12:12:50","");
INSERT INTO tbl_role_master VALUES("368","7","Delete Appointment","0","0","1","0","0","2019-02-19 16:41:13","");
INSERT INTO tbl_role_master VALUES("369","6","Export Data","0","0","1","0","0","2019-02-19 16:41:13","");



DROP TABLE tbl_schedule_duration;

CREATE TABLE `tbl_schedule_duration` (
  `tsd_id` int(11) NOT NULL AUTO_INCREMENT,
  `tsd_value` int(11) NOT NULL,
  `tsd_name` varchar(150) NOT NULL,
  PRIMARY KEY (`tsd_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

INSERT INTO tbl_schedule_duration VALUES("1","5","5 Minute");
INSERT INTO tbl_schedule_duration VALUES("2","10","10 Minute");
INSERT INTO tbl_schedule_duration VALUES("3","15","15 Minute");
INSERT INTO tbl_schedule_duration VALUES("4","20","20 Minute");
INSERT INTO tbl_schedule_duration VALUES("5","25","25 Minute");
INSERT INTO tbl_schedule_duration VALUES("6","30","30 Minute");
INSERT INTO tbl_schedule_duration VALUES("7","35","35 Minute");
INSERT INTO tbl_schedule_duration VALUES("8","40","40 Minute");
INSERT INTO tbl_schedule_duration VALUES("9","45","45 Minute");
INSERT INTO tbl_schedule_duration VALUES("10","50","50 Minute");
INSERT INTO tbl_schedule_duration VALUES("11","55","55 Minute");
INSERT INTO tbl_schedule_duration VALUES("12","60","60 Minute");
INSERT INTO tbl_schedule_duration VALUES("13","75","75 Minute");
INSERT INTO tbl_schedule_duration VALUES("14","90","90 Minute");
INSERT INTO tbl_schedule_duration VALUES("15","105","105 Minute");
INSERT INTO tbl_schedule_duration VALUES("16","120","120 Minute");



DROP TABLE tbl_schedule_msg;

CREATE TABLE `tbl_schedule_msg` (
  `tsm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` varchar(150) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `tsm_schedule_val` text,
  `tsm_treatment_day` text,
  `tsm_auto_day` text,
  `tsm_created_by` int(11) DEFAULT NULL,
  `tsm_modify_by` int(11) DEFAULT NULL,
  `tsm_delete_by` int(11) DEFAULT NULL,
  `tsm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tsm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tsm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO tbl_schedule_msg VALUES("1","1,2","1","manual","1","1","1","","","2018-09-05 10:07:07","");
INSERT INTO tbl_schedule_msg VALUES("2","1","1","manual","1","1","1","","","2018-12-29 10:04:24","");
INSERT INTO tbl_schedule_msg VALUES("3","1","2","manual","1","1","1","","","2018-12-29 10:06:13","");



DROP TABLE tbl_schedule_time;

CREATE TABLE `tbl_schedule_time` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=286 DEFAULT CHARSET=latin1;

INSERT INTO tbl_schedule_time VALUES("1","00:00 AM");
INSERT INTO tbl_schedule_time VALUES("2","00:05 AM");
INSERT INTO tbl_schedule_time VALUES("3","00:10 AM");
INSERT INTO tbl_schedule_time VALUES("4","00:15 AM");
INSERT INTO tbl_schedule_time VALUES("5","00:20 AM");
INSERT INTO tbl_schedule_time VALUES("6","00:25 AM");
INSERT INTO tbl_schedule_time VALUES("7","00:30 AM");
INSERT INTO tbl_schedule_time VALUES("8","00:35 AM");
INSERT INTO tbl_schedule_time VALUES("9","00:40 AM");
INSERT INTO tbl_schedule_time VALUES("10","00:45 AM");
INSERT INTO tbl_schedule_time VALUES("11","00:50 AM");
INSERT INTO tbl_schedule_time VALUES("12","00:55 AM");
INSERT INTO tbl_schedule_time VALUES("13","01:00 AM");
INSERT INTO tbl_schedule_time VALUES("14","01:05 AM");
INSERT INTO tbl_schedule_time VALUES("15","01:10 AM");
INSERT INTO tbl_schedule_time VALUES("16","01:15 AM");
INSERT INTO tbl_schedule_time VALUES("17","01:20 AM");
INSERT INTO tbl_schedule_time VALUES("18","01:25 AM");
INSERT INTO tbl_schedule_time VALUES("19","01:30 AM");
INSERT INTO tbl_schedule_time VALUES("20","01:35 AM");
INSERT INTO tbl_schedule_time VALUES("21","01:40 AM");
INSERT INTO tbl_schedule_time VALUES("22","01:45 AM");
INSERT INTO tbl_schedule_time VALUES("23","01:50 AM");
INSERT INTO tbl_schedule_time VALUES("24","01:55 AM");
INSERT INTO tbl_schedule_time VALUES("25","02:00 AM");
INSERT INTO tbl_schedule_time VALUES("26","02:05 AM");
INSERT INTO tbl_schedule_time VALUES("27","02:10 AM");
INSERT INTO tbl_schedule_time VALUES("28","02:15 AM");
INSERT INTO tbl_schedule_time VALUES("29","02:20 AM");
INSERT INTO tbl_schedule_time VALUES("30","02:25 AM");
INSERT INTO tbl_schedule_time VALUES("31","02:30 AM");
INSERT INTO tbl_schedule_time VALUES("32","02:35 AM");
INSERT INTO tbl_schedule_time VALUES("33","02:40 AM");
INSERT INTO tbl_schedule_time VALUES("34","02:45 AM");
INSERT INTO tbl_schedule_time VALUES("35","02:50 AM");
INSERT INTO tbl_schedule_time VALUES("36","02:55 AM");
INSERT INTO tbl_schedule_time VALUES("37","03:00 AM");
INSERT INTO tbl_schedule_time VALUES("38","03:05 AM");
INSERT INTO tbl_schedule_time VALUES("39","03:10 AM");
INSERT INTO tbl_schedule_time VALUES("40","03:15 AM");
INSERT INTO tbl_schedule_time VALUES("41","03:20 AM");
INSERT INTO tbl_schedule_time VALUES("42","03:25 AM");
INSERT INTO tbl_schedule_time VALUES("43","03:30 AM");
INSERT INTO tbl_schedule_time VALUES("44","03:35 AM");
INSERT INTO tbl_schedule_time VALUES("45","03:40 AM");
INSERT INTO tbl_schedule_time VALUES("46","03:45 AM");
INSERT INTO tbl_schedule_time VALUES("47","03:50 AM");
INSERT INTO tbl_schedule_time VALUES("48","03:55 AM");
INSERT INTO tbl_schedule_time VALUES("49","04:00 AM");
INSERT INTO tbl_schedule_time VALUES("50","04:05 AM");
INSERT INTO tbl_schedule_time VALUES("51","04:10 AM");
INSERT INTO tbl_schedule_time VALUES("52","04:15 AM");
INSERT INTO tbl_schedule_time VALUES("53","04:20 AM");
INSERT INTO tbl_schedule_time VALUES("54","04:25 AM");
INSERT INTO tbl_schedule_time VALUES("55","04:30 AM");
INSERT INTO tbl_schedule_time VALUES("56","04:35 AM");
INSERT INTO tbl_schedule_time VALUES("57","04:40 AM");
INSERT INTO tbl_schedule_time VALUES("58","04:45 AM");
INSERT INTO tbl_schedule_time VALUES("59","04:50 AM");
INSERT INTO tbl_schedule_time VALUES("60","04:55 AM");
INSERT INTO tbl_schedule_time VALUES("61","05:00 AM");
INSERT INTO tbl_schedule_time VALUES("62","05:05 AM");
INSERT INTO tbl_schedule_time VALUES("63","05:10 AM");
INSERT INTO tbl_schedule_time VALUES("64","05:15 AM");
INSERT INTO tbl_schedule_time VALUES("65","05:20 AM");
INSERT INTO tbl_schedule_time VALUES("66","05:25 AM");
INSERT INTO tbl_schedule_time VALUES("67","05:30 AM");
INSERT INTO tbl_schedule_time VALUES("68","05:35 AM");
INSERT INTO tbl_schedule_time VALUES("69","05:40 AM");
INSERT INTO tbl_schedule_time VALUES("70","05:45 AM");
INSERT INTO tbl_schedule_time VALUES("71","05:55 AM");
INSERT INTO tbl_schedule_time VALUES("72","06:00 AM");
INSERT INTO tbl_schedule_time VALUES("73","06:05 AM");
INSERT INTO tbl_schedule_time VALUES("74","06:10 AM");
INSERT INTO tbl_schedule_time VALUES("75","06:15 AM");
INSERT INTO tbl_schedule_time VALUES("76","06:20 AM");
INSERT INTO tbl_schedule_time VALUES("77","06:25 AM");
INSERT INTO tbl_schedule_time VALUES("78","06:30 AM");
INSERT INTO tbl_schedule_time VALUES("79","06:35 AM");
INSERT INTO tbl_schedule_time VALUES("80","06:40 AM");
INSERT INTO tbl_schedule_time VALUES("81","06:45 AM");
INSERT INTO tbl_schedule_time VALUES("82","06:50 AM");
INSERT INTO tbl_schedule_time VALUES("83","06:55 AM");
INSERT INTO tbl_schedule_time VALUES("84","07:00 AM");
INSERT INTO tbl_schedule_time VALUES("85","07:05 AM");
INSERT INTO tbl_schedule_time VALUES("86","07:10 AM");
INSERT INTO tbl_schedule_time VALUES("87","07:15 AM");
INSERT INTO tbl_schedule_time VALUES("88","07:20 AM");
INSERT INTO tbl_schedule_time VALUES("89","07:25 AM");
INSERT INTO tbl_schedule_time VALUES("90","07:30 AM");
INSERT INTO tbl_schedule_time VALUES("91","07:35 AM");
INSERT INTO tbl_schedule_time VALUES("92","07:40 AM");
INSERT INTO tbl_schedule_time VALUES("93","07:45 AM");
INSERT INTO tbl_schedule_time VALUES("94","07:50 AM");
INSERT INTO tbl_schedule_time VALUES("95","07:55 AM");
INSERT INTO tbl_schedule_time VALUES("96","08:00 AM");
INSERT INTO tbl_schedule_time VALUES("97","08:05 AM");
INSERT INTO tbl_schedule_time VALUES("98","08:10 AM");
INSERT INTO tbl_schedule_time VALUES("99","08:15 AM");
INSERT INTO tbl_schedule_time VALUES("100","08:20 AM");
INSERT INTO tbl_schedule_time VALUES("101","08:25 AM");
INSERT INTO tbl_schedule_time VALUES("102","08:30 AM");
INSERT INTO tbl_schedule_time VALUES("103","08:35 AM");
INSERT INTO tbl_schedule_time VALUES("104","08:40 AM");
INSERT INTO tbl_schedule_time VALUES("105","08:45 AM");
INSERT INTO tbl_schedule_time VALUES("106","08:50 AM");
INSERT INTO tbl_schedule_time VALUES("107","08:55 AM");
INSERT INTO tbl_schedule_time VALUES("108","09:00 AM");
INSERT INTO tbl_schedule_time VALUES("109","09:05 AM");
INSERT INTO tbl_schedule_time VALUES("110","09:10 AM");
INSERT INTO tbl_schedule_time VALUES("111","09:15 AM");
INSERT INTO tbl_schedule_time VALUES("112","09:20 AM");
INSERT INTO tbl_schedule_time VALUES("113","09:25 AM");
INSERT INTO tbl_schedule_time VALUES("114","09:30 AM");
INSERT INTO tbl_schedule_time VALUES("115","09:35 AM");
INSERT INTO tbl_schedule_time VALUES("116","09:40 AM");
INSERT INTO tbl_schedule_time VALUES("117","09:45 AM");
INSERT INTO tbl_schedule_time VALUES("118","09:50 AM");
INSERT INTO tbl_schedule_time VALUES("119","09:55 AM");
INSERT INTO tbl_schedule_time VALUES("120","10:00 AM");
INSERT INTO tbl_schedule_time VALUES("121","10:05 AM");
INSERT INTO tbl_schedule_time VALUES("122","10:10 AM");
INSERT INTO tbl_schedule_time VALUES("123","10:15 AM");
INSERT INTO tbl_schedule_time VALUES("124","10:20 AM");
INSERT INTO tbl_schedule_time VALUES("125","10:25 AM");
INSERT INTO tbl_schedule_time VALUES("126","10:30 AM");
INSERT INTO tbl_schedule_time VALUES("127","10:35 AM");
INSERT INTO tbl_schedule_time VALUES("128","10:40 AM");
INSERT INTO tbl_schedule_time VALUES("129","10:45 AM");
INSERT INTO tbl_schedule_time VALUES("130","10:50 AM");
INSERT INTO tbl_schedule_time VALUES("131","10:55 AM");
INSERT INTO tbl_schedule_time VALUES("132","11:00 AM");
INSERT INTO tbl_schedule_time VALUES("133","11:05 AM");
INSERT INTO tbl_schedule_time VALUES("134","11:10 AM");
INSERT INTO tbl_schedule_time VALUES("135","11:15 AM");
INSERT INTO tbl_schedule_time VALUES("136","11:20 AM");
INSERT INTO tbl_schedule_time VALUES("137","11:25 AM");
INSERT INTO tbl_schedule_time VALUES("138","11:30 AM");
INSERT INTO tbl_schedule_time VALUES("139","11:35 AM");
INSERT INTO tbl_schedule_time VALUES("140","11:40 AM");
INSERT INTO tbl_schedule_time VALUES("141","11:45 AM");
INSERT INTO tbl_schedule_time VALUES("142","11:50 AM");
INSERT INTO tbl_schedule_time VALUES("143","11:55 AM");
INSERT INTO tbl_schedule_time VALUES("144","12:00 PM");
INSERT INTO tbl_schedule_time VALUES("145","12:05 PM");
INSERT INTO tbl_schedule_time VALUES("146","12:10 PM");
INSERT INTO tbl_schedule_time VALUES("147","12:15 PM");
INSERT INTO tbl_schedule_time VALUES("148","12:20 PM");
INSERT INTO tbl_schedule_time VALUES("149","12:25 PM");
INSERT INTO tbl_schedule_time VALUES("150","12:30 PM");
INSERT INTO tbl_schedule_time VALUES("151","12:35 PM");
INSERT INTO tbl_schedule_time VALUES("152","12:40 PM");
INSERT INTO tbl_schedule_time VALUES("153","12:45 PM");
INSERT INTO tbl_schedule_time VALUES("154","12:55 PM");
INSERT INTO tbl_schedule_time VALUES("155","01:00 PM");
INSERT INTO tbl_schedule_time VALUES("156","01:05 PM");
INSERT INTO tbl_schedule_time VALUES("157","01:10 PM");
INSERT INTO tbl_schedule_time VALUES("158","01:15 PM");
INSERT INTO tbl_schedule_time VALUES("159","01:20 PM");
INSERT INTO tbl_schedule_time VALUES("160","01:25 PM");
INSERT INTO tbl_schedule_time VALUES("161","01:30 PM");
INSERT INTO tbl_schedule_time VALUES("162","01:35 PM");
INSERT INTO tbl_schedule_time VALUES("163","01:40 PM");
INSERT INTO tbl_schedule_time VALUES("164","01:45 PM");
INSERT INTO tbl_schedule_time VALUES("165","01:50 PM");
INSERT INTO tbl_schedule_time VALUES("166","01:55 PM");
INSERT INTO tbl_schedule_time VALUES("167","02:00 PM");
INSERT INTO tbl_schedule_time VALUES("168","02:05 PM");
INSERT INTO tbl_schedule_time VALUES("169","02:10 PM");
INSERT INTO tbl_schedule_time VALUES("170","02:15 PM");
INSERT INTO tbl_schedule_time VALUES("171","02:20 PM");
INSERT INTO tbl_schedule_time VALUES("172","02:25 PM");
INSERT INTO tbl_schedule_time VALUES("173","02:30 PM");
INSERT INTO tbl_schedule_time VALUES("174","02:35 PM");
INSERT INTO tbl_schedule_time VALUES("175","02:40 PM");
INSERT INTO tbl_schedule_time VALUES("176","02:45 PM");
INSERT INTO tbl_schedule_time VALUES("177","02:50 PM");
INSERT INTO tbl_schedule_time VALUES("178","02:55 PM");
INSERT INTO tbl_schedule_time VALUES("179","03:00 PM");
INSERT INTO tbl_schedule_time VALUES("180","03:05 PM");
INSERT INTO tbl_schedule_time VALUES("181","03:10 PM");
INSERT INTO tbl_schedule_time VALUES("182","03:15 PM");
INSERT INTO tbl_schedule_time VALUES("183","03:20 PM");
INSERT INTO tbl_schedule_time VALUES("184","03:25 PM");
INSERT INTO tbl_schedule_time VALUES("185","03:30 PM");
INSERT INTO tbl_schedule_time VALUES("186","03:35 PM");
INSERT INTO tbl_schedule_time VALUES("187","03:40 PM");
INSERT INTO tbl_schedule_time VALUES("188","03:45 PM");
INSERT INTO tbl_schedule_time VALUES("189","03:50 PM");
INSERT INTO tbl_schedule_time VALUES("190","03:55 PM");
INSERT INTO tbl_schedule_time VALUES("191","04:00 PM");
INSERT INTO tbl_schedule_time VALUES("192","04:05 PM");
INSERT INTO tbl_schedule_time VALUES("193","04:10 PM");
INSERT INTO tbl_schedule_time VALUES("194","04:15 PM");
INSERT INTO tbl_schedule_time VALUES("195","04:20 PM");
INSERT INTO tbl_schedule_time VALUES("196","04:25 PM");
INSERT INTO tbl_schedule_time VALUES("197","04:30 PM");
INSERT INTO tbl_schedule_time VALUES("198","04:35 PM");
INSERT INTO tbl_schedule_time VALUES("199","04:40 PM");
INSERT INTO tbl_schedule_time VALUES("200","04:45 PM");
INSERT INTO tbl_schedule_time VALUES("201","04:50 PM");
INSERT INTO tbl_schedule_time VALUES("202","04:55 PM");
INSERT INTO tbl_schedule_time VALUES("203","05:00 PM");
INSERT INTO tbl_schedule_time VALUES("204","05:05 PM");
INSERT INTO tbl_schedule_time VALUES("205","05:10 PM");
INSERT INTO tbl_schedule_time VALUES("206","05:15 PM");
INSERT INTO tbl_schedule_time VALUES("207","05:20 PM");
INSERT INTO tbl_schedule_time VALUES("208","05:25 PM");
INSERT INTO tbl_schedule_time VALUES("209","05:30 PM");
INSERT INTO tbl_schedule_time VALUES("210","05:35 PM");
INSERT INTO tbl_schedule_time VALUES("211","05:40 PM");
INSERT INTO tbl_schedule_time VALUES("212","05:45 PM");
INSERT INTO tbl_schedule_time VALUES("213","05:55 PM");
INSERT INTO tbl_schedule_time VALUES("214","06:00 PM");
INSERT INTO tbl_schedule_time VALUES("215","06:05 PM");
INSERT INTO tbl_schedule_time VALUES("216","06:10 PM");
INSERT INTO tbl_schedule_time VALUES("217","06:15 PM");
INSERT INTO tbl_schedule_time VALUES("218","06:20 PM");
INSERT INTO tbl_schedule_time VALUES("219","06:25 PM");
INSERT INTO tbl_schedule_time VALUES("220","06:30 PM");
INSERT INTO tbl_schedule_time VALUES("221","06:35 PM");
INSERT INTO tbl_schedule_time VALUES("222","06:40 PM");
INSERT INTO tbl_schedule_time VALUES("223","06:45 PM");
INSERT INTO tbl_schedule_time VALUES("224","06:50 PM");
INSERT INTO tbl_schedule_time VALUES("225","06:55 PM");
INSERT INTO tbl_schedule_time VALUES("226","07:00 PM");
INSERT INTO tbl_schedule_time VALUES("227","07:05 PM");
INSERT INTO tbl_schedule_time VALUES("228","07:10 PM");
INSERT INTO tbl_schedule_time VALUES("229","07:15 PM");
INSERT INTO tbl_schedule_time VALUES("230","07:20 PM");
INSERT INTO tbl_schedule_time VALUES("231","07:25 PM");
INSERT INTO tbl_schedule_time VALUES("232","07:30 PM");
INSERT INTO tbl_schedule_time VALUES("233","07:35 PM");
INSERT INTO tbl_schedule_time VALUES("234","07:40 PM");
INSERT INTO tbl_schedule_time VALUES("235","07:45 PM");
INSERT INTO tbl_schedule_time VALUES("236","07:50 PM");
INSERT INTO tbl_schedule_time VALUES("237","07:55 PM");
INSERT INTO tbl_schedule_time VALUES("238","08:00 PM");
INSERT INTO tbl_schedule_time VALUES("239","08:05 PM");
INSERT INTO tbl_schedule_time VALUES("240","08:10 PM");
INSERT INTO tbl_schedule_time VALUES("241","08:15 PM");
INSERT INTO tbl_schedule_time VALUES("242","08:20 PM");
INSERT INTO tbl_schedule_time VALUES("243","08:25 PM");
INSERT INTO tbl_schedule_time VALUES("244","08:30 PM");
INSERT INTO tbl_schedule_time VALUES("245","08:35 PM");
INSERT INTO tbl_schedule_time VALUES("246","08:40 PM");
INSERT INTO tbl_schedule_time VALUES("247","08:45 PM");
INSERT INTO tbl_schedule_time VALUES("248","08:50 PM");
INSERT INTO tbl_schedule_time VALUES("249","08:55 PM");
INSERT INTO tbl_schedule_time VALUES("250","09:00 PM");
INSERT INTO tbl_schedule_time VALUES("251","09:05 PM");
INSERT INTO tbl_schedule_time VALUES("252","09:10 PM");
INSERT INTO tbl_schedule_time VALUES("253","09:15 PM");
INSERT INTO tbl_schedule_time VALUES("254","09:20 PM");
INSERT INTO tbl_schedule_time VALUES("255","09:25 PM");
INSERT INTO tbl_schedule_time VALUES("256","09:30 PM");
INSERT INTO tbl_schedule_time VALUES("257","09:35 PM");
INSERT INTO tbl_schedule_time VALUES("258","09:40 PM");
INSERT INTO tbl_schedule_time VALUES("259","09:45 PM");
INSERT INTO tbl_schedule_time VALUES("260","09:50 PM");
INSERT INTO tbl_schedule_time VALUES("261","09:55 PM");
INSERT INTO tbl_schedule_time VALUES("262","10:00 PM");
INSERT INTO tbl_schedule_time VALUES("263","10:05 PM");
INSERT INTO tbl_schedule_time VALUES("264","10:10 PM");
INSERT INTO tbl_schedule_time VALUES("265","10:15 PM");
INSERT INTO tbl_schedule_time VALUES("266","10:20 PM");
INSERT INTO tbl_schedule_time VALUES("267","10:25 PM");
INSERT INTO tbl_schedule_time VALUES("268","10:30 PM");
INSERT INTO tbl_schedule_time VALUES("269","10:35 PM");
INSERT INTO tbl_schedule_time VALUES("270","10:40 PM");
INSERT INTO tbl_schedule_time VALUES("271","10:45 PM");
INSERT INTO tbl_schedule_time VALUES("272","10:50 PM");
INSERT INTO tbl_schedule_time VALUES("273","10:55 PM");
INSERT INTO tbl_schedule_time VALUES("274","11:00 PM");
INSERT INTO tbl_schedule_time VALUES("275","11:05 PM");
INSERT INTO tbl_schedule_time VALUES("276","11:10 PM");
INSERT INTO tbl_schedule_time VALUES("277","11:15 PM");
INSERT INTO tbl_schedule_time VALUES("278","11:20 PM");
INSERT INTO tbl_schedule_time VALUES("279","11:25 PM");
INSERT INTO tbl_schedule_time VALUES("280","11:30 PM");
INSERT INTO tbl_schedule_time VALUES("281","11:35 PM");
INSERT INTO tbl_schedule_time VALUES("282","11:40 PM");
INSERT INTO tbl_schedule_time VALUES("283","11:45 PM");
INSERT INTO tbl_schedule_time VALUES("284","11:50 PM");
INSERT INTO tbl_schedule_time VALUES("285","11:55 PM");



DROP TABLE tbl_service_billing_master;

CREATE TABLE `tbl_service_billing_master` (
  `sbm_id` int(11) NOT NULL,
  `sbm_hm_id` int(11) DEFAULT NULL,
  `sbm_um_id` int(11) DEFAULT NULL,
  `sbm_service_name` varchar(250) DEFAULT NULL,
  `sbm_price` double DEFAULT NULL,
  `sbm_note` varchar(250) DEFAULT NULL,
  `sbm_del` int(11) DEFAULT NULL,
  `sbm_created_by` int(11) DEFAULT NULL,
  `sbm_modify_by` int(11) DEFAULT NULL,
  `sbm_delete_by` int(11) DEFAULT NULL,
  `sbm_created_date` datetime DEFAULT NULL,
  `sbm_modify_date` datetime DEFAULT NULL,
  PRIMARY KEY (`sbm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_sms;

CREATE TABLE `tbl_sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` bigint(20) DEFAULT NULL,
  `sms` longtext,
  `active_sms` varchar(21) NOT NULL DEFAULT 'Y',
  `orderby` int(21) NOT NULL DEFAULT '0',
  `created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;

INSERT INTO tbl_sms VALUES("2","0","Dear {patient name} Welcome to {Hospital name}. Your patient ID is {patient id}. In case of queries, call us on {hospital phone 1} or {hospital phone 2}.","N","1","2018-08-07 15:01:25");
INSERT INTO tbl_sms VALUES("3","1","Dear {patient name} Welcome to {Hospital name}. Your patient ID is {patient id}. In case of queries, call us on {hospital phone 1} or {hospital phone 2}.","N","2","2018-08-07 15:50:19");
INSERT INTO tbl_sms VALUES("4","4","Dear, {patient name} Your appointment at {appointment time} on {appointment date} is cancelled at {Hospital name}.","N","3","2018-08-07 16:41:47");
INSERT INTO tbl_sms VALUES("5","5","","N","10","2018-08-07 16:41:47");
INSERT INTO tbl_sms VALUES("6","6","","N","5","2018-12-13 10:30:02");
INSERT INTO tbl_sms VALUES("7","7","","N","6","2018-12-13 10:30:16");
INSERT INTO tbl_sms VALUES("8","8","","N","7","2018-12-13 10:30:22");
INSERT INTO tbl_sms VALUES("12","12","","N","9","2018-12-13 10:31:01");
INSERT INTO tbl_sms VALUES("13","13","","N","11","2018-12-13 10:31:09");
INSERT INTO tbl_sms VALUES("14","14"," ","N","4","2018-12-13 14:51:09");
INSERT INTO tbl_sms VALUES("16","15","","N","12","2018-08-07 16:41:47");
INSERT INTO tbl_sms VALUES("17","16","Dear {patient name},Your vaccine is due tomorrow. Please visit {Hospital name}.","N","13","2019-02-07 15:03:59");
INSERT INTO tbl_sms VALUES("18","17","Thank you for referring {patient name}. Regards {doctor name} Founder {Hospital name}.","N","14","2019-02-07 15:03:59");
INSERT INTO tbl_sms VALUES("19","18","You have a new appointment today at {appointment time} on {appointment date} at {Hospital name}.","N","15","2019-02-07 15:03:59");
INSERT INTO tbl_sms VALUES("23","19","Thank you for referring {patient name}. Regards {admitting doctor} Founder {Hospital name}.","N","19","2019-03-04 12:12:36");
INSERT INTO tbl_sms VALUES("24","20","Happy Birthday {patient name}.  Regards {Hospital name}.","Y","20","2019-01-21 13:31:25");



DROP TABLE tbl_supplier;

CREATE TABLE `tbl_supplier` (
  `ts_id` int(11) NOT NULL AUTO_INCREMENT,
  `pharma_id` int(11) NOT NULL DEFAULT '0',
  `ts_supp_id` text NOT NULL,
  `ts_name` varchar(350) NOT NULL,
  `ts_gst_no` varchar(350) NOT NULL,
  `ts_address` varchar(500) NOT NULL,
  `ts_phone_no` varchar(150) NOT NULL,
  `ts_email` varchar(500) NOT NULL,
  `ts_del` int(11) NOT NULL DEFAULT '0',
  `ts_create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ts_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_supplier_account;

CREATE TABLE `tbl_supplier_account` (
  `tsa_id` int(11) NOT NULL AUTO_INCREMENT,
  `pharma_id` int(11) NOT NULL DEFAULT '0',
  `hm_id` int(11) NOT NULL,
  `um_id` int(11) NOT NULL,
  `ts_supp_id` text NOT NULL,
  `tppi_id` text NOT NULL,
  `tsa_amt` text,
  `tsa_note` varchar(250) NOT NULL,
  `tsa_date` date DEFAULT NULL,
  `tsa_del` int(11) DEFAULT NULL,
  `tsa_created_by` int(11) NOT NULL,
  `tsa_modify_by` int(11) NOT NULL,
  `tsa_delete_by` int(11) NOT NULL,
  `tsa_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tsa_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tsa_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_todo_notes;

CREATE TABLE `tbl_todo_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `recordListingID` int(11) NOT NULL DEFAULT '0',
  `notes` longtext,
  `check_val` int(11) NOT NULL DEFAULT '0',
  `del` int(11) NOT NULL DEFAULT '0',
  `created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_user_assignment;

CREATE TABLE `tbl_user_assignment` (
  `ua_id` bigint(21) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `um_id` int(11) DEFAULT NULL,
  `mm_id` int(11) DEFAULT NULL,
  `rm_id` int(11) DEFAULT NULL,
  `ua_status` int(11) DEFAULT NULL,
  `ua_created_by` int(11) DEFAULT NULL,
  `ua_modify_by` int(11) DEFAULT NULL,
  `ua_delete_by` int(11) DEFAULT NULL,
  `ua_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ua_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ua_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1351 DEFAULT CHARSET=latin1;

INSERT INTO tbl_user_assignment VALUES("1057","1","1","1","9","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1058","1","1","1","10","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1059","1","1","2","1","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1060","1","1","2","2","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1061","1","1","2","3","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1062","1","1","2","4","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1063","1","1","2","5","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1064","1","1","2","6","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1065","1","1","2","8","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1066","1","1","2","356","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1067","1","1","2","362","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1068","1","1","6","23","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1069","1","1","6","24","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1070","1","1","6","25","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1071","1","1","6","26","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1072","1","1","6","27","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1073","1","1","6","28","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1074","1","1","6","357","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1075","1","1","6","358","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1076","1","1","6","369","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1077","1","1","7","364","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1078","1","1","7","365","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1079","1","1","7","366","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1080","1","1","7","367","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1081","1","1","7","368","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1082","1","1","10","47","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1083","1","1","10","48","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1084","1","1","10","49","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1085","1","1","10","50","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1086","1","1","11","11","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1087","1","1","11","33","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1088","1","1","11","34","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1089","1","1","11","35","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1090","1","1","11","36","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1091","1","1","11","37","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1092","1","1","11","38","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1093","1","1","11","39","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1094","1","1","11","40","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1095","1","1","11","41","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1096","1","1","11","42","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1097","1","1","11","43","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1098","1","1","11","44","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1099","1","1","11","45","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1100","1","1","11","46","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1101","1","1","11","359","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1102","1","1","11","360","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1103","1","1","11","361","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1104","1","1","11","363","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1105","1","1","20","268","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1106","1","1","20","269","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1107","1","1","20","270","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1108","1","1","20","271","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1109","1","1","20","272","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1110","1","1","20","273","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1111","1","1","20","274","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1112","1","1","20","275","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1113","1","1","20","276","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1114","1","1","20","277","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1115","1","1","20","278","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1116","1","1","20","279","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1117","1","1","20","280","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1118","1","1","20","281","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1119","1","1","20","282","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1120","1","1","20","283","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1121","1","1","20","284","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1122","1","1","20","285","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1123","1","1","20","286","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1124","1","1","20","287","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1125","1","1","20","288","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1126","1","1","20","289","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1127","1","1","20","290","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1128","1","1","20","291","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1129","1","1","20","292","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1130","1","1","20","293","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1131","1","1","20","294","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1132","1","1","20","295","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1133","1","1","20","296","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1134","1","1","20","297","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1135","1","1","20","298","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1136","1","1","20","299","1","1","","","2019-03-04 12:39:41","");
INSERT INTO tbl_user_assignment VALUES("1137","1","2","1","9","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1138","1","2","1","10","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1139","1","2","2","1","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1140","1","2","2","2","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1141","1","2","2","3","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1142","1","2","2","4","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1143","1","2","2","5","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1144","1","2","2","6","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1145","1","2","2","8","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1146","1","2","2","356","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1147","1","2","2","362","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1148","1","2","6","23","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1149","1","2","6","24","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1150","1","2","6","25","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1151","1","2","6","26","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1152","1","2","6","27","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1153","1","2","6","28","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1154","1","2","6","357","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1155","1","2","6","358","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1156","1","2","6","369","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1157","1","2","7","364","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1158","1","2","7","365","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1159","1","2","7","366","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1160","1","2","7","367","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1161","1","2","7","368","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1162","1","2","10","47","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1163","1","2","10","48","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1164","1","2","10","49","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1165","1","2","10","50","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1166","1","2","11","11","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1167","1","2","11","33","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1168","1","2","11","34","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1169","1","2","11","35","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1170","1","2","11","36","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1171","1","2","11","37","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1172","1","2","11","38","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1173","1","2","11","39","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1174","1","2","11","40","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1175","1","2","11","41","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1176","1","2","11","42","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1177","1","2","11","43","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1178","1","2","11","44","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1179","1","2","11","45","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1180","1","2","11","46","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1181","1","2","11","359","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1182","1","2","11","360","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1183","1","2","11","361","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1184","1","2","11","363","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1185","1","2","20","268","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1186","1","2","20","269","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1187","1","2","20","270","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1188","1","2","20","271","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1189","1","2","20","272","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1190","1","2","20","273","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1191","1","2","20","274","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1192","1","2","20","275","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1193","1","2","20","276","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1194","1","2","20","277","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1195","1","2","20","278","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1196","1","2","20","279","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1197","1","2","20","280","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1198","1","2","20","281","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1199","1","2","20","282","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1200","1","2","20","283","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1201","1","2","20","284","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1202","1","2","20","285","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1203","1","2","20","286","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1204","1","2","20","287","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1205","1","2","20","288","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1206","1","2","20","289","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1207","1","2","20","290","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1208","1","2","20","291","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1209","1","2","20","292","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1210","1","2","20","293","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1211","1","2","20","294","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1212","1","2","20","295","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1213","1","2","20","296","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1214","1","2","20","297","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1215","1","2","20","298","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1216","1","2","20","299","1","1","","","2019-03-04 12:40:01","");
INSERT INTO tbl_user_assignment VALUES("1217","1","3","1","9","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1218","1","3","1","10","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1219","1","3","2","1","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1220","1","3","2","2","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1221","1","3","2","3","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1222","1","3","2","4","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1223","1","3","2","5","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1224","1","3","2","6","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1225","1","3","2","8","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1226","1","3","2","356","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1227","1","3","2","362","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1228","1","3","6","23","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1229","1","3","6","24","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1230","1","3","6","25","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1231","1","3","6","26","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1232","1","3","6","27","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1233","1","3","6","28","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1234","1","3","6","357","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1235","1","3","6","358","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1236","1","3","6","369","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1237","1","3","7","364","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1238","1","3","7","365","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1239","1","3","7","366","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1240","1","3","7","367","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1241","1","3","7","368","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1242","1","3","10","47","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1243","1","3","10","48","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1244","1","3","10","49","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1245","1","3","10","50","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1246","1","3","11","11","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1247","1","3","11","33","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1248","1","3","11","34","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1249","1","3","11","35","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1250","1","3","11","36","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1251","1","3","11","37","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1252","1","3","11","38","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1253","1","3","11","39","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1254","1","3","11","40","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1255","1","3","11","41","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1256","1","3","11","42","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1257","1","3","11","43","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1258","1","3","11","44","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1259","1","3","11","45","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1260","1","3","11","46","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1261","1","3","11","359","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1262","1","3","11","360","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1263","1","3","11","361","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1264","1","3","11","363","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1265","1","3","20","268","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1266","1","3","20","269","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1267","1","3","20","270","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1268","1","3","20","271","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1269","1","3","20","272","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1270","1","3","20","273","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1271","1","3","20","274","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1272","1","3","20","275","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1273","1","3","20","276","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1274","1","3","20","277","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1275","1","3","20","278","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1276","1","3","20","279","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1277","1","3","20","280","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1278","1","3","20","281","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1279","1","3","20","282","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1280","1","3","20","283","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1281","1","3","20","284","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1282","1","3","20","285","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1283","1","3","20","286","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1284","1","3","20","287","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1285","1","3","20","288","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1286","1","3","20","289","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1287","1","3","20","290","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1288","1","3","20","291","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1289","1","3","20","292","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1290","1","3","20","293","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1291","1","3","20","294","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1292","1","3","20","295","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1293","1","3","20","296","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1294","1","3","20","297","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1295","1","3","20","298","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1296","1","3","20","299","1","1","","","2019-03-04 12:40:12","");
INSERT INTO tbl_user_assignment VALUES("1297","1","4","2","1","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1298","1","4","2","2","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1299","1","4","2","3","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1300","1","4","2","4","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1301","1","4","2","5","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1302","1","4","2","6","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1303","1","4","2","8","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1304","1","4","2","356","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1305","1","4","2","362","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1306","1","4","6","23","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1307","1","4","6","24","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1308","1","4","6","25","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1309","1","4","6","26","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1310","1","4","6","27","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1311","1","4","6","28","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1312","1","4","6","357","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1313","1","4","6","358","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1314","1","4","7","364","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1315","1","4","7","365","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1316","1","4","7","366","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1317","1","4","7","367","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1318","1","4","7","368","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1319","1","4","20","268","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1320","1","4","20","269","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1321","1","4","20","270","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1322","1","4","20","271","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1323","1","4","20","272","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1324","1","4","20","273","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1325","1","4","20","274","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1326","1","4","20","275","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1327","1","4","20","276","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1328","1","4","20","277","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1329","1","4","20","278","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1330","1","4","20","279","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1331","1","4","20","280","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1332","1","4","20","281","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1333","1","4","20","282","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1334","1","4","20","283","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1335","1","4","20","284","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1336","1","4","20","285","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1337","1","4","20","286","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1338","1","4","20","287","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1339","1","4","20","288","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1340","1","4","20","289","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1341","1","4","20","290","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1342","1","4","20","291","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1343","1","4","20","292","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1344","1","4","20","293","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1345","1","4","20","294","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1346","1","4","20","295","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1347","1","4","20","296","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1348","1","4","20","297","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1349","1","4","20","298","1","1","","","2019-03-04 12:40:22","");
INSERT INTO tbl_user_assignment VALUES("1350","1","4","20","299","1","1","","","2019-03-04 12:40:22","");



DROP TABLE tbl_user_casesheet_option;

CREATE TABLE `tbl_user_casesheet_option` (
  `tuco_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `um_id` int(11) NOT NULL,
  `tco_id` varchar(150) DEFAULT NULL,
  `tuco_del` int(11) NOT NULL DEFAULT '0',
  `tuco_created_by` int(11) NOT NULL,
  `tuco_modify_by` int(11) DEFAULT NULL,
  `tuco_delete_by` int(11) DEFAULT NULL,
  `tuco_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tuco_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tuco_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_user_hospital_master;

CREATE TABLE `tbl_user_hospital_master` (
  `tuhm_id` int(11) NOT NULL AUTO_INCREMENT,
  `um_id` int(11) NOT NULL,
  `hm_id` int(11) NOT NULL,
  `mm_id` varchar(150) DEFAULT NULL,
  `home_mm_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tuhm_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1;

INSERT INTO tbl_user_hospital_master VALUES("17","1","1","1,2,6,7,10,11,20","0");
INSERT INTO tbl_user_hospital_master VALUES("18","2","1","1,2,6,7,10,11,20","0");
INSERT INTO tbl_user_hospital_master VALUES("19","3","1","1,2,6,7,10,11,20","0");
INSERT INTO tbl_user_hospital_master VALUES("20","4","1","2,6,7,20","0");



DROP TABLE tbl_user_master;

CREATE TABLE `tbl_user_master` (
  `um_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` varchar(150) NOT NULL,
  `ut_id` int(11) DEFAULT NULL,
  `dp_id` int(11) NOT NULL DEFAULT '0',
  `mm_id` varchar(150) NOT NULL,
  `home_mm_id` int(11) NOT NULL,
  `doctor_id` int(11) NOT NULL DEFAULT '0',
  `opd_hm_id` varchar(150) NOT NULL,
  `opd_dp_id` varchar(150) NOT NULL,
  `admit_hm_id` varchar(150) NOT NULL,
  `admit_dp_id` varchar(150) NOT NULL,
  `pharma_id` int(11) NOT NULL DEFAULT '0',
  `um_name` varchar(150) DEFAULT NULL,
  `um_email` varchar(500) DEFAULT NULL,
  `um_password` varchar(500) DEFAULT NULL,
  `um_contact1` varchar(150) DEFAULT NULL,
  `um_contact2` varchar(150) DEFAULT NULL,
  `um_emailid` varchar(250) NOT NULL,
  `um_image` varchar(500) DEFAULT NULL,
  `gmc_no` varchar(250) NOT NULL,
  `is_admin` int(11) NOT NULL DEFAULT '0',
  `um_default_center` int(11) NOT NULL DEFAULT '0',
  `um_signature_upload` varchar(1000) DEFAULT NULL,
  `um_del` int(11) NOT NULL DEFAULT '0',
  `um_created_by` int(11) DEFAULT NULL,
  `um_modify_by` int(11) DEFAULT NULL,
  `um_delete_by` int(11) NOT NULL DEFAULT '0',
  `um_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `um_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`um_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO tbl_user_master VALUES("1","1","1","9","","0","0","1","9","1","9","0","Dr. Vijay M Patel","vijay","7c5e62fbfc8a62229675265f24ac0c10","8735979272","","vijay@admin.com","icon-user-default1546058064.png","","1","0","","0","1","","0","2018-12-29 10:04:24","");
INSERT INTO tbl_user_master VALUES("2","1","1","9","","0","0","1","9","1","9","0","Dr. Nikita V Patel","nikita","e35effc4046c879e3a94bd0441727f3e","7203830760","","nikita@admin.com","icon-user-default1546058173.png","","1","0","","0","1","","0","2018-12-29 10:06:13","");
INSERT INTO tbl_user_master VALUES("3","1","2","0","","0","0","","","","","0","Admin","admin","e6e061838856bf47e1de730719fb2609","0000000000","","admin@admin.com","icon-user-default1546058247.png","","0","0","","0","1","","0","2018-12-29 10:07:27","");
INSERT INTO tbl_user_master VALUES("4","1","3","0","","0","0","","","","","0","Reception","reception","2682ae65b502c2361a8c145bfb6fafa9","0000000000","","reception@admin.com","icon-user-default1546058291.png","","0","0","","0","1","","0","2018-12-29 10:08:11","");



DROP TABLE tbl_user_medicine_group;

CREATE TABLE `tbl_user_medicine_group` (
  `tumg_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL,
  `um_id` int(11) NOT NULL,
  `pharma_id` int(11) NOT NULL,
  `tpm_id` int(11) NOT NULL DEFAULT '0',
  `tpmg_id` int(11) NOT NULL,
  `tumg_del` int(11) NOT NULL DEFAULT '0',
  `tumg_created_by` int(11) NOT NULL,
  `tumg_modify_by` int(11) DEFAULT NULL,
  `tumg_delete_by` int(11) DEFAULT NULL,
  `tumg_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tumg_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tumg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_user_type;

CREATE TABLE `tbl_user_type` (
  `ut_id` int(11) NOT NULL AUTO_INCREMENT,
  `mm_id` varchar(150) NOT NULL,
  `ut_name` varchar(70) DEFAULT NULL,
  `ut_status` int(11) DEFAULT '0',
  `ut_del` int(11) DEFAULT '0',
  `ut_created_by` int(11) DEFAULT '0',
  `ut_modify_by` int(11) DEFAULT '0',
  `ut_delete_by` int(11) DEFAULT '0',
  `ut_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ut_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ut_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO tbl_user_type VALUES("1","","Doctor","0","0","1","0","0","2018-09-05 09:43:54","");
INSERT INTO tbl_user_type VALUES("2","","Administrator","0","0","1","0","0","2018-09-05 09:50:05","");
INSERT INTO tbl_user_type VALUES("3","","Reception","0","0","1","0","0","2018-09-05 09:52:56","");
INSERT INTO tbl_user_type VALUES("4","","Nurse","0","0","1","0","0","2018-09-05 09:54:57","");
INSERT INTO tbl_user_type VALUES("5","","Pharmacist","0","0","1","0","0","2018-09-05 09:56:08","");



DROP TABLE tbl_usertype_assignment;

CREATE TABLE `tbl_usertype_assignment` (
  `uta_id` bigint(21) NOT NULL AUTO_INCREMENT,
  `ut_id` int(11) NOT NULL DEFAULT '0',
  `hm_id` int(11) NOT NULL,
  `mm_id` int(11) DEFAULT NULL,
  `rm_id` int(11) DEFAULT NULL,
  `uta_status` int(11) DEFAULT '0',
  `uta_created_by` int(11) DEFAULT NULL,
  `uta_modify_by` int(11) NOT NULL DEFAULT '0',
  `uta_delete_by` int(11) NOT NULL DEFAULT '0',
  `uta_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `uta_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`uta_id`)
) ENGINE=InnoDB AUTO_INCREMENT=318 DEFAULT CHARSET=latin1;

INSERT INTO tbl_usertype_assignment VALUES("98","1","1","1","9","0","1","0","0","2018-12-29 10:14:42","");
INSERT INTO tbl_usertype_assignment VALUES("99","1","1","1","10","0","1","0","0","2018-12-29 10:14:42","");
INSERT INTO tbl_usertype_assignment VALUES("100","1","1","2","1","0","1","0","0","2018-12-29 10:14:42","");
INSERT INTO tbl_usertype_assignment VALUES("101","1","1","2","2","0","1","0","0","2018-12-29 10:14:42","");
INSERT INTO tbl_usertype_assignment VALUES("102","1","1","2","3","0","1","0","0","2018-12-29 10:14:42","");
INSERT INTO tbl_usertype_assignment VALUES("103","1","1","2","4","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("104","1","1","2","5","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("105","1","1","2","6","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("106","1","1","2","8","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("107","1","1","2","356","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("108","1","1","6","22","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("109","1","1","6","23","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("110","1","1","6","24","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("111","1","1","6","25","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("112","1","1","6","26","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("113","1","1","6","27","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("114","1","1","6","28","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("115","1","1","6","357","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("116","1","1","6","358","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("117","1","1","7","29","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("118","1","1","10","30","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("119","1","1","10","47","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("120","1","1","10","48","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("121","1","1","10","49","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("122","1","1","10","50","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("123","1","1","11","11","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("124","1","1","11","33","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("125","1","1","11","34","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("126","1","1","11","35","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("127","1","1","11","36","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("128","1","1","11","37","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("129","1","1","11","38","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("130","1","1","11","39","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("131","1","1","11","40","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("132","1","1","11","41","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("133","1","1","11","42","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("134","1","1","11","43","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("135","1","1","11","44","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("136","1","1","11","45","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("137","1","1","11","46","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("138","1","1","20","268","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("139","1","1","20","269","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("140","1","1","20","270","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("141","1","1","20","271","0","1","0","0","2018-12-29 10:14:43","");
INSERT INTO tbl_usertype_assignment VALUES("142","1","1","20","272","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("143","1","1","20","273","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("144","1","1","20","274","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("145","1","1","20","275","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("146","1","1","20","276","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("147","1","1","20","277","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("148","1","1","20","278","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("149","1","1","20","279","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("150","1","1","20","280","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("151","1","1","20","281","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("152","1","1","20","282","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("153","1","1","20","283","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("154","1","1","20","284","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("155","1","1","20","285","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("156","1","1","20","286","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("157","1","1","20","287","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("158","1","1","20","288","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("159","1","1","20","289","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("160","1","1","20","290","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("161","1","1","20","291","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("162","1","1","20","292","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("163","1","1","20","293","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("164","1","1","20","294","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("165","1","1","20","295","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("166","1","1","20","296","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("167","1","1","20","297","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("168","1","1","20","298","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("169","1","1","20","299","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("170","1","1","20","300","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("171","1","1","20","301","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("172","1","1","20","302","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("173","1","1","20","303","0","1","0","0","2018-12-29 10:14:44","");
INSERT INTO tbl_usertype_assignment VALUES("174","1","1","20","304","0","1","0","0","2018-12-29 10:14:45","");
INSERT INTO tbl_usertype_assignment VALUES("175","1","1","20","305","0","1","0","0","2018-12-29 10:14:45","");
INSERT INTO tbl_usertype_assignment VALUES("176","1","1","20","306","0","1","0","0","2018-12-29 10:14:45","");
INSERT INTO tbl_usertype_assignment VALUES("177","1","1","20","307","0","1","0","0","2018-12-29 10:14:45","");
INSERT INTO tbl_usertype_assignment VALUES("178","1","1","20","308","0","1","0","0","2018-12-29 10:14:45","");
INSERT INTO tbl_usertype_assignment VALUES("179","2","1","1","9","0","1","0","0","2018-12-29 10:14:48","");
INSERT INTO tbl_usertype_assignment VALUES("180","2","1","1","10","0","1","0","0","2018-12-29 10:14:48","");
INSERT INTO tbl_usertype_assignment VALUES("181","2","1","2","1","0","1","0","0","2018-12-29 10:14:48","");
INSERT INTO tbl_usertype_assignment VALUES("182","2","1","2","2","0","1","0","0","2018-12-29 10:14:48","");
INSERT INTO tbl_usertype_assignment VALUES("183","2","1","2","3","0","1","0","0","2018-12-29 10:14:48","");
INSERT INTO tbl_usertype_assignment VALUES("184","2","1","2","4","0","1","0","0","2018-12-29 10:14:48","");
INSERT INTO tbl_usertype_assignment VALUES("185","2","1","2","5","0","1","0","0","2018-12-29 10:14:48","");
INSERT INTO tbl_usertype_assignment VALUES("186","2","1","2","6","0","1","0","0","2018-12-29 10:14:48","");
INSERT INTO tbl_usertype_assignment VALUES("187","2","1","2","8","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("188","2","1","2","356","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("189","2","1","6","22","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("190","2","1","6","23","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("191","2","1","6","24","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("192","2","1","6","25","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("193","2","1","6","26","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("194","2","1","6","27","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("195","2","1","6","28","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("196","2","1","6","357","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("197","2","1","6","358","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("198","2","1","7","29","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("199","2","1","10","30","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("200","2","1","10","47","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("201","2","1","10","48","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("202","2","1","10","49","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("203","2","1","10","50","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("204","2","1","11","11","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("205","2","1","11","33","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("206","2","1","11","34","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("207","2","1","11","35","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("208","2","1","11","36","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("209","2","1","11","37","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("210","2","1","11","38","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("211","2","1","11","39","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("212","2","1","11","40","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("213","2","1","11","41","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("214","2","1","11","42","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("215","2","1","11","43","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("216","2","1","11","44","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("217","2","1","11","45","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("218","2","1","11","46","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("219","2","1","20","268","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("220","2","1","20","269","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("221","2","1","20","270","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("222","2","1","20","271","0","1","0","0","2018-12-29 10:14:49","");
INSERT INTO tbl_usertype_assignment VALUES("223","2","1","20","272","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("224","2","1","20","273","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("225","2","1","20","274","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("226","2","1","20","275","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("227","2","1","20","276","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("228","2","1","20","277","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("229","2","1","20","278","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("230","2","1","20","279","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("231","2","1","20","280","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("232","2","1","20","281","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("233","2","1","20","282","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("234","2","1","20","283","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("235","2","1","20","284","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("236","2","1","20","285","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("237","2","1","20","286","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("238","2","1","20","287","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("239","2","1","20","288","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("240","2","1","20","289","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("241","2","1","20","290","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("242","2","1","20","291","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("243","2","1","20","292","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("244","2","1","20","293","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("245","2","1","20","294","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("246","2","1","20","295","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("247","2","1","20","296","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("248","2","1","20","297","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("249","2","1","20","298","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("250","2","1","20","299","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("251","2","1","20","300","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("252","2","1","20","301","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("253","2","1","20","302","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("254","2","1","20","303","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("255","2","1","20","304","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("256","2","1","20","305","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("257","2","1","20","306","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("258","2","1","20","307","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("259","2","1","20","308","0","1","0","0","2018-12-29 10:14:50","");
INSERT INTO tbl_usertype_assignment VALUES("260","3","1","2","1","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("261","3","1","2","2","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("262","3","1","2","3","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("263","3","1","2","4","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("264","3","1","2","5","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("265","3","1","2","6","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("266","3","1","2","8","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("267","3","1","2","356","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("268","3","1","6","22","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("269","3","1","6","23","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("270","3","1","6","24","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("271","3","1","6","25","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("272","3","1","6","26","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("273","3","1","6","27","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("274","3","1","6","28","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("275","3","1","6","357","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("276","3","1","6","358","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("277","3","1","20","268","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("278","3","1","20","269","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("279","3","1","20","270","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("280","3","1","20","271","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("281","3","1","20","272","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("282","3","1","20","273","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("283","3","1","20","274","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("284","3","1","20","275","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("285","3","1","20","276","0","1","0","0","2018-12-29 10:14:56","");
INSERT INTO tbl_usertype_assignment VALUES("286","3","1","20","277","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("287","3","1","20","278","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("288","3","1","20","279","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("289","3","1","20","280","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("290","3","1","20","281","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("291","3","1","20","282","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("292","3","1","20","283","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("293","3","1","20","284","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("294","3","1","20","285","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("295","3","1","20","286","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("296","3","1","20","287","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("297","3","1","20","288","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("298","3","1","20","289","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("299","3","1","20","290","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("300","3","1","20","291","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("301","3","1","20","292","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("302","3","1","20","293","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("303","3","1","20","294","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("304","3","1","20","295","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("305","3","1","20","296","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("306","3","1","20","297","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("307","3","1","20","298","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("308","3","1","20","299","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("309","3","1","20","300","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("310","3","1","20","301","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("311","3","1","20","302","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("312","3","1","20","303","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("313","3","1","20","304","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("314","3","1","20","305","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("315","3","1","20","306","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("316","3","1","20","307","0","1","0","0","2018-12-29 10:14:57","");
INSERT INTO tbl_usertype_assignment VALUES("317","3","1","20","308","0","1","0","0","2018-12-29 10:14:57","");



DROP TABLE tbl_vac_patient_master;

CREATE TABLE `tbl_vac_patient_master` (
  `vac_id` int(11) NOT NULL AUTO_INCREMENT,
  `vac_pid` varchar(150) DEFAULT NULL,
  `vac_ref_id` varchar(150) DEFAULT NULL,
  `hm_id` int(11) DEFAULT NULL,
  `um_id` int(11) DEFAULT NULL,
  `rm_id` int(11) DEFAULT NULL,
  `other_ref` varchar(250) DEFAULT NULL,
  `vac_first_name` varchar(150) DEFAULT NULL,
  `vac_middle_name` varchar(150) DEFAULT NULL,
  `vac_last_name` varchar(150) DEFAULT NULL,
  `vac_gender` varchar(30) DEFAULT NULL,
  `vac_dob` date DEFAULT NULL,
  `vac_contact_no` varchar(150) DEFAULT NULL,
  `vac_email` varchar(150) DEFAULT NULL,
  `vac_address` varchar(150) DEFAULT NULL,
  `vac_city` varchar(50) DEFAULT NULL,
  `vac_state` varchar(50) DEFAULT NULL,
  `vac_pincode` varchar(50) DEFAULT NULL,
  `vac_country` varchar(50) DEFAULT NULL,
  `vac_blood_group` varchar(30) DEFAULT NULL,
  `vac_mediclaim` varchar(20) DEFAULT NULL,
  `vac_remarks` varchar(350) DEFAULT NULL,
  `vac_second_name` varchar(150) DEFAULT NULL,
  `vac_contact_no2` varchar(50) DEFAULT NULL,
  `vac_relation` varchar(50) DEFAULT NULL,
  `vac_del` int(11) DEFAULT '0',
  `vac_created_by` int(11) DEFAULT NULL,
  `vac_modify_by` int(11) DEFAULT NULL,
  `vac_delete_by` int(11) DEFAULT NULL,
  `vac_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `vac_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`vac_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_vaccine;

CREATE TABLE `tbl_vaccine` (
  `tvac_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL DEFAULT '0',
  `tvac_name` varchar(250) DEFAULT NULL,
  `tvg_id` int(11) NOT NULL DEFAULT '0',
  `tvc_id` int(11) NOT NULL DEFAULT '0',
  `tvgn_id` int(11) NOT NULL DEFAULT '0',
  `tvac_qty` int(11) NOT NULL DEFAULT '0',
  `tvac_location` varchar(150) DEFAULT NULL,
  `tvac_reorder_reminder` int(11) NOT NULL DEFAULT '0',
  `tvac_expire_reminder` int(11) NOT NULL DEFAULT '0',
  `tvac_del` int(11) NOT NULL DEFAULT '0',
  `tvac_created_by` int(11) NOT NULL DEFAULT '0',
  `tvac_modify_by` int(11) DEFAULT NULL,
  `tvac_delete_by` int(11) NOT NULL DEFAULT '0',
  `tvac_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tvac_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tvac_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_vaccine_company;

CREATE TABLE `tbl_vaccine_company` (
  `tvc_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL DEFAULT '3',
  `tvc_name` varchar(250) DEFAULT NULL,
  `tvc_del` int(11) NOT NULL DEFAULT '0',
  `tvc_created_by` int(11) NOT NULL DEFAULT '0',
  `tvc_modify_by` int(11) DEFAULT NULL,
  `tvc_delete_by` int(11) NOT NULL DEFAULT '0',
  `tvc_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tvc_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tvc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_vaccine_detail_master;

CREATE TABLE `tbl_vaccine_detail_master` (
  `vdm_id` int(11) NOT NULL AUTO_INCREMENT,
  `vdm_vm_id` int(11) DEFAULT NULL,
  `vdm_pid` longtext,
  `vdm_age` longtext,
  `vdm_vaccine_name` varchar(750) DEFAULT NULL,
  `vdm_due_date` date DEFAULT NULL,
  `vdm_given_date` date DEFAULT NULL,
  `vdm_remarks` longtext,
  `vdm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`vdm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_vaccine_generic;

CREATE TABLE `tbl_vaccine_generic` (
  `tvgn_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL DEFAULT '0',
  `tvgn_name` varchar(250) DEFAULT NULL,
  `tvgn_del` int(11) NOT NULL DEFAULT '0',
  `tvgn_created_by` int(11) NOT NULL DEFAULT '0',
  `tvgn_modify_by` int(11) DEFAULT NULL,
  `tvgn_delete_by` int(11) NOT NULL DEFAULT '0',
  `tvgn_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tvgn_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tvgn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_vaccine_group;

CREATE TABLE `tbl_vaccine_group` (
  `tvg_id` int(11) NOT NULL AUTO_INCREMENT,
  `hos_id` int(11) NOT NULL,
  `tvg_name` varchar(250) DEFAULT NULL,
  `tvg_del` int(11) NOT NULL DEFAULT '0',
  `tvg_created_by` int(11) NOT NULL DEFAULT '0',
  `tvg_modify_by` int(11) DEFAULT NULL,
  `tvg_delete_by` int(11) NOT NULL DEFAULT '0',
  `tvg_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tvg_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tvg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_vaccine_patient;

CREATE TABLE `tbl_vaccine_patient` (
  `tvp_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_pid` varchar(500) DEFAULT NULL,
  `tvp_temp_id` int(11) NOT NULL DEFAULT '0',
  `tvp_given_date` date DEFAULT NULL,
  `tvp_remarks` varchar(750) DEFAULT NULL,
  `tvp_created_by` int(11) NOT NULL DEFAULT '0',
  `tvp_modify_by` int(11) NOT NULL DEFAULT '0',
  `tvp_create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tvp_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tvp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_vaccine_patient_vacc;

CREATE TABLE `tbl_vaccine_patient_vacc` (
  `tvpv_id` int(11) NOT NULL AUTO_INCREMENT,
  `tvp_id` int(11) NOT NULL DEFAULT '0',
  `tvpv_temp_id` int(11) NOT NULL DEFAULT '0',
  `pm_pid` varchar(500) DEFAULT NULL,
  `tvpv_user` int(11) NOT NULL DEFAULT '0',
  `tvpv_vaccine` int(11) NOT NULL DEFAULT '0',
  `tvpv_vaccine_all` varchar(500) DEFAULT NULL,
  `tvpv_route` varchar(500) DEFAULT NULL,
  `tvpv_dose` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`tvpv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_vaccine_templete;

CREATE TABLE `tbl_vaccine_templete` (
  `tvt_id` int(11) NOT NULL AUTO_INCREMENT,
  `tvt_age` varchar(500) DEFAULT NULL,
  `tvt_due_day` int(11) NOT NULL DEFAULT '0',
  `tvt_due_month` int(11) NOT NULL DEFAULT '0',
  `tvt_due_year` int(11) NOT NULL DEFAULT '0',
  `tvt_mg_day` int(11) NOT NULL DEFAULT '0',
  `tvt_mg_month` int(11) NOT NULL DEFAULT '0',
  `tvt_mg_year` int(11) NOT NULL DEFAULT '0',
  `tvt_created_by` int(11) NOT NULL DEFAULT '0',
  `tvt_modify_by` int(11) NOT NULL DEFAULT '0',
  `tvt_deleted_by` int(11) NOT NULL DEFAULT '0',
  `tvt_del` int(11) NOT NULL DEFAULT '0',
  `tvt_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tvt_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tvt_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_vaccine_templete_vac;

CREATE TABLE `tbl_vaccine_templete_vac` (
  `tvtv_id` int(11) NOT NULL AUTO_INCREMENT,
  `tvt_id` int(11) NOT NULL DEFAULT '0',
  `tvtv_name` varchar(500) DEFAULT NULL,
  `tvtv_route` varchar(500) DEFAULT NULL,
  `tvtv_dose` varchar(500) DEFAULT NULL,
  `tvtv_del` int(11) NOT NULL DEFAULT '0',
  `tvtv_created_by` int(11) NOT NULL DEFAULT '0',
  `tvtv_modify_by` int(11) NOT NULL DEFAULT '0',
  `tvtv_deleted_by` int(11) NOT NULL DEFAULT '0',
  `tvtv_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tvtv_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tvtv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_ward_management;

CREATE TABLE `tbl_ward_management` (
  `twm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `ward_name` varchar(150) DEFAULT NULL,
  `twm_del` int(11) NOT NULL DEFAULT '0',
  `twm_created_by` int(11) NOT NULL DEFAULT '0',
  `twm_modify_by` int(11) DEFAULT NULL,
  `twm_delete_by` int(11) DEFAULT NULL,
  `twm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `twm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`twm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE tbl_ward_room_management;

CREATE TABLE `tbl_ward_room_management` (
  `twrm_id` int(11) NOT NULL AUTO_INCREMENT,
  `hm_id` int(11) NOT NULL DEFAULT '0',
  `twm_id` int(11) DEFAULT NULL,
  `room_type` varchar(50) DEFAULT NULL,
  `room_name` varchar(150) DEFAULT NULL,
  `twrm_status` int(11) NOT NULL DEFAULT '0',
  `twrm_block` int(11) NOT NULL DEFAULT '0',
  `twrm_del` int(11) NOT NULL DEFAULT '0',
  `twrm_created_by` int(11) NOT NULL DEFAULT '0',
  `twrm_modify_by` int(11) DEFAULT NULL,
  `twrm_delete_by` int(11) DEFAULT NULL,
  `twrm_created_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `twrm_modify_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`twrm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




